<%--
    Document   : Login
    Created on : Jan 6, 2017, 2:43:53 PM
    Author     : skummali
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html lang="en">

<head>
<jsp:include page="/common/search-engine.jsp" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description" content="">
<meta name="author" content="CommVault">
<title>ObjectStore Login</title>
<style>
	body {
	    background-color: #0B2E44;
	    text-align: center;
	}

	input {
		margin-top: 14px;
    	padding: 10px 0px;
    	width: 100%;
	}

	.noselect {
  		-webkit-touch-callout: none; /* iOS Safari */
    	-webkit-user-select: none; /* Safari */
     	-khtml-user-select: none; /* Konqueror HTML */
       	-moz-user-select: none; /* Firefox */
        -ms-user-select: none; /* Internet Explorer/Edge */
        user-select: none; /* Non-prefixed version, currently
                                  supported by Chrome and Opera */
	}

	.cos_container{
		margin-top: 5%;
	 	width: 35%;
    	margin-left: auto;
    	margin-right: auto
	}

	.cos_title{
		font-size: 2.625rem;
	    font-weight: 600;
	    color: white;
	    font-family: "Segoe UI", "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;
	}

	.cos_textBox {
		background-color: white;
	    border: 1px solid #d2d2d2;
	    padding-left: 1px;
	    color: black;
	}

	.cos_button {
		background-color: #0B2E44;
    	color: #fff;
    	border: 1px solid #fff;
	}

	.cos_msg {
		color:white;
		margin-top: 15px;
	}
	.cos_alert_info {
		color:white;
		font-size: 14px;
		margin-top: 80px;
	}

	.cos_dialog {
		display: none;
		margin-top: 3%;
	 	width: 65%;
    	margin-left: auto;
    	margin-right: auto;
    	background-color: whitesmoke;
    	padding: 14px 20px 20px 20px;
    	box-shadow: 0px 1px 13px 0px #000000;
	}

	.cos_dialog_msg {
		margin-top: 22px;
		display: none;
	}

	.cos_dialog_btn_holder {
		margin-top: 20px;
		padding: 5px;
		color: white;
	}

	.cos_dialog_btn_holder span {
		box-shadow: 0px 0px 1px 0px #000000;
		background-color: #0B2E44;
    	border: 1px solid black;
		cursor: default;
	}

	.cos_dialog_btn_holder span.disabled {
		pointer-events: none;
		background-color: #3e6686;
	}

	.cos_dialog_btn_holder span:ACTIVE {
		background-color: #3e6686;
	}

	.cos_dialog_btn {
		margin-top: 20px;
    	padding: 5px;
    	color: white;
    }

	.cos_dialog_btn.accept {
		display: none;
		background-color: #5d9a35;
    	border: 1px solid #39794f;
	}

	.cos_dialog_btn.reject {
		display: none;
		background-color: #e01313;
    	margin-left: 10px;
    	border: 1px solid #b51f00;
	}

	.cos_dialog_btn.confAlert {
		display: none;

	}

	.cos_dialog_btn.finSetup {
		display: none;
	}

	.cos_dialog_btn.close {
		display: none;
	}

	.cos_dialog_msg ol {
		text-align: left;
    	margin-right: 30px;
    	margin-left: 10px;
	}

	.cos_dialog_msg li {
		margin: 8px 0;
	}

	.cos_dialog_msg .alert_name {
		color: #e6e6e6;
    	background-color: #4e4e4e;
    	margin-top: 10px;
    	margin-bottom: 10px;
    	padding: 5px;
    	width: fit-content;
	}

	.cos_dialog_msg .workflow_name {
		font-weight: bold;
    	font-size: 15px;
	}

</style>
</head>

<body>

	<div class="cos_container">
		<div class="cos_title">ObjectStore</div>
		<div id="login_form">
	    	<div>
	  			<input type="text" id="txt_username" name="username" placeholder="Username" class="cos_textBox">
	    	</div>
	    	<div>
	  			<input type="password" id="txt_password" placeholder="Password" name="password" class="cos_textBox">
	    	</div>
	    	<div>
	  			<input type="text" id="txt_endpoint" name="endpoint" placeholder="ObjectStore Webservice URL" class="cos_textBox">
	    	</div>
	    	<div>
	    		<input type="button" value="Login" id="btn_save" class="cos_button">
	    	</div>
    	</div>
    	<div class="cos_msg"></div>
	</div>

	<div class="cos_dialog">
		<div class="cos_dialog_heading">Login Success</div><hr>
		<div class="cos_dialog_msg enableAlert">Do you want to enable Edge Drive Alerts ?</div>
		<div class="cos_dialog_msg confAlert">
			<ol>
				<li>Create an Edge Drive Alert from Commcell Console with name<strong>:</strong>
					<div class="alert_name"></div>
					Choose Notification Type as Workflow and select <span class="workflow_name">HTTP Callback for Jive Notification</span> as the workflow to run.</li>
				<li>Click on the Configure Alert button once the Alert is created.</li>
			</ol>
		</div>
		<div class="cos_dialog_msg finSetup"></div>
		<div class="cos_dialog_btn_holder">
			<span class="cos_dialog_btn enableAlert accept noselect">Yes</span>
			<span class="cos_dialog_btn enableAlert reject noselect">No</span>
			<span class="cos_dialog_btn confAlert noselect">Configure Alert</span>
			<span class="cos_dialog_btn finSetup noselect">Finish</span>
		</div>
	</div>

	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >

				function showMessage(message) {
					$(".cos_msg").text(message);
				}

				function hideMessage() {
					$(".cos_msg").text("");
				}

				function showEnableAlertDialog() {
					$('.cos_dialog_heading').text("Login Success");
					$('.cos_dialog .enableAlert').show();
					$('.cos_dialog').show();
				}

				function showConfAlertDialog() {
					$('.cos_dialog .enableAlert').hide();
					$('.cos_dialog_heading').text("Steps to Configure Alert");
					$('.cos_dialog .confAlert').show();
					$('.cos_dialog').show();
				}

				function showFinSetupDialog(message) {
					$('.cos_dialog .enableAlert').hide();
					$('.cos_dialog .confAlert').hide();
					$('.cos_dialog_heading').text("Login Success");
					$('.cos_dialog_msg.finSetup').text(message);
					$('.cos_dialog .finSetup').show();
					$('.cos_dialog').show();
				}

                jive.tile.onOpen(function (config, options) {
                	gadgets.window.adjustHeight(400);
                	$("#txt_username").focus();
                	$(".cos_dialog_btn").click(dialogBtnClickHandler);
                	$("#btn_save").click(function () {
                		hideMessage();

                        var username = $("#txt_username").val();
                        var password = $("#txt_password").val();
                        var endpoint = $("#txt_endpoint").val();
                        var serviceUrl = jive.tile.getAddonServiceURL();

                        if(username.trim() === "" || password.trim() === "" || endpoint.trim() === "" || serviceUrl.trim() === ""){
                        	showMessage("All fields are required.");
                        	return;
                        }

                        $("#btn_save").val("Logging in");

                        var params = {
                            "username": username,
                            "password": password,
                            "endpoint": endpoint,
                            "serviceUrl": serviceUrl
                        };

                        var payload = {
                            "href": serviceUrl + '/JiveEsf/Config',
                            "authz": 'signed',
                            "headers": {
                                    "Content-Type": ["application/x-www-form-urlencoded; charset=utf-8"]
                            },
                            "body": $.param(params)
                        };

                        osapi.http.post(payload).execute(function (response) {
                            $("#login_form").hide();
                            $("#btn_save").val("Login");
                            if (response.error) {
                            	showMessage("Login Failed");
                            } else {
                                if (response.content) {
                                	var reponseObj = JSON.parse(response.content);
                                	if(reponseObj.status === "Success"){
                                		$('.alert_name').text("Jive Notification " + reponseObj.tenantId);
                                		gadgets.window.adjustHeight(400);
                                		showEnableAlertDialog();
                                		if(reponseObj.oauthUrl){
                                    		$('.cos_dialog_btn.finSetup').attr("oauthUrl", reponseObj.oauthUrl);
                                    	} else {
                                    		$('.cos_dialog_btn.finSetup').attr("oauthUrl", "NONE");
                                    	}
                                	} else {
                                		showMessage("Login Failed");
                                    }
                                } else {
                                	showMessage("Login Failed");
                                }
                            }
                        });
                    });

                });

                function doConfigureAlert(confAlertBtn) {
					$(confAlertBtn).addClass('disabled');
					var alertPayload = {
			                "href": jive.tile.getAddonServiceURL() + '/JiveEsf/Config?alert=true',
			                "authz": 'signed',
			                "headers": {
			                        "Content-Type": ["application/x-www-form-urlencoded; charset=utf-8"]
			                }
			        };

					osapi.http.post(alertPayload).execute(function (response) {
						$(confAlertBtn).removeClass('disabled');
			            if (response.error) {
			            	showFinSetupDialog("Failed to Associate Edge Drive Alert");
			            } else {
			                if (response.content) {
			                	var reponseObj = JSON.parse(response.content);
			                	if(reponseObj.status === "Success"){
			                		showFinSetupDialog("Successfully Configured Edge Drive Alert");
			                	} else {
			                		showFinSetupDialog("Failed to Associate Edge Drive Alert");
			                    }
			                } else {
			                	showFinSetupDialog("Failed to Associate Edge Drive Alert");
			                }
			            }
			        });
				}

				function dialogBtnClickHandler (e) {
					if($(this).hasClass("accept")) {
						showConfAlertDialog();
					} else if($(this).hasClass("reject")) {
						$('.cos_dialog_heading').text("Login Success");
						showFinSetupDialog();
					} else if($(this).hasClass("confAlert")) {
						doConfigureAlert(this);
					} else if($(this).hasClass("finSetup")) {
						var oauthUrl = $('.cos_dialog_btn.finSetup').attr("oauthUrl");
						jive.tile.close({}, {});
                    	if(oauthUrl){
                    		window.open(oauthUrl, "_blank","width=1200, height=400");
                    	}
					}
				}
     </script>

</body>

</html>
