<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ page import="java.util.*"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<div class="content">
		<br>
		<div class="subsec-body" id="appList">
			<ul class="secrowhead secrows">
				<li class="services1"><fmt:message
						key="Services_Table_Service_Name" /></li>
				<li class="services2"><fmt:message
						key="Services_Table_Application_Name" /></li>
				<li class="services3"><fmt:message
						key="Services_Table_Application_Id" /></li>
				<li class="services5"><fmt:message
						key="Services_Table_Running_Time" /></li>
			</ul>
			<c:set var="selectedDeviceInfo"
				value="${requestScope.RUNNING_SERVICES}" />
			<c:forEach var="item" items="${selectedDeviceInfo}">
				<ul class="secrows oddhighlight">
					<li class="services1">${item.serviceName}</li>
					<li class="services2">${item.applicationName}</li>
					<li class="services3">${item.applicationId}</li>
					<li class="services5"><fmt:formatNumber
							value="${item.runningTime/1000/60/60}" maxFractionDigits="0" />hrs<fmt:formatNumber
							value="${item.runningTime/1000/60%60}" maxFractionDigits="0" />mins
						<fmt:formatNumber value="${item.runningTime/1000%60}"
							maxFractionDigits="0" />secs</li>

				</ul>
			</c:forEach>
		</div>
	</div>
</fmt:bundle>