<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<div class="content">
		<input type="checkbox" id="unregCheck">
		<fmt:message key="Show_Unregistered_Devices_Checkbox" />
		<div class="subsec-body clientJobs">
			<ul class="secrowhead secrows">
				<li class="l1"><input type="checkbox" id="alldevice"></li>
				<li class="li1"><fmt:message key="Device_Table_Type" /></li>
				<li class="li2_new"><fmt:message key="Entity_Name" /></li>
				<li class="li3_new"><fmt:message key="Device_Table_User" /></li>
				<li class="li5"><fmt:message key="Policy" /></li>
				<li class="li6"><fmt:message key="Device_Table_Apps" /></li>
				<li class="li7"><fmt:message key="Last_Updated" /></li>
				<li class="li8"><fmt:message key="Device_Table_Status" /></li>
			</ul>
			<c:set var="registeredDevicesInfo"
				value="${requestScope.REGISTERED_DEVICES}" />
			<c:if test="${registeredDevicesInfo.error.errorCode == 0}">
				<c:set var="registeredDevicesList"
					value="${registeredDevicesInfo.devices}" />
				<div class="browseDataRows">
					<c:choose>
						<c:when test="${fn:length(registeredDevicesList) > 0}">
							<c:forEach var="item" items="${registeredDevicesList}">
								<c:set var="licenseToken" value="false" />
								<c:set var="deviceAdminEnabled" value="true" />
								<c:forEach var="attr" items="${item.device.attributes}">
									<c:choose>
										<c:when test="${attr.name=='deviceType' }">
											<c:if test="${attr.value==1}">
												<c:set var="typeimg" value="/mdm/img/android.png" />
											</c:if>
											<c:if test="${attr.value==2}">
												<c:set var="typeimg" value="/mdm/img/apple.png" />
											</c:if>
										</c:when>
										<c:when test="${attr.name=='phoneNo' }">
											<c:set var="phoneNo" value="${attr.value}" />
										</c:when>
										<c:when test="${attr.name=='App_Installed_count' }">
											<c:set var="appCount" value="${attr.value}" />
										</c:when>
										<c:when test="${attr.name=='licenseToken' }">
											<c:set var="licenseToken" value="${attr.value}" />
										</c:when>
										<c:when test="${attr.name=='deviceAdminEnabled' }">
											<c:set var="deviceAdminEnabled" value="${attr.value}" />
										</c:when>
									</c:choose>
								</c:forEach>
								<ul id="devicesContainer" class="secrows oddRow oddhighlight">
									<li class="l1"><input type="checkbox" id="device"
										class="device devicesCheck" value="${item.device.deviceId}"
										name="device2"> <input class="licenseToken"
										value="${licenseToken}" type=hidden> <input
										class="deviceAdminEnabled" value="${deviceAdminEnabled}"
										type=hidden></li>
									<li class="li1"><img
										src="${pageContext.request.contextPath}${typeimg}"
										alt="${item.device.deviceType}" /></li>
									<c:set var="typeimg" value="" />
									<c:if test="${item.device.deviceId!=0}">
										<li class="li2_new"><a
											href="../mdm/deviceDetails.jsp?Id=${item.device.deviceId}">${item.device.deviceName}</a></li>
									</c:if>
									<c:if test="${item.device.deviceId==0}">
										<li class="li2_new">${item.device.deviceName}</li>
									</c:if>
									<li class="li3_new">${item.mdmUser.user.userName}</li>
									<%-- <li class="li4">${phoneNo}</li> --%>
									<li class="li5">${item.policy.policyName}</li>
									<li class="li6">${appCount}</li>
									<c:set var="appCount" value="0" />
									<c:set var="modified" value="${item.device.updated}" />
									<li class="date li7" value="${item.device.updated}"></li>
									<c:if test="${item.device.deviceId == 0 }">
										<li class="li8">Unregistered</li>
									</c:if>

									<c:forEach var="polAttr" items="${item.policy.attributes}">
										<c:if test="${polAttr.name=='synctime'}">
											<c:set var="synctime" value="${polAttr.value}" />
										</c:if>
									</c:forEach>

									<c:if test="${item.device.deviceId != 0 }">
										<c:choose>
											<c:when test="${licenseToken==false}">
												<li class="li8"><fmt:message
														key="Device_Status_No_License" /></li>
											</c:when>
											<c:when test="${deviceAdminEnabled==false}">
												<li class="li8"><fmt:message
														key="Device_Status_Admin_Disabled" /></li>
											</c:when>
											<c:when test="${synctime > item.device.updated}">
												<li class="li8"><fmt:message
														key="Device_Status_Inactive" /></li>

											</c:when>
											<c:otherwise>
												<li class="li8"><fmt:message key="Device_Status_Active" /></li>
											</c:otherwise>
										</c:choose>
									</c:if>
								</ul>
							</c:forEach>
						</c:when>
						<c:otherwise>
							<h2>No Registered Devices</h2>
						</c:otherwise>
					</c:choose>
				</div>
			</c:if>
			<c:if test="${registeredDevicesInfo.error.errorCode != 0}">
				<h2>No Registered Devices</h2>
			</c:if>
		</div>
	</div>
</fmt:bundle>