<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<c:set var="policyInfo" value="${requestScope.POLICY_PROPERTIES}" />
	<c:if test="${policyInfo.error.errorCode==0}">
		<c:set var="policiesList" value="${policyInfo.policies}" />
		<c:choose>
			<c:when test="${fn:length(policiesList) == 1}">
				<c:forEach var="item" items="${policiesList}">
					<h1 class="subtitle">${item.policyName}</h1>
					<br>
					<br>
					<div class="policyInfo">
						<h2 class="subtitle"><fmt:message key="Policy_Info_Title" /></h2>
						<br> <br>
						<hr>
						<%-- <label class="label">Policy Id:</label>${item.policyId}<br> --%>
						<%-- <label class="label">Policy Name:</label>${item.policyName}<br> --%>
						<label class="label">Created:</label> <label class="date"
							value="${item.created}"></label><br> <label class="label">Modified:</label>
						<label class="date" value="${item.modified}"></label><br> <br>
					</div>
					<div class="passwordSec">
						<h2 class="subtitle"><fmt:message key="Policy_Security_Title" /></h2>
						<br> <br>
						<hr>
						<c:forEach var="attr" items="${item.attributes}">
							<c:if
								test="${attr.name!='usage' && attr.name!='apps' && attr.name!='Reset password' && attr.name!='setlock'}">
								<label class="label"><fmt:message key="${attr.name}" />:</label>${attr.value}<br>
							</c:if>
						</c:forEach>
					</div>
					<div class="devices">
						<h2 class="subtitle"><fmt:message key="Policy_Devices_Title" /></h2>
						<br> <br>
						<hr>
						<div id="deviceList"></div>
					</div>
				</c:forEach>
			</c:when>
			<c:otherwise>
				<h2>Policy properties empty</h2>
			</c:otherwise>
		</c:choose>
	</c:if>
	<c:if test="${policyInfo.error.errorCode!=0}">
		<h2>Policy properties empty</h2>
	</c:if>
</fmt:bundle>

