<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<div class="content">
		<div class="subsec-body clientJobs">
			<ul class="secrowhead secrows">
				<li class="l1"><input type="checkbox" id="allpolicy"></li>
				<li class="li2"><fmt:message key="Entity_Name" /></li>
				<li class="li2_new"><fmt:message key="Entity_Created" /></li>
				<li class="li3_new"><fmt:message key="Last_Updated" /></li>
				<li class="li5"><fmt:message key="Policy_Table_Devices_Count" /></li>
			</ul>
			<c:set var="policyInfo" value="${requestScope.POLICIES}" />
			<c:if test="${policyInfo.error.errorCode == 0 }">
				<c:set var="policiesList" value="${policyInfo.policies}" />
				<div class="browseDataRows">
					<c:choose>
						<c:when test="${fn:length(policiesList) > 0}">
							<c:forEach var="item" items="${policiesList}">
								<ul class="secrows oddRow oddhighlight">
									<li class="l1"><input type="checkbox" id="policy"
										class="policy policiesCheck" value="${item.policyId}"
										name="policy"></li>
									<li class="li1 policyName"><a
										href="../mdm/policyDetails.jsp?policyId=${item.policyId}&policyName=${item.policyName}&type=show">${item.policyName}</a></li>

									<li class="li2 date" value="${item.created}"></li>
									<li class="li3 date" value="${item.modified}"></li>
									<c:set var="count" value="0" />
									<c:forEach var="attr" items="${item.attributes}">
										<c:if test ="${attr.name=='deviceCount'}">
										<c:set var="count" value="${attr.value}" />
										</c:if>
									</c:forEach>
									<li class="li5 deviceCount">${count}</li>
									<li class="li6 editPolicy" value="${item.policyId}"><img src="img/edit.png" />Edit</li>
								</ul>
							</c:forEach>
						</c:when>
						<c:otherwise>
							<h2>No policies</h2>
						</c:otherwise>
					</c:choose>
				</div>
			</c:if>
			<c:if test="${policyInfo.error.errorCode != 0}">
				<h2>No Policies</h2>
			</c:if>
		</div>
	</div>
</fmt:bundle>