<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<c:set var="longitude" value="0.0" />
	<c:set var="latitude" value="0.0" />
	<c:set var="proxAlert" value="false" />
	<fmt:message key="Disable_Camera_Button" var="camBtnName" />
	<fmt:message key="Disable_Wifi_Button" var="wifiBtnName" />
	<fmt:message key="Disable_Bluetooth_Button" var="bluetoothBtnName" />
	<fmt:message key="Set_Proximity_Alert" var="proximityBtnName" />
	<fmt:message key="Encrypt_Storage_Button" var="encryptionBtnName" />
	<c:set var="selectedDeviceInfo" value="${requestScope.DEVICE_PROPS}" />
	<h2 class="subtitle">${selectedDeviceInfo.device.deviceName}</h2>
	<br>
	<br>
	<div class="deviceInfo">
		<h2 class="subtitle">
			<fmt:message key="Device_Info_Title" />
		</h2>
		<br> <br>
		<hr>
		<c:forEach var="item" items="${selectedDeviceInfo.device.attributes}">
			<c:if test="${item.name == 'latitude'}">
				<c:set var="latitude" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'longitude'}">
				<c:set var="longitude" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'proxLatitude'}">
				<c:set var="proxLatitude" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'proxLongitude'}">
				<c:set var="proxLongitude" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'proxRadius'}">
				<c:set var="proxRadius" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'proxEnabled'}">
				<c:set var="proxEnabled" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'licenseToken'}">
				<c:set var="licenseToken" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'deviceAdminEnabled'}">
				<c:set var="deviceAdminEnabled" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'App_Installed_count'}">
				<c:set var="appCount" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'proxAlert'}">
				<c:set var="proxAlert" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'policyId'}">
				<c:set var="currentPolicy" value="${item.value}" />
			</c:if>
			<c:if test="${item.name == 'Allow_use_of_Camera'}">
				<c:if test="${item.value=='No'}">
					<fmt:message key="Enable_Camera_Button" var="camBtnName" />
				</c:if>
			</c:if>
			<c:if test="${item.name == 'proximityAlert'}">
				<c:if test="${item.value=='true'}">
					<fmt:message key="Remove_Proximity_Alert" var="proximityBtnName" />
				</c:if>
			</c:if>
			<c:if test="${item.name == 'Wifi_Enabled'}">
				<c:if test="${item.value=='No'}">
					<fmt:message key="Enable_Wifi_Button" var="wifiBtnName" />
				</c:if>
			</c:if>
			<c:if test="${item.name == 'Bluetooth_Enabled'}">
				<c:if test="${item.value=='No'}">
					<fmt:message key="Enable_Bluetooth_Button" var="bluetoothBtnName" />
				</c:if>
			</c:if>
			<c:if test="${item.name == 'Encryption_level'}">
				<c:if test="${item.value=='Active'}">
					<fmt:message key="Decrypt_Storage_Button" var="encryptionBtnName" />
				</c:if>
			</c:if>

		</c:forEach>



		<h1 class="SubDeviceInfo">
			<fmt:message key="HARDWARE_OS" />
		</h1>
		<c:forEach var="item" items="${selectedDeviceInfo.device.attributes}">
			<c:if test="${item.valueType==2}">
				<c:choose>
					<c:when test="${item.name=='Up_time'}">
						<label class="label"><fmt:message key="${item.name}" />:</label>
						<fmt:formatNumber value="${item.value/1000/60/60}"
							maxFractionDigits="0" />hrs<fmt:formatNumber
							value="${item.value/1000/60%60}" maxFractionDigits="0" />mins
				<fmt:formatNumber value="${item.value/1000%60}"
							maxFractionDigits="0" />secs
					<br>
					</c:when>
					<c:otherwise>
						<label class="label"><fmt:message key="${item.name}" />:</label>${item.value}
					<br>
					</c:otherwise>
				</c:choose>
			</c:if>
		</c:forEach>
		<br>
		<h1 class="SubDeviceInfo">
			<fmt:message key="SECURITY_COMPLIANCE" />
		</h1>
		<c:forEach var="item" items="${selectedDeviceInfo.device.attributes}">
			<c:if test="${item.valueType==4}">
				<label class="label"><fmt:message key="${item.name}" />:</label>${item.value}
					<br>
			</c:if>
		</c:forEach>
		<br>
		<h1 class="SubDeviceInfo">
			<fmt:message key="NETWORK_INFORMATION" />
		</h1>
		<c:forEach var="item" items="${selectedDeviceInfo.device.attributes}">
			<c:if test="${item.valueType==8}">
				<c:choose>
					<c:when test="${item.name=='SIM_State'}">
						<label class="label"><fmt:message key="${item.name}" />:</label>
						<span id="SimState">${item.value}</span>
					</c:when>
					<c:otherwise>
						<label class="label"><fmt:message key="${item.name}" />:</label>${item.value}
			</c:otherwise>
				</c:choose>
				<br>
			</c:if>
		</c:forEach>
		<br>

	</div>
	<div class="action">
		<h2 class="subtitle">
			<fmt:message key="Actions_Title" />
		</h2>
		<br> <br>
		<hr>
		<input type="hidden" id="licenseToken" value="${licenseToken}">
		<input type="hidden" id="deviceAdminEnabled" value="${licenseToken}">
		<input type="hidden" id="currentPolicy" value="${currentPolicy}">
		<input type="button" id="changePolicyBtn" name="changePolicyBtn"
			class="mainBtn" value="<fmt:message key="Change_Policy_Button" />">
		<input type="button" id="lockBtn" name="lockBtn" class="mainBtn"
			value="<fmt:message key="Lock_Button" />"> <input
			type="button" id="wipeBtn" name="wipeBtn" class="mainBtn"
			value="<fmt:message key="Wipe_Button" />"> <input
			type="button" id="setPasswordBtn" name="setPasswordBtn"
			class="mainBtn" value="<fmt:message key="Set_Password_Button" />">
		<input type="button" id="disableCameraBtn" name="disableCameraBtn"
			class="mainBtn" value="${camBtnName}"> <input type="button"
			id="disableWifiBtn" name="disableWifiBtn" class="mainBtn"
			value="${wifiBtnName}"> <input type="button"
			id="disableBluetoothBtn" name="disableBluetoothBtn" class="mainBtn"
			value="${bluetoothBtnName}"> <input type="button"
			id="RefreshPropBtn" name="RefreshPropBtn" class="mainBtn"
			value="<fmt:message key="Refresh_Properties_Button" />"> <input
			type="button" id="buzzBtn" name="buzzBtn" class="mainBtn"
			value="<fmt:message key="Buzz_Button" />"> <input
			type="button" id="messageBtn" name="messageBtn" class="mainBtn"
			value="<fmt:message key="Message_Button" />">
		<%-- <input
			type="button" id="encryptionBtn" name="encryptionBtn" class="mainBtn"
			value="${encryptionBtnName}"> --%>
	</div>
	<br>
	<br>
	<div class="apps">
		<h1 class="subtitle">
			<fmt:message key="Applications_Title" />
		</h1>
		<br> <br>
		<hr>
		<div id="installedapps">
			<p id="appCount">${appCount}</p>
			<br>
			<p id="installed">
				<fmt:message key="Applications_Installed" />
			</p>
		</div>
	</div>
	<div class="location">
		<h2 class="subtitle">
			<fmt:message key="Location_Title" />
		</h2>
		<input type="button" id="searchBtn" name="searchBtn" class="mainBtn"
			value="<fmt:message key="Refresh_Location_Button"/>"> <input
			type="button" id="proximityBtn" name="proximityBtn" class="mainBtn"
			value="${proximityBtnName}"> <input type="button"
			id="remProximityBtn" name="remProximityBtn" class="mainBtn"
			value="<fmt:message key="Remove_Proximity_Alert"/>"> <br>
		<fmt:message key="Proximity_Radius" />
		<input type="number" id="proximityKms" name="proximityKms"
			class="smalltextbox"
			value=<fmt:formatNumber value="${proxRadius/1000}" maxFractionDigits="0" />
			min="0" />
		<fmt:message key="Kilometer" />
		<input type="number" id="proximityMs" name="proximityMs"
			class="smalltextbox" min="0" max="999" value="${proxRadius%1000}" />
		<fmt:message key="Meter" />

		<c:if test="${proxEnabled=='true'}">
			<c:if test="${proxAlert =='false'}">
				<p style="color: red">
					<fmt:message key="Out_Radius" />
				</p>
			</c:if>
			<c:if test="${proxAlert =='true'}">
				<p style="color: green">
					<fmt:message key="In_Radius" />
				</p>
			</c:if>
		</c:if>


		<div id='map'></div>
		<input type="hidden" id="latitude" value="${latitude}"> <input
			type="hidden" id="longitude" value="${longitude}"> <input
			type="hidden" id="proxEnabled" value="${proxEnabled}">
		<c:choose>
			<c:when test="${proxEnabled=='true'}">
				<input type="hidden" id="proxLongitude" value="${proxLongitude}">
				<input type="hidden" id="proxLatitude" value="${proxLatitude}">
			</c:when>
			<c:otherwise>
				<input type="hidden" id="proxLongitude" value="${longitude}">
				<input type="hidden" id="proxLatitude" value="${latitude}">
			</c:otherwise>
		</c:choose>
	</div>
</fmt:bundle>
