<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<c:set var="css" value="css/mdm.css" />
	<div class="content">
		<div class="subsec-body clientJobs">
			<ul class="secrowhead secrows">
				<li class="li2"><fmt:message key="Actions_Table_Name" /></li>
				<li class="li3"><fmt:message key="Actions_Table_Status" /></li>
				<li class="li4"><fmt:message key="Actions_Table_Time" /></li>
			</ul>
			<c:set var="actionInfo" value="${requestScope.ACTIONS}" />
			<c:if test="${actionInfo.error.errorCode == 0}">
				<c:set var="actionsList" value="${actionInfo.actions}" />
				<div class="browseDataRows ">
					<c:choose>
						<c:when test="${fn:length(actionsList) > 0}">
							<c:forEach var="item" items="${actionsList}">
								<ul class="secrows oddRow oddhighlight">
									<li class="li2"><fmt:message key="${item.action.mdmActionType}" /></li>
									<li class="li3"><fmt:message key="${item.status}" /></li>
									<li class="li7 date" value="${item.actionTime}"></li>
								</ul>
							</c:forEach>
						</c:when>
						<c:otherwise>
							<h2>No Actions</h2>
						</c:otherwise>
					</c:choose>
				</div>
			</c:if>
			<c:if test="${actionInfo.error.errorCode != 0}">
				<h2>No actions performed</h2>
			</c:if>
		</div>
	</div>
</fmt:bundle>