<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.mdmMessages">
	<jsp:include page="../common/jquery.jsp">
		<jsp:param value="MDM" name="title" />
	</jsp:include>

	<c:set var="css" value="css/mdm.css" />
	<link rel="stylesheet" type="text/css" href="css/mdm.css" />
	<link rel="stylesheet" type="text/css" href="../common/css/sprites.css" />
	<div id="deviceDialog" title="Basic dialog">
		<form method="get">
			<%-- <div id="searchContainer" class="inputAreaDivs">
									<label class="label" for="field"><fmt:message key="Email" /></label>
									     	<input type="text" id="field" name="field" class="textbox" placeholder="<fmt:message key='EmailPlaceholder'/>"/>
											<div id="delete"><span id="x">&times;</span></div>
											<div id="userSuggestions">
												<table id="userSuggestionsTable">
													<tbody>
														<!-- <tr class="suggestionsRow">
															<td class="suggestionsData">
																<span class="matchText">test</span><span class="suggestedText"> internet speed</span>
															</td>
														</tr> -->
												</table>
											</div>
									</div> --%>
			<label class="label" for="email"><fmt:message key="Email_Id" /></label>
			<input type="text" id="email" name="email" class="textbox" /> <br>
			<label class="label" for="number"><fmt:message
					key="Phone_Number" /></label> <input type="text" id="number" name="number"
				class="textbox" disabled /> <br>
			<div class="centerAligned">
				<input type="checkbox" id="nonumber" class="check" checked /> <label
					class="labelnew" for="nonumber"><fmt:message
						key="No_Number_Checkbox" /></label>
			</div>
			<br> <label class="label" for="policy"><fmt:message
					key="Policy" /></label> <select name="policy" class="select" id="policy">
			</select> <br> <label class="label" for="owner"><fmt:message
					key="Owner" /></label> <input type="radio" id="owner" name="owner"
				class="radio" value="company" checked>
			<fmt:message key="Company" />
			<input type="radio" id="owner" name="owner" class="radio"
				value="user">
			<fmt:message key="User" />
			<br> <br> <input type="button" id="cancelBtn"
				name="cancelBtn" class="mainBtn"
				value="<fmt:message
					key="Cancel_Button" />"> <input
				type="button" id="sendRequestBtn" name="sendRequestBtn"
				class="mainBtn" value="<fmt:message
					key="Add_Button" />">
			<p style="color: green">
				<label class="label" id="message"></label>
			</p>
			<img src="../login/img/spinner.gif" id="ajaxBusy"
				style="display: none;">
		</form>
	</div>
	<script src="../mdm/js/common.js" type="text/javascript"></script>
	<script src="../mdm/js/index.js" type="text/javascript"></script>
	<script nonce="${sessionScope.cspNonce}" >
		$(document).ready(function() {
			$("#email").autocomplete({
				minLength : 0,
				source : parent.users
			});
		});

		/*  var PARAM_STRING_VALUE = "userString";
		 var SHARE_USER_SUGGESTIONS_API = "/mdm/getUserSuggestionList.do";

		var searchTimeout;
		 
		$(document).ready(function(){
		$("#field").keyup(function(event) {
			$("#errorMessage").text("");
		 	if (searchTimeout != undefined) clearTimeout(searchTimeout); {
		        searchTimeout = setTimeout(function(){callKeyUpOperationForUserField(event);}, 150);
		 	}
		});
		//Cross Event on the User Text Field: To clear out the text field
		$("#x").click(function() {
			$("#field").val("");
			$("#field").removeAttr("dataType");
			$("#field").removeAttr("data-id");
			$("#userSuggestionsTable tbody").empty();
			$("#userSuggestions").hide();
			$(this).hide();
		});
		
		//When the user types a user/group name, suggesions come up. This is the event ffor a click on the suggestion row.
		$("body").on("click", ".suggestionsRow", function() {
			$("#field").attr("value", $(this).text());
			$("#field").attr("dataType", $(this).find(".suggestionsData").attr("dataType"));
			$("#field").attr("data-id", $(this).find(".suggestionsData").attr("data-id"));
			//$("#userSuggestionsTable tbody").empty();
			$("#userSuggestions").hide();
		});

		//Events for user Suggestion table on mouse enter and leave
		$("#userSuggestionsTable").on({
			mouseenter : function() {
				$(".hoverOnSuggestedUsersRow").removeClass("hoverOnSuggestedUsersRow");
				$(this).addClass("hoverOnSuggestedUsersRow");
			},
			mouseleave : function() {
				$(this).removeClass("hoverOnSuggestedUsersRow");
			}
		}, ".suggestionsRow");
		 
		});
		 function callKeyUpOperationForUserField(event) {
		 	$("#x").fadeIn();
		 	var value = $("#field").val();
		 	var type = $("#field").attr("dataType");
		 	var id = $("#field").attr("data-id");
		 	if ($.trim(value) == "") {
		 		$("#userSuggestionsTable tbody").empty();
		 		$("#userSuggestions").hide();
		 		$("#x").fadeOut();
		 		return;
		 	}
		 	if (event.keyCode == 13) {
		 	//On Enter Hit, to save.
		 		if ($(".hoverOnSuggestedUsersRow").length > 0 && $(".suggestionsRow").length > 0) {
		 			$("#field").attr("value", $(".hoverOnSuggestedUsersRow").text());
		 			$("#field").attr("dataType", $(".hoverOnSuggestedUsersRow").find(".suggestionsData").attr("dataType"));
		 			$("#field").attr("data-id", $(".hoverOnSuggestedUsersRow").find(".suggestionsData").attr("data-id"));
		 			$("#userSuggestionsTable tbody").empty();
		 			$("#userSuggestions").hide();
		 			return;
		 		}
		 		var mode = null;
		 		if ($("#inviteAddAreaDiv .selectIcon").hasClass("viewModeOnly")) {
		 			mode = "viewModeOnly";
		 		} else if ($("#inviteAddAreaDiv .selectIcon").hasClass("editMode")) {
		 			mode = "editMode";
		 		}
		 		addNewUserForSharing($.trim(value), mode, type, id);
		 		return;
		 	} else if (event.keyCode == 40) {
		 		//Mouse down event
		 		if ($(".hoverOnSuggestedUsersRow").length == 0 && $(".suggestionsRow").length > 0) {
		 			$($(".suggestionsRow")[0]).addClass("hoverOnSuggestedUsersRow");
		 		} else if ($(".hoverOnSuggestedUsersRow").length != 0) {
		 			var item = $(".hoverOnSuggestedUsersRow");
		 			$(".hoverOnSuggestedUsersRow").removeClass("hoverOnSuggestedUsersRow");
		 			if (item.next() != null && item.next().hasClass("suggestionsRow"))
		 				item.next().addClass("hoverOnSuggestedUsersRow");
		 		}
		 		return;
		 	} else if (event.keyCode == 38) {
		 		//Mouse Up Event
		 		if ($(".hoverOnSuggestedUsersRow").length == 0 && $(".suggestionsRow").length > 0) {
		 			$($(".suggestionsRow")[$(".suggestionsRow").length - 1]).addClass("hoverOnSuggestedUsersRow");
		 		} else if ($(".hoverOnSuggestedUsersRow").length != 0) {
		 			var item = $(".hoverOnSuggestedUsersRow");
		 			$(".hoverOnSuggestedUsersRow").removeClass("hoverOnSuggestedUsersRow");
		 			if (item.prev() != null && item.prev().hasClass("suggestionsRow"))
		 				item.prev().addClass("hoverOnSuggestedUsersRow");
		 		}
		 		return;
		 	} else if (event.keyCode == 27) {
		 		//Escape event
		 		$("#userSuggestionsTable tbody").empty();
		 		$("#userSuggestions").hide();
		 		return;
		 	}

		 	loadUserSuggestions(value);
		 	//To make sure the next operation to clear is not fired as this takes time to complete
		 	if ($.trim(value) == "") {
		 		$("#userSuggestionsTable tbody").empty();
		 		$("#userSuggestions").hide();
		 		$("#x").fadeOut();
		 		return;
		 	}
		 }

		 /*
		 * Load user drop down suggestions list
		 */
		function loadUserSuggestions(value) {
			var shareSuggestionsUrl = cvUtil.getContextPath() + SHARE_USER_SUGGESTIONS_API;
			// Prepare data parameter object:
			var data = {};
			data[PARAM_STRING_VALUE] = value;

			// Send request:
			console.debug("Posting ajax request to get user suggestions");
			cvUtil.loadPageWithPOST(shareSuggestionsUrl, data, function(returnVals) {
				setSuggestionList(returnVals, value);
			}, function() {

			});
		}

		/*
		 * Set the user list that the server sent
		 */
		function setSuggestionList(returnVals, value) {
			$("#userSuggestionsTable tbody").empty();
			if (returnVals == null || returnVals == "") {
				$("#userSuggestions").hide();
				return;
			}

			var uSuggsResult = JSON.parse(returnVals);
			var initRequestVal = uSuggsResult.requestString;
			var uSuggs = JSON.parse(uSuggsResult.responseList);
			var htmlString = null;
			if (uSuggs == null || value != initRequestVal) {
				$("#userSuggestions").hide();
				return;
			}

			for (var i = 0; i < uSuggs.length; i++) {
				var item = uSuggs[i];
				var uName = item.userInfo.name;
				var start, end;
				if (uName.toLowerCase().indexOf(value.toLowerCase()) == 0) {
					start = uName.toLowerCase().indexOf(value.toLowerCase());
					end = value.length + uName.toLowerCase().indexOf(value.toLowerCase());
				} else {
					start = uName.toLowerCase().indexOf(" " + value.toLowerCase()) + 1;
					end = value.length + uName.toLowerCase().indexOf(" " + value.toLowerCase()) + 1;
				}

				var image;
				if (item.userInfo.userType == "USER") {
					image = "avatar";
				} else if (typeClass = "EMAIL") {
					image = "email";
				} else {
					image = "group";
				}

				htmlString = '<tr class="suggestionsRow ' + item.userInfo.userType + '"><td class="suggestionsData" dataType="' + item.userInfo.userType
    				+ '" data-id="' + item.userInfo.id + '">';
				htmlString += '<span class="sprite icon-' + image + ' v-center"></span> ';
				htmlString += '<span class="suggestedText">' + uName.substring(0, start) + '</span>';
				htmlString += '<span class="matchText">' + uName.substring(start, end) + '</span>';
				htmlString += '<span class="suggestedText">' + uName.substring(end, uName.length) + '</span>';
				htmlString += '</td></tr>';
				$("#userSuggestionsTable tbody").append(htmlString);
			}

			if ($(".suggestionsRow").length > 0) {
				$("#userSuggestions").show();
			} else {
				$("#userSuggestions").hide();
			}
		}
	</script>
</fmt:bundle>

