<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>



<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/js/jquery.tinyscrollbar.min.js" name="js" />
		<jsp:param value="/css/consolidated.css" name="css" />
      	<jsp:param value="../common/css/custom-cb.css" name="css" />
      	<jsp:param value="../common/js/encoder.js" name="js"/>
	</jsp:include>

		<fmt:message key="sharing.label.canView" var="canViewLabel" />
		<fmt:message key="sharing.label.canEdit" var="canEditLabel" />
		<fmt:message key="upload.label.untitledFolder" var="untitledFolder" />
		<fmt:message key="sharing.lebel.confirmDeleteText" var="confirmDeleteText" />
		<fmt:message key="sharing.label.confirmDeleteTitle" var="confirmDeleteTitle" />
		<fmt:message key="sharing.lebel.confirmLeaveText" var="confirmLeaveText" />
		<fmt:message key="sharing.label.confirmLeaveTitle" var="confirmLeaveTitle" />
		<fmt:message key="sharing.error.text3" var="errorText3" />
		<fmt:message key="sharing.error.text4" var="errorText4" />
		<fmt:message key="sharing.error.text5" var="errorText5" />
		<fmt:message key="sharing.error.text6" var="errorText6" />
		<fmt:message key="sharing.error.text7" var="errorText7" />
		<fmt:message key="sharing.label.untitledFolder" var="untitledFolderText" />
		<fmt:message key="share.label.addUsers" var="addUsers" />

	<c:set var="shareInfo" value="${requestScope.shareFolderInfo}" />

	<!-- MAIN SHARE FOLDER DIV -->
	<div class="shareFileDiv shareSearchDialogHolder">


<fmt:bundle basename="localization.logMonitoringMessages">
		<input type="hidden" id="searchIdForShare" value=""/>
		<input type="hidden" id="lmSharedEntityType" value="LM_SHARED_ENTITY"/>
		<div class="form-group">
			<label for="searchName" class="entityName subDivTitle vw-start-hidden"><fmt:message key="LM_SEARCH_NAME" /></label>
			<input type="text" class="textbox form-control input-sm" id="searchName" name="searchName"  placeholder="Enter SearchName" size="466" value="" />
		</div>
</fmt:bundle>
		<div class="peopleToShare">
			<div class="form-group">
				<label class="subDivTitle" for="field"><fmt:message key="sharing.label.invitePeople" /></label>
				<div class="subDivBody">
					<div id="invitePeopleDiv">
						<div id="inviteAddAreaDiv">
							<div id="inputArea">
								<div id="addButtonDiv"><span class='sprite icon-add_20 addUserIcon' title="${addUsers}"></span></div>
								<div class="rightSContainer pull-right">
									<div id="userPrivileges" class="inputAreaDivs">
									    <div class="select">
										    <div class="selectIcon viewModeOnly">
										    	<label>${canViewLabel}</label>
										    	<span class="sprite icon-arrow-dropdown" alt="^"></span>
								    		</div>
								    	</div>
									</div>
								</div>
								<div id="searchContainer" class="inputAreaDivs">
								   	<div id="inputTextContainer" class="textbox" >
								   		<!-- <div class="inputItemUser">Siddharth lamba<span class="removeItem">&times;</span></div>  -->
								   		<div class="inputRealContainer">
								   			<input type="text" id="field" name="field" class="form-control input-sm" placeholder="<fmt:message key='sharing.label.placeHolderTest'/>"/>
							   			</div>
							   		</div>
								</div>
								<div id="userSuggestions" class="vw-user-suggestions">
									<table id="userSuggestionsTable" class="vw-user-suggestions-table">
										<tbody>
											<!-- <tr class="suggestionsRow vw-suggestions-row">
												<td class="suggestionsData vw-suggestions-data">
													<span class="suggestedText vw-text"><span class="sprite icon-user"></span><span class="matchText vw-matched-text">test</span> internet speed</span>
												</td>
											</tr> -->
									</table>
								</div>
							</div>
						</div>
				<div id="scrollbar3" class="tinyScrollbar">
					<div class="scrollbar vw-scrollbar"><div class="track"><div class="thumb"><div class="end"></div></div></div></div>
					<div class="viewport vw-tinyscrollbar-viewport">
						<div class="overview">
							<div id="addedPeopleDiv" class="test vw-added-people-container">
								<div class="peopleInfos ownerInfo vw-people-information-container" data-loginname="${ownerName}">
								    <div class="select USER">
								    	<div class="selectText" title="${ownerName}">${ownerName}</div>
								    	<div class="selectIcon disabled ownerRow">
								    		<label><fmt:message key="sharing.label.owner" /></label>
						    			</div>
								    </div>
								</div>
								<div class="peopleInfos vw-people-information-container" data-loginname="${loginName}">
								    <div class="select ${item.userType}">
								    	<div class="selectText" title="${loginName}">${loginName}</div>
											<div class="selectIcon viewModeOnly ${changeModeDisabledClass}">
											    <label>${canViewLabel}</label>
											    <span class="sprite icon-arrow-dropdown" alt="^"></span>
									    	</div>
										     <div class="selectIcon editMode ${changeModeDisabledClass}">
											    <label>${canEditLabel}</label>
											    <span class="sprite icon-arrow-dropdown" alt="^"></span>
									    	</div>
											<div class="deleteItem vw-delete vw-cursor-pointer"><span class="halflings halflings-remove"></span></div>
								 		</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="dropDownShareDiv" class="">
			<fmt:bundle basename="localization.BackupBrowseMessages">
			<ul role="radiogroup" aria-labelledby="${sharing.ariaLabel.userPermissions}">
				<li class="viewModeLI" role="radio" tabindex="0" aria-checked="true">
					<div class="custom-rb checked-rb" data-state="checked" data-id="1"></div>
					<span class="custom-rb-label">
						<label class="modeSetting">${canViewLabel}</label> <br />
						<span class="noteText"><fmt:message key="sharing.label.canViewText" /></span>
					</span>
					<span class="sprite icon-eye"></span>

				</li>
					<li class="editModeLI" role="radio" tab-index="-1" aria-checked="false">
						<div class="custom-rb unchecked-rb" data-state="unchecked" data-id="1"></div>
						<span class="custom-rb-label">
							<label class="modeSetting">${canEditLabel}</label> <br />
							<span class="noteText"><fmt:message key="sharing.label.canEditText" /></span>
						</span>
						<span class="sprite icon-edit"></span>
					</li>
			</ul>
			</fmt:bundle>
		</div>

		<div class="unknownUserGroupDiv">
			<div id="ugSelectorClose">&times;</div>
			<div id="ugSelectorHeader"><fmt:message key="sharing.label.selectTypes" /></div>
			<div id="ugSelectorBody">
				<div class="ugSelectType USER"><fmt:message key="sharing.label.userType" /></div>
				<div class="ugSelectType EXTERNAL_GROUP"><fmt:message key="sharing.label.groupType" /></div>
			</div>
		</div>
		<div class="form-group">
			<label for="notifyEmailsTextDiv" class="subDivTitle">Message</label>
			<textarea id="notifyEmailsTextDiv" class="textarea form-control input-sm" placeholder="${notifyEmailPlaceHolderText}" rows="4"></textarea>
		</div>
		<div class="errorDiv alert alert-danger vw-start-hidden">
			<div id="errorMessage"></div>
		</div>

		<div class="btns footerButtonsHolder vw-btns">
			<a type="button" class="shareEntityButton mainBtn shareSearchBtn vw-btn vw-btn-primary pull-right"><fmt:message key="share.label.shareLabel" /></a>
			<a type="button" id="cancelButton" class="cancelButton mainBtn shareSearchBtn vw-btn vw-btn-default pull-right"><fmt:message key="upload.label.cancel" /></a>
			<a type="button"  class="deleteshareddetails mainBtn shareSearchBtn vw-btn vw-btn-default pull-right"><fmt:bundle basename="localization.logMonitoringMessages"><fmt:message key="LM_Unshare" /></fmt:bundle></a>
		</div>

	</div>

</div>

	<script nonce="${sessionScope.cspNonce}" >
	/*
	if( $.isEmptyObject(parent.viewId) != true ){
		if(parent.viewId == 1){
			var searchid =" ${requestScope.SEARCHID} ";
		}
	}*/
	var clientName = "${requestScope.clientName}";
	var clientId = "${requestScope.clientId}";
	var subClientId = "${requestScope.subclientId}";
	var canUserEdit = "${shareInfo.canUserEdit}";
	var isCreateFolder = "${requestScope.isCreateFolder}";
	var isEdgeClient = "${requestScope.isEdgeClient}";
	var isPwdSet = "${shareInfo.browseInfo.password.isSet}";
	var expirationDate = ("${shareInfo.browseInfo.expirationTime.time == ''}") ? 0 : parseInt("${shareInfo.browseInfo.expirationTime.time}") * 1000;
	var browseParentShareId = "${requestScope.browseParentShareId}";
	var hasNoSelections = ("true" === "${requestScope.noSelections}");
	var shareFiles = shareFiles || {};
	var localMsg = localMsg || {};
	localMsg.downloadSubmittedSingleFile = "${downloadSubmittedSingleFile}";
	localMsg.downloadSubmittedMultipleFiles = "${downloadSubmittedMultipleFiles}";
	localMsg.somethingWentWrong = "${somethingWentWrong}";
	localMsg.excludesError = "${excludesError}";
	localMsg.untitledFolder = "${untitledFolder}";
	localMsg.confirmDeleteText = "${confirmDeleteText}";
	localMsg.confirmDeleteTitle = "${confirmDeleteTitle}";
	localMsg.confirmLeaveText = "${confirmLeaveText}";
	localMsg.confirmLeaveTitle = "${confirmLeaveTitle}";
	localMsg.errorText3 = "${errorText3}";
	localMsg.errorText4 = "${errorText4}";
	localMsg.errorToast5 = "${errorText5}";
	localMsg.errorToast7 = "${errorText7}";
	localMsg.expiredShareUpdateError = "${errorText6}";
	localMsg.canViewText = "${canViewLabel}";
	localMsg.canEditText = "${canEditLabel}";
	localMsg.untitledFolderText = "${untitledFolderText}";

	</script>

	<%@ include file="../common/datepicker.jsp" %>
	<jsp:include page="../common/footer.jsp">
	<jsp:param value="../logMonitoring/js/lmModal.js" name="js" />
	<jsp:param value="../logMonitoring/js/shareEntity.js" name="js" />
		<jsp:param value="../browse/js/shareFiles.js" name="js" />
       <jsp:param value="../common/js/custom-rb.js" name="js" />
       <jsp:param value="../common/js/changeName.js" name="js" />
       <jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../browse/js/browseCommon.js" name="js" />
		<jsp:param value="../browse/js/appTypeFs.js" name="js" />
	</jsp:include>

</fmt:bundle>
