<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<fmt:bundle basename="localization.ScheduleMessages">

	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="" name="titleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="lmSchedule" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="${pageContext.request.contextPath}/common/js/cvTimepicker.js" name="js" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/table.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/custom-cb.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css"/>
		<jsp:param value="${pageContext.request.contextPath}/common/css/cvTimepicker.css" name="css" />
	</jsp:include>

	<fmt:message key="schedule.day.monday" var="localMonday"/>
	<fmt:message key="schedule.day.tuesday" var="localTuesday"/>
	<fmt:message key="schedule.day.wednesday" var="localWednesday"/>
	<fmt:message key="schedule.day.thursday" var="localThursday"/>
	<fmt:message key="schedule.day.friday" var="localFriday"/>
	<fmt:message key="schedule.day.saturday" var="localSaturday"/>
	<fmt:message key="schedule.day.sunday" var="localSunday"/>
	<fmt:message key="schedule.time.hour" var ="hoursText" />
	<fmt:message key="schedule.time.minute" var ="minutesText" />
	<fmt:message key="schedule.time.AM" var ="AMText" />
	<fmt:message key="schedule.time.PM" var ="PMText" />
	<fmt:message key="schedule.label.confirmDelete" var="confirmDelete"/>
	<fmt:message key="schedule.label.errorMessage1" var="errorMessage1"/>
	<fmt:message key="schedule.label.nameLengthErrorMessage" var="nameLengthErrorMessage"/>
	<fmt:message key="schedule.label.enterScheduleName" var="enterScheduleName"/>

	<input id="searchInfo" type="hidden" data-searchid="${requestScope.SEARCHID}" data-searchName="${requestScope.SEARCHNAME}">
	<c:set var="sched" value="${requestScope.SCHEDULE}" />
	<c:set var="schedFreqType" value="${requestScope.SCHEDULE_FREQTYPE}" />

<div id="schMask" class="addOn">
	<div class="vw-panel panel-default">
		<div class="panel-heading">
			<div class="scheduleTitle editMessage vw-start-hidden"><fmt:message key="editSchedule.title.page"/></div>
			<div class="scheduleTitle addMessage"><fmt:message key="addSchedule.title.page"/></div>
		</div>
		<div class="panel-body">
			<form id="schForm" class="stdBorder vw-form-horizontal">
				<div id="searchDescription" class="form-group">
					<label class="control-label col-xs-3">Search Name</label>
					<div class="col-xs-9">
						<input type="text" id="searchName" class="disabledActions disabled form-control input-sm" name="searchName" value="${requestScope.SEARCHNAME}" maxlength="255">
					</div>
				</div>
				<div id="schedDescription" class="form-group">
					<label for="description" class="control-label col-xs-3"><fmt:message key="schedule.label.name"/></label>
					<div class="col-xs-9">
						<input type="text" id="description" name="description" value="" maxlength="255" class="form-control input-sm" />
					</div>
				</div>
				<%--
				<br />
		 		<div id="formOptions">
				<fmt:message key="reports.format"/> : <cv:cvRadioGroup entries="${requestScope.reportFormat}" name="exportType"/>
				</div> --%>
				<div class="form-group">
					<label for="emails" class="control-label col-xs-3"><fmt:message key="reports.emailRecipients"/></label>
					<div class="col-xs-9">
						<input type="text" name="emails" id="emails" class="form-control input-sm">
					</div>
				</div>
				<div id="enabledDiv" class="schedEnabled form-group">
					<div class="col-xs-12">
						<div class="custom-cb unchecked vw-custom-checkbox schedEnabled" data-state="unchecked" name="schedEnabled"></div>
						<label class="custom-cb-label schedEnabled">Enable</label>
						<input type="hidden" name="schedEnabled" value="" title="">
					</div>
				</div>
				<div class="form-group">
					<div id="freqOptions">
						<div class="col-xs-3">
							<label><fmt:message key="schedule.label.howOften"/></label>
						</div>
						<div class="col-xs-9">
							<cv:cvRadioGroup entries="${schedFreqType}" name="freqType"/>
						</div>
					</div>
				</div>
				<div id="dailyElements" class="clearfix form-group">
					<label for="activeStartTime" class="control-label col-xs-3"><fmt:message key="schedule.label.whatTime"/></label>
					<div class="col-xs-9">
						<span id="activeStartTimeDisplay"></span>
						<input type="hidden" id="activeStartTime" name="activeStartTime" value="${sched.activeStartTime}" />
						<span><fmt:bundle basename="localization.logMonitoringMessages"><fmt:message key="CS_TIMEZONE_Label"/></fmt:bundle> ${CS_TIMEZONE_STR}</span>
					</div>
				</div>
				<div id="weeklyElements">
					<ol id="daysToRunList" class="list-inline">
						<li><cv:cvCheckbox name="daysToRun0" styleClass="dayToRun" title="${localMonday}" checked="${sched.daysToRun[0]}" /></li>
						<li><cv:cvCheckbox name="daysToRun1" styleClass="dayToRun" title="${localTuesday}" checked="${sched.daysToRun[1]}" /></li>
						<li><cv:cvCheckbox name="daysToRun2" styleClass="dayToRun" title="${localWednesday}" checked="${sched.daysToRun[2]}" /></li>
						<li><cv:cvCheckbox name="daysToRun3" styleClass="dayToRun" title="${localThursday}" checked="${sched.daysToRun[3]}" /></li>
						<li><cv:cvCheckbox name="daysToRun4" styleClass="dayToRun" title="${localFriday}" checked="${sched.daysToRun[4]}" /></li>
						<li><cv:cvCheckbox name="daysToRun5" styleClass="dayToRun" title="${localSaturday}" checked="${sched.daysToRun[5]}" /></li>
						<li><cv:cvCheckbox name="daysToRun6" styleClass="dayToRun" title="${localSunday}" checked="${sched.daysToRun[6]}" /></li>
					</ol>
				</div>
			<fmt:bundle basename="localization.messages">
				<div class="btns noabsolute rghtFloat pull-right">
					<a href="#" id="cancelButton" class="vw-btn vw-btn-default"><fmt:message key="Reset" /></a>
					<a href="#" id="okButton" class="okSaveButton vw-btn vw-btn-primary"><fmt:message key="common.action.save" /></a>
				</div>
			</fmt:bundle>
		</form>
	</div>
</div>

<div id="schedulesList" class="bot vw-panel panel-default" id="b">
	<div class="panel-heading">
		<div class="scheduleTitle lftFloat"><fmt:message key="schedule.label.existing"/></div>
	</div>
	<table id="schedulesList_table" class="display vw-hidden-thead table"></table>
	</div>
</div>
<fmt:bundle basename="localization.messages">
	<div class="btns pull-right">
		<a href="#" id="closeButton" class="vw-btn vw-btn-default"><fmt:message key="common.action.close" /></a>
	</div>
</fmt:bundle>
</fmt:bundle>
<fmt:bundle basename="localization.ReportsJSMessages">
	<fmt:message key="errors.invalid_email" var="invalid_email"/>
	<fmt:message key="errors.email_is_empty" var="email_is_empty"/>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.hours = "${hoursText}";
    localMsg.minutes = "${minutesText}";
    localMsg.AM = "${AMText}";
    localMsg.PM = "${PMText}";
    localMsg.nameLengthErrorMessage = "${nameLengthErrorMessage}";
    localMsg.enterScheduleName = "${enterScheduleName}";
    localMsg["errors.invalid_email"]="${invalid_email}";
    localMsg["errors.email_is_empty"]="${email_is_empty}";
	var confirmDeleteVar = "${confirmDelete}";
	var errorMessage1Text="${errorMessage1}";
	var defaultModel=${requestScope.SCHEDULE_JSON};
	var currentUrl=window.parent.document.URL;
	${cv:jsLocalize("localMsg", "localization.ScheduleMessages", null)};
	var defaultTimeZoneId = "${sched.commServTimeZone}";
</script>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js"/>
	<jsp:param value="../reports/js/tablebase.js" name="js" />
	<jsp:param value="../reports/js/reportsUtil.js" name="js" />
	<jsp:param value="../reports/js/reportSchedule.js" name="js" />
	<jsp:param value="../reports/js/reportScheduleList.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>

