<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%-- <%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%> --%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>
<fmt:bundle basename="localization.logMonitoringMessages">
<fmt:message key="Export_Progress_Msg" var="exportProgessMsg" />
<fmt:message key="Export_Error_Msg" var="exportErrorMsg" />
</fmt:bundle>
<c:set var="monitoringType" value="${requestScope.MONITORING_APP}" />
<c:set var="mpList" value="${requestScope.MPLIST}" />
<enhance:out escapeXml="false">
<c:set var="fieldList" value="${sessionScope.FIELDLIST}" />
<c:set var="templateList" value="${requestScope.TEMPLATE_LIST}" />
<c:set var="policyList" value="${requestScope.UPLOAD_POLICIES}" />
<c:set var="unavailableCloudsErr" value="${requestScope.LM_UNAVAIL_CLOUDS}"/>
</enhance:out>
<c:set var="scheme" value='<%=request.getScheme()%>'/>
<c:set var="mainURL" value='<%=request.getServerName() + ":" + request.getServerPort()%>'/>
<c:set var="isMasterUser" value="${sessionScope.isMasterUser}"></c:set>
<c:set var="pageTitle"  value="${requestScope.MONITORING_APP_NAME}" />
<c:set var="monitoringApp" value="${requestScope.MONITORING_APP}"/>

<jsp:include page="../common/header.jsp">
	<jsp:param value="${pageTitle}" name="titleLocalized" />
	<jsp:param value="true" name="includeJqueryUI" />
    <jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeTableSupport" />
    <jsp:param value="true" name="includeHistory" />
	<jsp:param value="true" name="disableTableColReordering" />
	<jsp:param value="${pageTitle}" name="headerTitleLocalized" />
	<jsp:param value="true" name="LMHeader" />
	<jsp:param value="true" name="includeMask" />
	<jsp:param value="true" name="includeLatestDatatable" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="logMonitoring" />
	<jsp:param value="${monitoringApp}" name="monitoringApp" />
</jsp:include>
<jsp:include page="lmUtils.jsp" flush="true" >
	<jsp:param value="true" name="isLMApp" />
</jsp:include>

<input id="lm_csTimeZoneVal" type="hidden" value='${applicationScope.CS_TIMEZONE_STR}'/>
<input id="isScheduleAvailable" type="hidden" value='${sessionScope.schedulesAvailable}'/>
<input id="isAlertsAvailable" type="hidden" value='${sessionScope.alertsAvailable}'/>

<input id="templateResp" type="hidden" value='${templateList}'/>
<input id="policyResp" type="hidden" value='${policyList}'/>
<input id="dList" type="hidden" value='${requestScope.DASH_LIST}'/>
<input id="dBoardsSharedToMe" type="hidden" value='${requestScope.SHARED_DASH_LIST}'/>
<input id="isMasterUser" type="hidden" value='${isMasterUser}'/>
<input id="curUserId" type="hidden" value='${sessionScope.USERID}'/>
<input id="curUserName" type="hidden" value='${sessionScope.username}'/>
<input id="monitoringType" type="hidden" value='${monitoringType}'/>
<!--  <input id="useCSVUpload" type="hidden" value='${sessionScope.discoverTemplateForCSV}'/> -->
<input id="useColumnTab" type="hidden" value='${sessionScope.discoverColumnView}'/>
<input id="isLmScaleEnabled" type="hidden" value='${sessionScope.discoverLmScalability}'/>
<div class="contentLoader vw-loading"><div class="vw-center-container"><div class="vw-vertical-center"><div class="vw-horizontal-center"><div class="vw-loading-spinner vw-spinner-large"><div class="vw-loading-comp"></div></div></div></div></div></div>

<div class="contentArea vw-content-area"></div>

<!--  Container for context menu options in the search alerts page -->
<div id="cv-context-menu-holder">
	<ul class="cv-context-menu vw-dropdown-menu vw-actions-menu"></ul>
</div>
<!--  Container for context actions menu options in the search page -->
<div id="vw-search-actions-menu">
	<ul class="cv-context-menu vw-dropdown-menu vw-actions-menu"></ul>
</div>
<%@include file="../upload/index.jsp" %>

<script nonce="${sessionScope.cspNonce}" >

	//curMonitoringApp = "${monitoringType}";

	//This is the global namespace for Log Monitoring
	var LM = {
			'home': {},
			'search': {},
			'import': {},
			'alerts': {},
			'schedules': {},
			'dashboard': {},
			'components': {},
			'templates': {}
		};



	var unavailableCloudsMsg = "${unavailableCloudsErr}";

	unavailableCloudsMsg = $('<div/>').html(unavailableCloudsMsg).text();

	if(unavailableCloudsMsg != undefined && unavailableCloudsMsg != "")
	{
		unavailableCloudsMsg = lmOptionsMsg.cloudDownError + "<br>" + unavailableCloudsMsg + " <br><div class=\"errorTryAgain\">" + lmOptionsMsg.pleaseCheck + "</div>";
		var exportMode = "${sessionScope.LM_EXPORT_MODE}";
		if(exportMode == undefined || exportMode == null || !exportMode)
		{
			cvUtil.errorToast(unavailableCloudsMsg);
		}
		localMsg.unavailableCloudsMsg = "Note:" + unavailableCloudsMsg;
	}
</script>

<!-- <script nonce="${sessionScope.cspNonce}" >

/* 	var list = JSON.parse("${mpList}"); */
	var localMsg = localMsg || {};
	localMsg.exportProgessMsg = "${exportProgessMsg}";
	localMsg.exportErrorMsg = "${exportErrorMsg}";
</script> -->
<jsp:include page="/reportsplus/reportLMInclude.jsp" />
<jsp:include page="../common/footer.jsp">
	<jsp:param value="${pageContext.request.contextPath}/common/js/atmosphere.min.js" name="js"/>

	<jsp:param value="js/logMonitoring.js" name="js"/>
	<jsp:param value="js/timeline.js" name="js"/>
	<jsp:param value="js/LMDashboard.js" name="js" />
	<jsp:param value="js/main.js" name="js"/>
	<jsp:param value="${pageContext.request.contextPath}/common/js/jquery.tinyscrollbar.min.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/common/datatables/js/jquery-datatables-pagination-without-ellipses.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/common/datatables/js/dataTables.colResize.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/common/js/ColReorder.js" name="js" />
	<jsp:param value="js/dashboard.js" name="js" />
	<jsp:param value="js/importDashboard.js" name="js" />
	<jsp:param value="js/jquery-sDashboard.js" name="js" />
	<jsp:param value="js/upload.js" name="js" />
	<jsp:param value="js/jquery.pagination.js" name="js"/>
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/searchContextMenu.js" name="js" />
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/lmapp.js?${applicationScope.BUILD_TS}"></script>



