<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<fmt:bundle basename="localization.logMonitoringMessages">  
<fmt:message key="LM_Header" var="pageTitle" />
</fmt:bundle>
<c:set var="exportRows" value="${cvConfig.exportRows}"></c:set>

<jsp:include page="../common/header.jsp">
	<jsp:param value="${pageTitle}" name="titleLocalized" />
	<jsp:param value="true" name="includeJqueryUI" />	
    <jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeTableSupport" />
    <jsp:param value="true" name="includeHistory" />
	<jsp:param value="true" name="disableTableColReordering" />
	<jsp:param value="" name="headerTitleLocalized" />
	<jsp:param value="true" name="includeMask" />
	<jsp:param value="../common/js/jquery.tinyscrollbar.min.js" name="js" />
	<jsp:param value="true" name="includeLatestDatatable" />
	<jsp:param value="true" name="logMonitoring" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/datatables/js/jquery-datatables-pagination-without-ellipses.js" name="js" />
	<jsp:param value="../common/datatables/js/dataTables.colResize.js" name="js" />
	<jsp:param value="../common/js/ColReorder.js" name="js" />
</jsp:include>

<jsp:include page="lmUtils.jsp" flush="true" >
	<jsp:param value="true" name="isLMApp" />
</jsp:include>

<%-- <div>
<ul id="breadcrumbMain" class="breadcrumbMain">
<li class="smartlinkMain withSeparatorMain">
<a class="smartLinkMain" href="${pageContext.request.contextPath}/logMonitoring/lmSearch.jsp">Log Monitoring</a>
</li>
<li>
<!-- <span class="smartLinkMain summaryTitle" href="#"></span> -->
</li>
<!-- <li>
<a class="previewPrev" href="#" data-lineNo="">Prev</a>
</li>
<li>
<a class="previewNext" href="#" data-lineNo="">Next</a>
</li> -->
<li>

<li><form class="saveLog" method="post" action="${pageContext.request.contextPath}/server/getPreviewResult"><input class="logSubmitBtn" type="submit" value="Download"></input></form>
</li>

</ul>
</div> --%>
<br>
<!--
<div class="hideOnExportFriendly" id="headerExport">
<ul id="export" class="rightFloat">
<li id="exportPdf" class="exportatserver"></li>
</ul>
</div>
-->

<div class="tableViewHolderWrapperWrapper">
<div id="tableViewHolder" class="columnEditor vw-table-view">
	<table id="globalSearchResultsTable" class="tablesorter table vw-small-table-text vw-compact" data-target="/server/getPreviewResult" data-enableSummary="false" data-title="events">
	</table>
</div>
<div class="tableViewHolderOverlay vw-loadmask">
	<div class="vw-center-container">
		<div class="vw-vertical-center">
			<div class="vw-horizontal-center">
			    <div class="vw-loading-spinner vw-spinner-medium">
			      <div class="vw-loading-comp"></div>
			    </div>
			</div>
		</div>
	</div>
</div>
</div>

<!-- <div class="summaryArea">
<div id="ajaxBusyMail" class="center_it">
	
	<img src="../common/img/loader.gif" />
</div>  
</div> -->
<!--  Container for context actions menu options in the search page -->
<div id="vw-search-actions-menu">
	<ul class="cv-context-menu vw-dropdown-menu vw-actions-menu"></ul>
</div>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/logMonitoring.js" name="js"/>
	<jsp:param value="js/dashboard.js" name="js"/>
	<jsp:param value="js/searchContextMenu.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
</jsp:include>

<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
var viewLogs;
var topEvents;
var isFirstPageEncountered=false;
var totalSize = undefined;
var fetchCount = true;
var pageNo = 0;
var noOfROws;
var SAVE_LIMIT = "${exportRows}";
var fieldsResp = undefined;

function getLogLineCount()
{
	totalSize =  processSummary(undefined,undefined,true);
}


function processSummary(lower,upper,isSaveLogs)
{
	
	var previewParams = {};
	
	if(topEvents == "false")
	{
	var sType = (isSaveLogs!=undefined && isSaveLogs)?"saveLog" : currentSummaryType;
	
	previewParams = getPreviewParams(lower,upper,noOfRows,lmModal.functions.getParameterViaHistory("clientName",""),lmModal.functions.getParameterViaHistory("fileUniqueId","")
	,lmModal.functions.getParameterViaHistory("fileName",""),lmModal.functions.getParameterViaHistory("lineNumber",0),lmModal.functions.getParameterViaHistory("policyId"),
	pageNo,sType,lmModal.functions.getParameterViaHistory("templateId",""));

	var inputParams = cvUtil.createParamsString(params);
	
	if(isSaveLogs!=undefined && isSaveLogs)
	{
		var action =cvUtil.getContextPath()+'/server/getPreviewResult?' + inputParams;
		iframeCount++;
		$("body").append('<iframe id="' + lmModal.functions.getParameterViaHistory("fileName","temp") + '_' + iframeCount + '" src="'+ action + '" style="display:none">');
	}
	else
	{
		previewParams["lower"] = 0;
		previewParams["upper"] = lower;
		previewParams["previewInfoReq"] = true;
		
		cvUtil.loadPage(cvUtil.getContextPath()+'/server/getPreviewResult',previewParams,function(data){
			if(data!=undefined){
				previewParams["lower"] = lower;
				previewParams["upper"] = upper;
				previewParams["previewInfoReq"] = false;
		//$(".summaryArea").html('<div id="ajaxBusyMail" class="center_it"><img src="../common/img/loader.gif" /></div>');
		$("#globalSearchResultsTable").attr("data-enableSummary",false);
		$("#globalSearchResultsTable").attr("data-target","/server/getPreviewResult");
				
		enableGraph = false;
		reInitializeDataTable("globalSearchResultsTable",data.start-1,"/server/getPreviewResult", fieldsResp,noOfRows,false,false,previewParams);
		enableGraph = true;
		 									
			}
         },function(xhr, ajaxOptions, thrownError){
             displayExceptionMessage(xhr,ajaxOptions,thrownError,false);
         });
	}
	}
	else
	{
		$(".summaryArea").html('<div id="ajaxBusyMail" class="center_it"><img src="../common/img/loader.gif" /></div>');
		var url = History.getState().cleanUrl;
		var positionToInsert=url.lastIndexOf("?")+1;
		
		if(positionToInsert<1)
				url=url+'?'+params;
			else
			url=[url.slice(0,positionToInsert),params+'&',url.slice(positionToInsert)].join('');  //we can't just append at the end because of IE9
			var inputParams = url;
			cvUtil.loadPage(cvUtil.getContextPath()+'/server/getTopEvents',inputParams,
				function(data){	
			$(".summaryArea").html(data);
		});
	}
}
$(document).ready(function(){
	
	if($.browser.msie && parseFloat($.browser.version) < 10)
	{
			window.location.href = "IE10OrAboveMessage.jsp";
	}
	else
	{
    curMonitoringApp = appTypeIdToNameMap[lmModal.functions.getParameterViaHistory("appType","1")];
	param = createParametersForFacetQuery(undefined,FACET_LIMIT,0,undefined,currentStartTime,currentEndTime,range);
	param.push(cvUtil.createParamString("cbTimeOffset",new Date().getTimezoneOffset()));
	params = cvUtil.createParamsString(param);
	
	//cvUtil.loadPage(cvUtil.getContextPath() + '/server/getFieldNames',params,function(data){

	currentSummaryType = lmModal.functions.getParameterViaHistory("summaryType","showPreview");
	topEvents = lmModal.functions.getParameterViaHistory("topEvents","false");
	noOfRows = parseInt(lmModal.functions.getParameterViaHistory("noOfRows",50));
	var summaryTitle = lmModal.functions.getParameterViaHistory("fileName","") + " on " + lmModal.functions.getParameterViaHistory("clientName","");

		if(currentSummaryType == "showPreview")
		{
			//summaryTitle = "Preview result (" + noOfRows + " lines) for " + summaryTitle; 
		}
		else if(currentSummaryType == "showSimilarLines")
		{
			summaryTitle = "Similar Lines Result";
		}
		else
		{
			summaryTitle = "Top 25 Events";
		}

		$("#sectionTitle").text(summaryTitle);
		//$(".sechead").html(summaryTitle);
		
		viewLogs = lmModal.functions.getParameterViaHistory("viewLogs","false");

		var lower = lmModal.functions.getParameterViaHistory("lower",0);
		var upper = lmModal.functions.getParameterViaHistory("upper","");
		
		maskTable();		
		cvUtil.loadPage(cvUtil.getContextPath()+ "/server/summary",{},function(data){
			processSummary(lower,upper);
		},function(xhr, ajaxOptions, thrownError){
			unmaskTable();			
			displayExceptionMessage(xhr,ajaxOptions,thrownError,false);
		});

		$(".logSubmitBtn").off("click");
		$(".logSubmitBtn").on("click",function(e){
			e.preventDefault();
			var l = parseInt($(".previewPrev").attr("data-lineno")) - SAVE_LIMIT;
			
			if(l < 0)
			{
				l = 0;	
			}
			var u = parseInt($(".previewNext").attr("data-lineno")) + SAVE_LIMIT;
			processSummary(l,u,true);
		});
		
		$(document).mouseup(function (e)
	            {
	                var containers = ["#allTimeContainer",".globalSearchResults_container"];
	        		jQuery.each(containers, function() {
	        			var currentContainer = $(this.trim());
	                    if (currentContainer.has(e.target).length === 0)
	                    {
	                    	if(e.target.id != "all" && e.target.id!="globalSearchResults_Button" && e.target.id!="allTimeContainer")
	                    		{
	                    		currentContainer.hide();
	                    		}
	                    	else if (e.target.id="allTimeContainer") 
	                    		{
	                    		currentContainer.addClass("invisible");
	                    		}
	                    }
	        		});
	            });
	}
});
</script>	