<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<style>

.createTabFormRowCls {
	margin-top: 10px;
	clear: both;
	height: 12px;
}

.createTabFormRowCls #tabName {
	width: 215px;
}

.tabNameLabelCls {
	line-height: 21px;
}

.markDefaultSectionHolderCls {
	margin-top: 4px;
}

.createTabFormRowCls #errorDiv {
	text-align: left;
    color: #F81010;
    font-size: 15px;
}

</style>

<html>
<head>
	<jsp:include page="/common/search-engine.jsp" />

</head>
<body>
<fmt:bundle basename="localization.logMonitoringMessages">
	<div class="createTabFormRowCls">
		<label class="tabNameLabelCls"><fmt:message key="LM_ViewName" /></label>
		<input id="tabName" class="rightFloatCls pull-right" />	
	</div>	
	<div class="createTabFormRowCls">	
		<div class="rightFloatCls markDefaultSectionHolderCls pull-right">
			<input type="checkbox" name="defaultTab" id="defaultTab">
			<label for="defaultTab" class="cursorPointerCls vw-cursor-pointer"><fmt:message key="LM_IsDefaultView" /></label>
		</div>	
	</div>
	<div class="createTabFormRowCls">
		<div id="errorDiv" class="rightFloatCls pull-right"></div>
	</div>	
	<div class="createTabFormRowCls">
		<div class="rightFloatCls tabButtonsHolder pull-right">
			<button id="applyButton" class="cursorPointerCls vw-cursor-pointer hidden"><fmt:message key="LM_View_ApplyLabel" /></button>
		</div>
	</div>
</fmt:bundle>  	
</body>
</html>

<jsp:include page="../common/jquery.jsp" />

<script nonce="${sessionScope.cspNonce}" >
	function getColListForModifiedTab(defaultTabName){
		var colList = [];
		var $selectedTab = parent.$('#tabList .selected');
   	 	var selectedTabName =  $selectedTab.attr('data-name').trim();
   	 	if(parent.tabMap[selectedTabName+"_changed"] != undefined ){
   	 		if( !(parent.tabMap[selectedTabName].sort().join(',') === parent.tabMap[selectedTabName+"_changed"].sort().join(','))){
   	 			colList = parent.tabMap[selectedTabName+"_changed"].slice();
   	 		}
   	 		delete parent.tabMap[selectedTabName+"_changed"];
   	 	}
   	 	if(colList.length == 0 && isDefaultTabChanged(selectedTabName,defaultTabName)){
   	 		colList = 	parent.tabMap[selectedTabName].slice();
   	 	}
   	 	return colList;
	}
	
	function isDefaultTabChanged(tabName,defaultTabName){
		if(tabName == defaultTabName){
			if(!$("#defaultTab").prop("checked")){
				return true;
			}
			else{
				return false;
			}
		}
		else{
			if($("#defaultTab").prop("checked")){
				return true;
			}
			else{
				return false;
			}
		}
	}
	
	$(document).ready(function(){
		var searchId = lmModal.functions.getParameter("searchId","");
		var opType = lmModal.functions.getParameter("opType","");
		var tableId = lmModal.functions.getParameter("tableId","");
		var defaultTabName = lmModal.functions.getParameter("defaultTabName","");
			if(defaultTabName == undefined)
				defaultTabName = "";
		var tabName="";
		var colList = [];
		var $selectedTab = "";
		var selectedTabName = "";
		
		if(opType == 13){
			opType = "CREATE_SEARCH_TAB";
			if(!parent.$("#tabList .columnTab").hasClass('selected')){
				$(parent.visibleCols).each(function(index){
					colList.push(parent.visibleCols[index]);
				});
			}
			else{
				colList = getColListForModifiedTab(defaultTabName);
				
			}
		}
		else if(opType == 14){
			opType = "MODIFY_SEARCH_TAB";
			$selectedTab = parent.$('#tabList .selected');
       	 	selectedTabName =  $selectedTab.attr('data-name').trim();
       	 	$("#tabName").val(selectedTabName);
       	 	$("#tabName").addClass('disabledActions disabled');
       	 	if(selectedTabName == parent.defaultTabName){
       	 		$("#defaultTab").attr('checked','checked');
       	 	}
		}
		
		$("#applyButton").off("click").on("click", function(e) {
			e.preventDefault();
			var params = [];
			tabName = $("#tabName").val().trim();
			if(opType == "MODIFY_SEARCH_TAB"){
				colList = getColListForModifiedTab(defaultTabName);
				var isListChanged = false;
				if(colList.length != 0){
					if(parent.tabMap[tabName].length != colList.length){
						isListChanged = true;
					}
					else{
						$.each(parent.tabMap[tabName], function( index, value ) {
						  	if(colList.indexOf(value) == -1)
						  		isListChanged = true;
						});
					}
				}
				if(isListChanged == false && !isDefaultTabChanged(tabName,defaultTabName)){
					parent.cvUtil.toast(parent.viewOptionMsg.viewOperationFailed, null, null, true);
					cvUtil.closeModal();
					return;
				}
			}
			
			if(tabName == ""){
				$("#errorDiv").html(parent.viewOptionMsg.emptyViewNameError);
				return;
			}
			if(opType == "CREATE_SEARCH_TAB" && parent.tabMap[tabName] != undefined){
				$("#errorDiv").html(parent.viewOptionMsg.duplicateViewNameError);
				return;	
			}
			
			if(colList.length == 0){
				$("#errorDiv").html(parent.viewOptionMsg.duplicateColListError);
				return;
			}
			parent.$('#tabList .selected').removeClass('columnsChanged');
			params.push((cvUtil.createParamString("searchTabName",tabName )));
			params.push((cvUtil.createParamString(tabName+"_cols",colList )));
			params.push((cvUtil.createParamString("searchId",searchId )));
			params.push((cvUtil.createParamString("searchTabOpType",opType )));
			params.push((cvUtil.createParamString("isDefaultTab",$("#defaultTab").prop("checked") )));
			var inputParams = cvUtil.createParamsString(params);
			
			cvUtil.loadPage(cvUtil.getContextPath() + "/server/searchTabOperation",inputParams , function(data) {
				if(data.response.errorCode == 1){
					parent.cvUtil.toast(parent.viewOptionMsg.viewOperationFailed, null, null, true);
					return;
				}
				if(opType == "CREATE_SEARCH_TAB"){
					parent.cvUtil.toast(parent.viewOptionMsg.createViewSuccess, null, null, true);
					parent.$('.columnTab').removeClass('selected');
					var html = "";
					if(parent.$("#tabList").find("[data-name='default']").length == 0){
						html += '<option class="columnTab" data-name="default"> default</option>';
						parent.tabMap["default"] = parent.visibleCols;
					}
					parent.$('.columnTab').removeAttr('selected');
					html += '<option class="columnTab selected" selected="selected" data-name="'+tabName+'">'+ tabName +'</option>';
					parent.$(".saveTab .createTab").hide();
					parent.$("#tabList select").append(html);
					parent.addListenerForColumnTab(tableId);
				}
				else if(opType == "MODIFY_SEARCH_TAB"){
					parent.cvUtil.toast(parent.viewOptionMsg.editViewSuccess, null, null, true);
					if(tabName == parent.defaultTabName){
						if(!$("#defaultTab").prop("checked")){
							parent.defaultTabName = "";
						}
					}
					else{
						if($("#defaultTab").prop("checked")){
							parent.defaultTabName = tabName.trim();
						}	
					}
				}
				
				parent.tabMap[tabName] = colList;
				
				if( !$.isEmptyObject(parent.tabMap) ){
					parent.$(".saveTab .editTab").show();
					parent.$(".saveTab .deleteTab").show();
				}
				
				cvUtil.closeModal();
			},function(xhr, ajaxOptions, thrownError) {
				 parent.cvUtil.toast(parent.viewOptionMsg.viewOperationFailed, null, null, true);
				 cvUtil.closeModal();
			}); 
		});
	});
</script>