<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<style>

.createTabFormRowCls {
	margin-top: 18px;
	clear:both;
	height: 12px;
}

.createTabFormRowCls #tabName {
	width: 215px;
}

.tabNameLabelCls {
	line-height: 21px;
}

.markDefaultSectionHolderCls {
	margin-top: 4px;
}

.createTabFormRowCls #errorDiv {
	text-align: left;
    color: #F81010;
    font-size: 14px;
    margin-top: 3px;
    max-width: 245px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

</style>

<html>
<head>
	<jsp:include page="/common/search-engine.jsp" />

</head>
<body>
<fmt:bundle basename="localization.logMonitoringMessages">
	<div class="createTabFormRowCls">
		<label class="tabNameLabelCls"><fmt:message key="LM_ViewName" /></label>
		<input id="tabName" class="rightFloatCls pull-right" />	
	</div>	
	<div class="createTabFormRowCls">	
		<div class="rightFloatCls markDefaultSectionHolderCls pull-right">
			<input type="checkbox" name="defaultTab" id="defaultTab">
			<label for="defaultTab" class="cursorPointerCls vw-cursor-pointer"><fmt:message key="LM_IsDefaultView" /></label>
		</div>	
	</div>
	<div class="createTabFormRowCls">
		<div id="errorDiv" class="leftFloatCls pull-left"></div>
		<div class="rightFloatCls tabButtonsHolder pull-right">
			<button id="applyButton" class="cursorPointerCls vw-cursor-pointer hidden"><fmt:message key="LM_View_ApplyLabel" /></button>
		</div>
	</div>
</fmt:bundle>  	
</body>
</html>

<jsp:include page="../common/jquery.jsp" />
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/logMonitoring/js/lmModal.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/logMonitoring/js/columnViewOperation.js?${applicationScope.BUILD_TS}"></script>
