	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

	<fmt:bundle basename="localization.LicenseGenerator">
		<c:set var="title"><fmt:message key="Modify_Bundles" /></c:set>
		<c:set var="breadcrumb"><fmt:message key="License_Generator_Header"/></c:set>
		<jsp:include page="../common/header.jsp">
			<jsp:param value="../common/css/headerstyles.css" name="css"/>
			<jsp:param value="../common/css/templatestyles.css" name="css"/>
			<jsp:param value="../common/css/table.css" name="css"/>
			<jsp:param value="css/licensegenerator.css" name="css"/>
			<jsp:param value="true" name="includeSecHeader" />
			<jsp:param value="${title}" name="titleLocalized" />
			<jsp:param value="${title}" name="headerTitleLocalized" />
			<jsp:param value="${breadcrumb}:licensegenerator/index.jsp" name="breadCrumbValues" />
		</jsp:include>
		<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
			var localMsg = localMsg || {};
			${cv:jsLocalize("localMsg", "localization.LicenseGenerator", null)};
		</script>
		<c:url var="helpUrl" value="http://documentation.commvault.com/commvault/v11/article?p=6994.htm">
		</c:url>
		<c:url var="lsrUrl" value="https://cloud.commvault.com/webconsole/reportsplus/reportViewer.jsp?reportId=License%20summary%20worldwide">
		</c:url>
		<div>
			<div class="selected lsr">
				<a href="${lsrUrl}" target="_blank">Current License Usage</a>
			</div>
			<div class="info infoModify"></div>
		</div>
		<span class="loadSpinner"></span>
		<div class="cvApps">
			<div class="info infoModify">
				<table>
					<tbody>
						<tr>
							<td class="borderless"><label id="loadLabel">CommCell ID/Registration Code (in hex):</label></td>
							<td class="borderless"></td>
						</tr>
						<tr>
							<td class="borderless">
								<input type="text" id="txtCsId" class="textbox infoItems" value=""/>
								<select id="ddlOrgName" class="dropbox infoItems loadDropdown hidden">
	     								</select>
							</td>
							<td class="borderless">
								<input type="button" id="goBtn" class="mainBtn" value="Go"/>
							</td>
							<td class="borderless">
								<input id="chkDecimalCcid" class="checkboxDecimal" type="checkbox" value="">
								<label id="lblDecimalCcid" for="chkDecimalCcid">Enter decimal value of CommCell ID</label>
								<input id="chkOrgName" class="checkboxDecimal" type="checkbox" value="">
								<label for="chkOrgName"><fmt:message key="Load_license_with_Org"/></label>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<div id="divSearch" class="dSearch disable">
				<input id="searchBox" class="textbox searchBox disableColor" type="text" value="Enter [PartNumber] or [Sku] to be searched">
				<input id="searchBtn" class="searchBtn" type="button">
				<input id="chkSearch" class="checkboxSrch" type="checkbox" value="">
				<label id="lblChkSearch" for="chkSearch">Include higher releases</label>
			</div>
			<div id="custLicDiv" class="disable">
				<div id="dDefaultLicInfo" class="info">
					<div id="divDefaultLicInfo" class="selected clickable expandable collapsible expandInfo">
						<label class="clickable">License Information</label>
						<div id="divDefaultLicTriangle" class="expand triangle"></div>
					</div>
					<div id="divDefaultLicInfoContent" style="margin-top:10px;">
						<table>
							<tbody>
								<tr>
									<td class="borderless leftPadding">OEM:</td>
									<td class="borderless">Release:</td>
									<td class="borderless">License Type:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<select id="ddlOEM" class="dropbox infoItems">
	     								</select>
									</td>
									<td class="borderless">
										<select id="ddlRelease" class="dropbox infoItems">
	     								</select>
									</td>
									<td class="borderless">
										<select id="ddlLicenseType" class="dropbox infoItems">
	          								<option value="Permanent">Permanent</option>
	          								<option value="Permanent with Expiry">Pure Subscription/Permanent with Expiry</option>
	          								<option value="Pilot">New License</option>
	          								<option value="Pilot Extension">Pilot Extension</option>
	          								<option value="Permanent Eval Extension">Permanent Eval Extension</option>
	     								</select>
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding topPadding" id="txtSerialNo">Serial Number:</td>
									<td class="borderless" id="txtRegCode">Registration Code:</td>
									<td class="borderless" id="txtCommcellId">CommCell ID (in hex):</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input id="SerialNoCust" class="textbox infoItemsRight" type="text" value="" />
										<a href="${helpUrl}" target="_blank">
	     									<img class="infoItems help" src="img/help.png" alt="?"></img>
	     								</a>
									</td>
									<td class="borderless">
										<input id="RegCodeCust" class="textbox infoItemsRight" type="text" value="" />
										<a href="${helpUrl}" target="_blank">
	     									<img class="infoItems help" src="img/help.png" alt="?"></img>
	     								</a>
									</td>
									<td class="borderless">
										<input id="CommcellIdCust" type="text" class="textbox infoItems" value=""/>
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding" id="htmlIpAdd">IP Address:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input id="IpAddressCust" type="text" class="textbox infoItems disableColor" value="<fmt:message key="Leave_Blank"/>"/>
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input disabled type="checkbox" class="checkbox disable" id=chkIP value="" checked="checked"/>
										<label id="divchkIP" class="disable" for="chkIP"><fmt:message key="Dynamic_IP"/></label>
									</td>
									<td class="borderless">
										<input disabled type="checkbox" class="checkbox disable" id="chkSubscriptionBased" value=""/>
										<label id="lblSubscriptionBased" for="chkSubscriptionBased" class="disable"><fmt:message key="Subscription_Based"/></label>
									</td>
									<td class="borderless">
										<input type="checkbox" class="checkbox" id="chkDisableCMR" value=""/>
										<label id="lblDisableCMR" for="chkDisableCMR"><fmt:message key="Disable_CMR"/></label>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<div id="dLicInfo" class="info">
					<div id="divLicInfo" class="selected clickable expandable">
						<label class="clickable">Additional License Information</label>
						<div id="divLicTriangle" class="collapse triangle"></div>
					</div>
					<div id="divLicInfoContent" class="hidden" style="margin-top:10px;">
						<table>
							<tbody>
								<tr>
									<td class="borderless leftPadding disable" id="DrIpAddressCustHdr">DR IP Address:</td>
									<td class="borderless disable" id="htmlEvalDays">Evaluation Days:</td>
									<td class="borderless disable" id="htmlExpDate">Expiration Date:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input disabled id="DrIpAddressCust" type="text" class="textbox disable infoItems infoItemsCust" />
									</td>
									<td class="borderless">
										<select disabled id="ddlEvalDays" class="dropbox infoItems infoItemsCust disable">
											<option value=""></option>
											<option value="30">30</option>
	          								<option value="60" selected="selected">60</option>
	          								<option value="90">90</option>
	          								<option value="120">120</option>
	          								<option value="150">150</option>
	          								<option value="180">180</option>
	     								</select>
									</td>
									<td class="borderless">
										<input disabled id="txtExpDate" type="text" class="textbox infoItems infoItemsCust disable calendarControl calendarControlDisabled"/>
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding" id="htmlInheritedLicenseType">Inherited License Type:</td>
									<td class="borderless hidden" id="htmlParentId"><fmt:message key="Parent"/> <fmt:message key="CCID"/></td>
									<td class="borderless"></td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<select id="ddlInheritedLicenseType" class="dropbox infoItems">
	          								<option value="0">None</option>
	          								<option value="1">Private Licensing Server</option>
	          								<option value="3">Private Child</option>
	          								<option value="4">Public Licensing Server</option>
											<option value="2">Public Child</option>
	     								</select>
									</td>
									<td class="borderless">
										<select id="ddlParentId" class="dropbox infoItems hidden">
											<option value="" disabled selected></option>
	     								</select>
									</td>
									<td class="borderless">
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding topPadding">
										<input disabled type="checkbox" class="checkbox disable" id=chkSrvId value="" checked/>
										<label id="divSrvId" class="disable" for="chkSrvId">Obtain CommCell ID</label>
									</td>
									<td class="borderless">
										<input type="checkbox" class="checkbox" id=chkResale value=""/>
										<label id="divResale" for="chkResale">Not for Resale</label>
									</td>
									<td class="borderless">
										<input type="checkbox" class="checkbox" id=chkSyncCS value=""/>
										<label id="divSyncCS" for="chkSyncCS">Sync up Licenses with CommServe</label>
									</td>
								</tr>
							</tbody>
						</table>
						<table style="display:inline;">
							<tbody>
								<tr>
									<td class="borderless leftPadding">Notes:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<textarea id="txtNotes" class="textbox infoItemsNotes"></textarea>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<div id="dCustInfo" class="info">
					<div id="divCustInfo" class="selected clickable expandable">
						<label class="clickable">Customer Information</label>
						<div id="divCustTriangle" class="collapse triangle"></div>
					</div>
					<div id="divCustInfoContent" class="hidden" style="margin-top:10px;">
						<table style="display:inline;">
							<tbody>
								<tr>
									<td class="borderless leftPadding">Customer Number:</td>
									<td class="borderless" id="lblOrg">Organization:</td>
									<td class="borderless">Contact Person:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input id="txtCustNo" type="text" class="textbox infoItemsCust"/>
									</td>
									<td class="borderless">
										<input id="txtOrg" type="text" class="textbox infoItemsCust"/>
										<select id="ddlOrg" class="dropbox infoItems hidden">
	     								</select>
									</td>
									<td class="borderless">
										<input id="txtContName" type="text" class="textbox infoItemsCust"/>
									</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">Order Number:</td>
									<td class="borderless">Requester Name:</td>
									<td class="borderless">Address:</td>
								</tr>
								<tr>
									<td class="borderless leftPadding">
										<input id="txtOrderNo" type="text" class="textbox infoItemsCust"/>
									</td>
									<td class="borderless">
										<input id="txtReqName" type="text" class="textbox infoItemsCust"/>
									</td>
									<td class="borderless">
										<input id="txtAddr" type="text" class="textbox infoItemsCust"/>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<div id="divLicenseList" class="licList"></div>
			</div>
			<div id="shoppingCartCust" title="New License Shopping Cart" class="noDisplay">
				<a href="" style="position:absolute;top:-100px">.</a>
				<div id="divSelectedLicenseCust">
				</div>
				<div class="dialogButton">
					<span class="applyLicRemotely disable">
						<input type="checkbox" class="checkbox" id="chkApplyLicRemotely" value=""/>
						<label id="lblApplyLicRemotely" for="chkApplyLicRemotely"><fmt:message key="Apply_License_Remotely"/></label>
					</span>
					<input type="button" id="cartLicGenerateBtnCust" class="mainBtn" value="Generate"/>
				</div>
				<p id="respMsg"></p>
			</div>
    		<div id="dialog-addCart" title="Update Quantities of Selected Licenses in the Grid" class="noDisplay">
				<a href="" style="position:absolute;top:-100px">.</a>
				<div id="divUpdate">
				</div>
				<div class="dialogButton">
					<input type="button" id="addCartOkBtnCust" class="mainBtn" value="Update"/>
				</div>
			</div>
			<div id="dialog-search" title="Search Results" class="noDisplay dialog">
				<a id="dummy" href="" style="position:absolute;top:-100px">.</a>
				<div id="divSearchResults" class="divSearchResults">
				</div>
				<div class="divSearchResults disableColor leftPadding">End of Search Results . . . . . .<a class="dialogLink" id="closeSearch">[CLOSE]</a><a class="dialogLink" id="gototop">[GO TO TOP]</a></div>
			</div>
			<div id="dialog-pnodetails" title="Part Number Details" class="noDisplay dialog">
				<a id="dummy" href="" style="position:absolute;top:-100px">.</a>
				<div id="divPnoDetails" class="divSearchResults">
				</div>
			</div>
			<div id="dialog-skudetails" title="SKU Details" class="noDisplay dialog">
				<a id="dummy" href="" style="position:absolute;top:-100px">.</a>
				<div id="divSkuDetails" class="divSearchResults">
				</div>
			</div>
			<div id="dialog-skubundledetails" title="SKU Bundle Details" class="noDisplay dialog">
				<a id="dummy" href="" style="position:absolute;top:-100px">.</a>
				<div id="divSkuBundleDetails" class="divSearchResults">
				</div>
			</div>
	    	<div class="clrfloat"></div>
		</div>
	</fmt:bundle>
	<jsp:include page="../common/footer.jsp">
		<jsp:param value="js/newbundles.js" name="js"/>
		<jsp:param value="../common/js/jquery.tablesorter.js" name="js"/>
	</jsp:include>