	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

	<fmt:bundle basename="localization.LicenseGenerator">
		<c:set var="title"><fmt:message key="Delete_License" /></c:set>
		<c:set var="breadcrumb"><fmt:message key="License_Generator_Header"/></c:set>
		<jsp:include page="../common/header.jsp">
			<jsp:param value="../common/css/headerstyles.css" name="css"/>
			<jsp:param value="../common/css/templatestyles.css" name="css"/>
			<jsp:param value="../common/css/table.css" name="css"/>
			<jsp:param value="css/licensegenerator.css" name="css"/>
			<jsp:param value="true" name="includeSecHeader" />
			<jsp:param value="${title}" name="titleLocalized" />
			<jsp:param value="${title}" name="headerTitleLocalized" />
			<jsp:param value="${breadcrumb}:licensegenerator/index.jsp" name="breadCrumbValues" />
		</jsp:include>
		<c:url var="lsrUrl" value="https://cloud.commvault.com/webconsole/reportsplus/reportViewer.jsp?reportId=License%20summary%20worldwide">
		</c:url>
		<div>
			<div class="selected lsr">
				<a href="${lsrUrl}" target="_blank">Current License Usage</a>
			</div>
			<div class="info infoModify"></div>
		</div>
		<span class="loadSpinner"></span>
		<div class="cvApps">
			<table>
				<tbody>
					<tr>
						<td class="borderless">CommCell ID (in hex):</td>
						<td class="borderless"></td>
					</tr>
					<tr>
						<td class="borderless">
							<input type="text" id="txtCsId" class="textbox infoItems" value=""/>
						</td>
						<td class="borderless">
							<input type="button" id="deleteCCID" class="mainBtn" value="Delete"/>
						</td>
						<td class="borderless leftPadding notesStyle">
							<span>Use this button to delete the license mapped to the CommCell ID entered</span>
						</td>
					</tr>
					<tr>
						<td class="borderless">Registration Code:</td>
						<td class="borderless"></td>
					</tr>
					<tr>
						<td class="borderless">
							<input type="text" id="txtRegCode" class="textbox infoItems" value=""/>
						</td>
						<td class="borderless">
							<input type="button" id="deleteRegCode" class="mainBtn" value="Delete"/>
						</td>
						<td class="borderless leftPadding notesStyle">
							<span>Use this button to delete the license linked to the Registration Code entered</span>
						</td>
					</tr>
				</tbody>
			</table>
			<div class="info">
				<br/><br/><br/><br/>
				<span class="warningColor">Please Note: On clicking delete, all existing license details (for the corresponding CommCell ID/Registration Code) will be removed from the database completely. Hence please use these options carefully</span>
				<br/><br/><br/><br/>
			</div>
			<div id="confirm" title="Confirm Deletion" class="noDisplay"></div>
	    	<div class="clrfloat"></div>
		</div>
	</fmt:bundle>
	<jsp:include page="../common/footer.jsp">
		<jsp:param value="js/deletelicense.js" name="js"/>
		<jsp:param value="../common/js/jquery.tablesorter.js" name="js"/>
	</jsp:include>