<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="upload.error.folderUploadError" var="folderUploadError" />
	<fmt:message key="upload.label.failedText" var="uploadFailedError" />
	<fmt:message key="upload.label.uploadTitle" var="uploadTitle" />
<div class="uploadFileDiv">
	<script nonce="${sessionScope.cspNonce}" type="text/JavaScript" src="../upload/js/upload.js?${applicationScope.BUILD_TS}"></script>
	<form class="uploadFrm" method="POST" enctype="multipart/form-data" action="uploadFile.do">
		<div class="headerDiv">
            <fmt:message key="upload.title.uploadFilesTitle" />
        </div>
        <div class="closeDiv">
        </div>
		<div class="uploadDiv" style="display:none">
			<input type="text" name="clientId" class="clientId textbox doNotShow" value="${requestScope.clientId}"/>
			<input type="text" name="destPath" class="destPath textbox doNotShow" value="${requestScope.fullPath}"/>
			<input type="text" name="shareFolderId" class="shareFolderId textbox doNotShow" value="${requestScope.shareFolderId}"/>
			<input type="text" name="parentGuid" class="parentGuid textbox doNotShow" value="${requestScope.parentGuid}"/>
			<input type="text" name="actualFilePath" class="actualFilePath textbox doNotShow" value="${requestScope.actualFilePath}"/>
			<input type="text" name="isFile" class="isFile textbox doNotShow" value="true"/>
			<!--[if lt IE 10 ]>
			<input type="text" name="incompatibleBrowser" class="incompatibleBrowser textbox doNotShow" value="true"/>
			<![endif]-->
			<input type="file" multiple = "multiple" name="attachment" class="textbox attachment" />
			<div class="uploadFiles">
				<div id="selectedFilesText" class="hidden"><fmt:message key="upload.label.selectedFiles" /></div>
				<ul class="selectedFiles">
				</ul>
			</div>
			<label class="attachmentError"><fmt:message key="upload.error.pleaseSelectFileToUpload" /></label>
		</div>

		<div class="uploadInProgress" style="display:none">
			<div class="text"><fmt:message key="upload.label.uploading" /></div>
			<img src="../upload/img/sending_progress.gif">
		</div>

		<div class="uploadCompleted" style="display:none">
			<div class="ctext"><span class="fNames"></span> <fmt:message key="upload.label.hasBeenUploaded" /> <span class="destLocation"></span> !</div>
			<div class="noteClass"><fmt:message key="upload.label.restoreScreenNote" /></div>
		</div>

		<div class="uploadCancel" style="display:none">
			<div class="ctext_canceling"><fmt:message key="upload.label.cancellingUpload" /></div>
			<div class="ctext_cancelled"><fmt:message key="upload.label.uploadHasBeenCancelled" /></div>
		</div>

		<div class="uploadFailed" style="display:none">
			<div class="ctext_Failed"></div>

		</div>

		<div class="leftBtns btns" style="display:none">
			<a type="button" class="cancelButton buttons"><fmt:message key="upload.label.cancel" /></a>
			<input type="submit" value="${uploadTitle}" class="uploadButton mainBtn buttons okSaveCancel" >
		</div>

	</form>
</div>
<script nonce="${sessionScope.cspNonce}" >
var isFile = true;
var showNotes = true;
var incompatibleBrowser = false;
var folderUploadError = "${folderUploadError}";
var localMsg = localMsg || {};
localMsg.uploadFailedError = "${uploadFailedError}";
</script>
<!--[if lt IE 10 ]>
<script nonce="${sessionScope.cspNonce}" >
incompatibleBrowser = true;
$(".uploadFiles").hide();
</script>
<![endif]-->
</fmt:bundle>





