<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/header.jsp">
		<jsp:param value="css/upload.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
	</jsp:include>

	
	<div class="uploadFileDiv">
	<script nonce="${sessionScope.cspNonce}" type="text/JavaScript" src="../upload/js/upload.js?${applicationScope.BUILD_TS}"></script>
		<div class="headerDiv">
			<fmt:message key="upload.title.uploadFilesTitle" />
		</div>
		
		<c:choose>
			<c:when test="${requestScope.RESULT == 'Cancel'}">
				<div class="uploadCancel">
					<div class="ctext_cancelled"> <fmt:message key="upload.label.uploadHasBeenCancelled" /></div>
				</div>
			</c:when>
			<c:when test="${requestScope.RESULT == 'Error'}">
					<div class="uploadFailed">
						<div class="ctext_Failed"><fmt:message key="upload.label.failedText" /></div>
					</div>
			</c:when>
			<c:otherwise>
				<div class="uploadCompleted">
					<div class="ctext"><span class="fNames">${requestScope.FILE_NAMES}</span> <fmt:message key="upload.label.hasBeenUploaded" /> <span class="destLocation">${requestScope.destPath}</span></div>
					<div class="noteClass"><fmt:message key="upload.label.restoreScreenNote" /></div>
				</div>
			</c:otherwise>
		</c:choose>		
		
		
		
		
	
				
		<div class="leftBtns btns">
			<a type="button" class="cancelButton buttons"> <fmt:message key="upload.label.close" /></a>
		</div>
		
</div>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
$(".fNames").text($(".fNames").text().substring(1,$(".fNames").text().length-1));
$(".cancelButton").on("click", function(){
	cvUtil.closeModal();
});
</script>
<style>
.noteClass{
	padding-top: 15px;
	font-size: 0.9em;
	line-height: 1.5;
	color: #777;
}
.uploadCompleted, .uploadFailed, .uploadCancel{
	padding-left: 10px;
	padding-top: 10px;
}
.cancelButton{
	cursor:pointer;
}
</style>

