<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<ul class="pageTabs vw-page-tabs">
	<li class="summaryTabsLi vw-tab-title" id="fs"><fmt:message key="summary.link.computers" /></li>
	
	<c:if test="${showSync}">
		<li class="summaryTabsLi vw-tab-title" id="webFolder"><fmt:message key="summary.link.sync" /></li>
	</c:if>
	<c:if test="${showEmail}">
		<li class="summaryTabsLi vw-tab-title" id="email"><fmt:message key="summary.link.email" /></li>
	</c:if>
	<c:if test="${showVm}">
		<li class="summaryTabsLi vw-tab-title" id="virtualServer"><fmt:message key="summary.link.vms" /></li>
	</c:if>
	<c:if test="${showSharedFolders}">
		<li class="summaryTabsLi vw-tab-title" id="shareFolder"><fmt:message key="summary.link.sharedFolder" /></li>
	</c:if>
	<c:if test="${showSharePoint}">
		<li class="summaryTabsLi vw-tab-title" id="sharepoint"><fmt:message key="summary.link.sharepoint" /></li>
	</c:if>
</ul>

<script nonce="${sessionScope.cspNonce}" >
$("body").on("click", ".summaryTabsLi", function(){
	var params = [];
	params.push(cvUtil.createParamString("page", this.id));
	History.pushState(null, document.title, "?" + cvUtil.createParamsString(params));
	$(".vw-tab-selected").removeClass("vw-tab-selected");
	$(this).addClass("vw-tab-selected");
	
	if (this.id == "shareFolder"){
		cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
			$("#holder").html(data);
		});
	}else if (this.id == "webFolder"){
		cvUtil.loadPage('displaySummaryWF.jsp', null, function(data) {
			$("#holder").html(data);
		});
	}else if (this.id == "email"){
		cvUtil.loadPage('displaySummaryMail.jsp', null, function(data) {
			$("#holder").html(data);
		});
	}else if (this.id == "virtualServer"){
		cvUtil.loadPage('displaySummaryVs.jsp', null, function(data) {
			$("#holder").html(data);
		});
	}else if (this.id == "sharepoint"){
		cvUtil.loadPage('displaySummarySharepoint.jsp', null, function(data) {
			$("#holder").html(data);
		});
	}else if (this.id == "fs"){
		cvUtil.loadPage('displaySummaryFs.jsp',
				typeof enableMultiCommCell === "undefined" ? null : {enableMultiCommCell: enableMultiCommCell},
				function(data) {
			$("#holder").html(data);

			<%-- Manually bootstrap the 'reports' application after the tab content is loaded. --%>
			if (typeof angular === "object") {
				angular.bootstrap(angular.element("#ng-app"), [ 'reports' ]);
			}});
		}
	});
</script>