<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="share.label.notificationPreference" var="notificationPreference" />
	<fmt:message key="share.lavel.subscribeToShareNotification" var="subscribeToShareNotification" />
	<fmt:message key="share.label.individualUpdates" var="individualUpdates" />
	<fmt:message key="share.label.shareSummary" var="summaryWithDetails" />
	<fmt:message key="share.label.dontSendNotification" var="dontSendNotifications" />
	<fmt:message key="share.label.subscribeEmail" var="subscribeToEmailAlerts" />
	<fmt:message key="share.label.emailAlerts" var="emailAlerts" />
	<fmt:message key="share.label.emailAlertsSub" var="emailAlertsSub" />
	<fmt:message key="share.label.standard" var="standard"> </fmt:message>
	<fmt:message key="share.label.frequent" var="frequent"> </fmt:message>
	<fmt:message key="share.label.emailAlertsInHours" var="emailAlertsInHours"></fmt:message>
	<fmt:message key="share.label.disabledEmailAlerts" var="disabledEmailAlerts"></fmt:message>
	
</fmt:bundle>

<div id="notificationModal" class="modal hideOnExportFriendly hidden-print vw-hidden-export vw-notification-preference" role="dialog" style="overflow:none" >
	<div class="modal-dialog vw-modal-notifation">
			<div class="modal-header vw-modal-header">
				<button type="button" class="close" data-dismiss="modal"></button>
				<h4 id="myModalLabel" style="color: #069">${notificationPreference}</h4>
			</div>
			<div class="modal-body vw-notification-container vw-notification-body">
			<div>
			 <div>
			 	<div class="vw-notification-alert-text">${subscribeToShareNotification}</div>
			 	<select id="shareNotification" class="vw-summary-share-notification">
			 		<option value="2" >${summaryWithDetails}</option>
			 		<option value="1">${individualUpdates}</option>
			 		<option value="0">${dontSendNotifications}</option>
			 	</select>
			 </div>
			 <div class="vw-share-help-text"></div>
			 
			 <div class="vw-notification-alert-container">
			 	<div class="vw-notification-alert-text">${subscribeToEmailAlerts}</div>
			 	<select id="alertNotification" class="vw-summary-share-notification">
			 	</select>
			</div>
		</div>
		<div class="vw-notification-btn-grp modal-footer vw-notification-footer">
			<button type="button" class="vw-btn vw-btn-default" id="shareCancelButton" data-dismiss="modal" role="button">Cancel</button>
			<button id="shareSubmitButton" type="button" class="vw-btn vw-btn-primary" >Submit</button>
		</div>
	</div>
	</div>
</div>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.emailAlertsInHours = "${emailAlertsInHours}";
	localMsg.emailAlertsConfig = "${applicationScope.NTDigestDurationInMins}";
	localMsg.emailAlertsInHours = localMsg.emailAlertsInHours.replace("{0}", localMsg.emailAlertsConfig);
	localMsg.disabledEmailAlerts = "${disabledEmailAlerts}";
	$('#alertNotification').append($('<option>', {
	    value: 1,
	    text: localMsg.emailAlertsInHours
	}));
	$('#alertNotification').append($('<option>', {
	    value: 0,
	    text: localMsg.disabledEmailAlerts.replace('&#039;', '\'')
	}));
</script>