<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.messages">
	<fmt:message key="error.showDetails" var="errorShowDetails"/>
	<fmt:message key="Protected.title" var="ProtectedTitle"/>
	<fmt:message key="SemiProtected.title" var="SemiProtectedTitle"/>
	<fmt:message key="NotProtected.title" var="NotProtectedTitle"/>
	<fmt:message key="Protected.desc" var="ProtectedDesc"/>
	<fmt:message key="SemiProtected.desc" var="SemiProtectedDesc"/>
	<fmt:message key="NotProtected.desc" var="NotProtectedDesc"/>
	<fmt:message key="summary.link.vms" var="vms" />
</fmt:bundle>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.clients" var="labelClients"/>
	<fmt:message key="summary.label.protected" var="labelProtected"/>
	<fmt:message key="summary.label.lastBackup" var="labelLastBackup"/>
	<fmt:message key="summary.label.nextBackup" var="labelNextBackup"/>
	<fmt:message key="summary.label.size" var="labelSize"/>
	<fmt:message key="summary.label.actions" var="labelActions"/>
	<fmt:message key="summary.label.Archived" var="labelArchived"/>
</fmt:bundle>

<div id="laptopList" class="vw-summary-vms-list"></div>

<script type="text/template" id="VMTemplate">
<span class="sectiontitle vw-page-title">${vms}</span>
<div class="sub-section">
	<div class="subsec-body clientJobs vw-data-table">
		<ul class="secrowhead secrows vw-data-row vw-heading-row clearfix">
			<li class="li1 vw-row_computers" data-title="{{labelClients}}">{{labelClients}}</li>
			<li class="li2 vw-row_protected text-center" data-title="{{labelProtected}}">{{labelProtected}}</li>
			<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{labelLastBackup}}</li>
			<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{labelNextBackup}}</li>
			<li class="li5 vw-row_size" data-title="{{labelSize}}">{{labelSize}}</li>
			<li class="li6 vw-row_actions" data-title="{{labelActions}}">{{labelActions}}</li>
		</ul>
		<div class="browseDataRows vw-data-table_content">
			{{#VS_BK_LIST}}
				<ul class="secrows vw-data-row clearfix">
					<li class="li1 vw-row_computers" data-title="{{labelClients}}">
						<a class="someLink" href="{{curContext}}/vmBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}&source=backups">
							{{clientName}}
						</a>
						{{#archived}}
							<img class="recovervm dummyicon" id='archived_{{clientName}}' src="img/archived.png" alt='{{labelArchived}}' title='{{labelArchived}}'/>
						{{/archived}}
					</li>
					<li class="li2 vw-row_protected" data-title="{{labelProtected}}"><div class="centerpad text-center"><span class="sprite icon-dot-{{protectedImg}}" alt="{{protectedStatusTitle}}" title="{{protectedStatusDesc}}" role="img"></span></div></li>
					<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{lastBackup}}</li>
					<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{nextBackup}}</li>
					<li class="li5 vw-row_size" data-title="{{labelSize}}">{{totalSize}}</li>
					<li class="li6 vw-row_actions" data-title="{{labelActions}}">
						<a class="someLink" href="{{curContext}}/vmprovisioning/vmDetails.do?clientName={{clientName}}&source{{backups}}">
							{{errorShowDetails}}
						</a>
					</li>
				</ul>
			{{/VS_BK_LIST}}
			{{#VS_BK_LISTThree}}
				<ul class="secrows lastrow"></ul>
			{{/VS_BK_LISTThree}}
		</div>
	</div>
</div>
</script>

<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
 	localMsg.ProtectedTitle = "${ProtectedTitle}";
 	localMsg.SemiProtectedTitle = "${SemiProtectedTitle}";
 	localMsg.NotProtectedTitle = "${NotProtectedTitle}";
 	localMsg.ProtectedDesc = "${ProtectedDesc}";
 	localMsg.SemiProtectedDesc = "${SemiProtectedDesc}";
 	localMsg.NotProtectedDesc = "${NotProtectedDesc}";
 	localMsg.labelClients = "${labelClients}";
 	localMsg.labelProtected = "${labelProtected}";
 	localMsg.labelLastBackup = "${labelLastBackup}";
 	localMsg.labelNextBackup = "${labelNextBackup}";
 	localMsg.labelSize = "${labelSize}";
 	localMsg.labelActions = "${labelActions}";
 	localMsg.errorShowDetails = "${errorShowDetails}";
 	localMsg.labelArchived = "${labelArchived}";
</script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummaryVs.js?${applicationScope.BUILD_TS}"></script>
