<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.messages">
	<fmt:message key="SemiProtected.title" var="SemiProtectedTitle"/>
	<fmt:message key="NotProtected.title" var="NotProtectedTitle"/>
	<fmt:message key="Protected.desc" var="ProtectedDesc"/>
	<fmt:message key="SemiProtected.desc" var="SemiProtectedDesc"/>
	<fmt:message key="NotProtected.desc" var="NotProtectedDesc"/>
	<fmt:message key="summary.link.sharepoint" var="sharepoint" />
</fmt:bundle>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.clients" var="labelClients"/>
	<fmt:message key="summary.label.protected" var="ProtectedTitle"/>
	<fmt:message key="summary.label.lastBackup" var="labelLastBackup"/>
	<fmt:message key="summary.label.nextBackup" var="labelNextBackup"/>
</fmt:bundle>

<div id="laptopList" class="vw-summary-sharepoint-list"></div>

<script type="text/template" id="sharePointTemplate">
<span class="sectiontitle vw-page-title">${sharepoint}</span>
<div class="sub-section">
	<div class="subsec-body clientJobs vw-data-table">
		<ul class="secrowhead secrows vw-data-row vw-heading-row clearfix">
			<li class="li1 vw-row_computers" data-title="{{labelClients}}">{{labelClients}}</li>
			<li class="li2 vw-row_protected text-center" data-title="{{labelProtected}}">{{labelProtected}}</li>
			<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{labelLastBackup}}</li>
			<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{labelNextBackup}}</li>
		</ul>
		<div class="browseDataRows vw-data-table_content">
			{{#SHAREPOINT_BK_LIST}}
				<ul class="secrows vw-data-row clearfix">
					<li class="li1 vw-row_computers" data-title="{{labelClients}}">
						{{#browseCapableUser}}
							<a href="{{curContext}}/browse/sharepointBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}&backupsetId={{backupsetId}}&subclientId={{subclientId}}">
								{{clientName}}
							</a>
						{{/browseCapableUser}}
						{{^browseCapableUser}}
							{{clientName}}
						{{/browseCapableUser}}
					<li class="li2 vw-row_protected" data-title="{{labelProtected}}">
						<div class="centerpad text-center">
							<span class="sprite icon-dot-{{protectedImg}}" alt="{{protectedStatusTitle}}" title="{{protectedStatusDesc}}" role="img"></span>
						</div>
					</li>
					<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{lastBackup}}</li>
					<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{nextBackup}}</li>
				</ul>
			{{/SHAREPOINT_BK_LIST}}
			{{#SHAREPOINT_BK_LISTLastRow}}
				<ul class="secrows lastrow vw-data-row clearfix">

				</ul>
			{{/SHAREPOINT_BK_LISTLastRow}}
		</div>
	</div>
</div>
</script>

<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
localMsg.ProtectedTitle = "${ProtectedTitle}";
localMsg.SemiProtectedTitle = "${SemiProtectedTitle}";
localMsg.NotProtectedTitle = "${NotProtectedTitle}";
localMsg.ProtectedDesc = "${ProtectedDesc}";
localMsg.SemiProtectedDesc = "${SemiProtectedDesc}";
localMsg.NotProtectedDesc = "${NotProtectedDesc}";
localMsg.labelClients = "${labelClients}";
localMsg.ProtectedTitle = "${ProtectedTitle}";
localMsg.labelLastBackup = "${labelLastBackup}";
localMsg.labelNextBackup = "${labelNextBackup}";
</script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummarySharePoint.js?${applicationScope.BUILD_TS}"></script>
