<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<jsp:include page="../common/table.jsp" flush="true">
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="true" name="bootstrapped" />
</jsp:include>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.myComputer" var="labelComputerText"/>
</fmt:bundle>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="sharing.label.savedFolderUpdated" var="savedFolderUpdatedText" />
	<fmt:message key="sharing.label.savedFolderDeletedText" var="savedFolderDeletedText" />
	<fmt:message key="share.label.shareTitle" var="shareTitle" />
	<fmt:message key="share.error.somethingWentWrong" var="somethingWentWrongText" />
	<fmt:message key="sharing.lebel.confirmLeaveText" var="confirmLeaveText" />
	<fmt:message key="sharing.label.confirmLeaveTitle" var="confirmLeaveTitle" />
	<fmt:message key="sharing.lebel.confirmDeleteText" var="confirmDeleteText" />
	<fmt:message key="sharing.label.confirmDeleteTitle" var="confirmDeleteTitle" />
	<fmt:message key="share.label.sharedWithMe" var="sharedWithMe" />
	<fmt:message key="share.label.sharedByMe" var="sharedByMe" />
	<fmt:message key="share.label.searchShares" var="searchShares" />
	<fmt:message key="share.label.publicLinks" var="publicLinks" />
	<fmt:message key="share.label.systemShares" var="systemShares" />
	<fmt:message key="share.label.addSystemShare" var="addSystemShare" />
	<fmt:message key="share.label.untitledSystemShare" var="untitledSystemShare" />
	<fmt:message key="share.msg.noShares" var="noShares" />
	<fmt:message key="sharing.label.ConfigureAction" var="ConfigureAction"/>
	<fmt:message key="share.label.getLink" var="GetLink"/>
	<fmt:message key="sharing.label.LeaveAction" var="LeaveAction"/>
	<fmt:message key="sharing.label.ConfigureShareAction" var="ConfigureShareAction"/>
	<fmt:message key="sharing.label.UnshareAction" var="unshareShare"/>
	<fmt:message key="sharing.label.folderName" var="folderNameLabel" />
	<fmt:message key="sharing.label.Owner" var="Owner" />
	<fmt:message key='sharing.label.path' var="pathText"/>
	<fmt:message key="sharing.label.deleteAction" var="deleteShare"/>

	<fmt:message key="backupBrowse.label.copyPreviewURL" var="publicLinkTitle" />
	<fmt:message key='sharing.label.never' var='never' />
	<fmt:message key='sharing.label.days' var='days' />
	<fmt:message key='sharing.label.created' var='labelCreated' />
	<fmt:message key='sharing.label.expired' var='expired' />
	<fmt:message key='sharing.label.expired1' var='expired1' />
	<fmt:message key='sharing.label.expiry' var='labelExpiry' />
	<fmt:message key="sharing.label.labelSource" var='labelSource' />
	<fmt:message key="share.iconhovertext.reshare" var='reshareIconHoverText' />
	<fmt:message key="share.label.resharetext" var='reshareIndicatorText' />
	<fmt:message key="sharing.label.confirmDeleteTextLink" var="confirmDeleteTextLink" />
</fmt:bundle>
<fmt:bundle basename="localization.messages">
	<fmt:message key="summary.link.sharedFolder" var="shares" />
	<fmt:message key="library" var="librariesLabel"/>
	<fmt:message key="moniker.Desktop" var="desktopLabel"/>
	<fmt:message key="moniker.Music" var="musicLabel"/>
	<fmt:message key="moniker.Photo" var="photoLabel"/>
	<fmt:message key="moniker.Documents" var="documentsLabel"/>
	<fmt:message key="moniker.Videos" var="videosLabel"/>
	<fmt:message key="moniker.Pictures" var="picturesLabel"/>
</fmt:bundle>

	<div class="row vw-top-margin-10">
		<div class="col-sm-12">
			<span class="sectiontitle vw-page-title" id="sharesTitle"></span>
			<c:if test="${sessionScope.COLLABORATIVE_SHARE}">
			<a id="addSystemShare" class="vw-addSystemShare vw-btn vw-btn-secondary vw-hidden pull-right" tabindex="0" role="button"><span class="sprite icon-plus"></span><span class="hideSystemShare hidden-sm">&nbsp;${addSystemShare}</span></a>
			</c:if>
		</div>
	</div>
<fmt:bundle basename="localization.BackupBrowseMessages">
<div id="nothingShared" class="vw-noData text-center vw-hidden vw-center-container">
	<div class="vw-vertical-center">
		<div class="vw-horizontal-center">
			<div id="svgSharedByMe" class="vw-hidden">
				<div class="vw-nothingSharedText"><fmt:message key="share.label.nothingSharedByMe"/></div>
				<svg class="vw-nothingSharedSvg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" role="img" alt="" focusable="false"><polygon aria-hidden="true" role="presentation" points="10.33 14.23 10.01 14.34 10.4 15.47 7.67 14.01 7.51 14.3 10.24 15.77 9.07 16.07 9.16 16.39 10.91 15.94 10.33 14.23"/><polygon aria-hidden="true" role="presentation" points="9.7 18.18 6.45 16.44 6.45 11.08 9.7 12.82 9.7 13.82 9.21 13.61 9.21 13.1 6.95 11.88 6.95 16.14 9.2 17.34 9.2 16.78 9.7 16.96 9.7 18.18"/><path aria-hidden="true" role="presentation" d="M20.88,14.09V7.55L12.44,2.68,4,7.55v9.74l8.44,4.87,4.28-2.47a3.77,3.77,0,1,0,4.16-5.6ZM12.44,3.6l7.21,4.16L17.24,9.06l-7.1-4.13ZM12,21,4.8,16.83V8.45L12,12.33ZM5.23,7.77l3.42-2,7,4.1-3.24,1.74ZM12.84,21V12.33l3.28-1.76v2.69l1.5-.8V9.77l2.46-1.32V14h-.14a3.74,3.74,0,0,0-3.56,5Zm9.76-2.86H17.27v-.82H22.6Z"/></svg>
			</div>
			<div id="svgSharedWithMe" class="vw-hidden">
				<div class="vw-nothingSharedText"><fmt:message key="share.label.nothingSharedWithMe"/></div>
				<svg class="vw-nothingSharedSvg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" role="img" alt="" focusable="false"><polygon aria-hidden="true" role="presentation" points="8.02,16.06 8.34,15.95 7.95,14.81 10.68,16.28 10.84,15.99 8.11,14.52 9.28,14.22 9.19,13.89 7.44,14.35 8.02,16.06" /><polygon aria-hidden="true" role="presentation" points="9.55,18.07 6.3,16.33 6.3,10.97 9.55,12.71 9.55,13.71 9.06,13.49 9.06,12.99 6.8,11.77 6.8,16.03 9.05,17.23 9.05,16.67 9.55,16.85 9.55,18.07" /><path aria-hidden="true" role="presentation" d="M 20.94 14.17 V 7.63 L 12.5 2.76 L 4.06 7.63 v 9.74 l 8.44 4.87 l 4.28 -2.47 a 3.77 3.77 0 1 0 4.16 -5.6 Z M 12.5 3.68 l 7.21 4.16 L 17.3 9.14 L 10.2 5 Z m -0.4 17.4 L 4.86 16.91 V 8.53 l 7.24 3.88 Z M 5.29 7.85 l 3.42 -2 l 7 4.1 L 12.5 11.71 Z M 12.9 21.08 V 12.41 l 3.28 -1.76 v 2.69 l 1.5 -0.8 V 9.85 l 2.46 -1.32 v 5.53 H 20 a 3.74 3.74 0 0 0 -3.56 5 Z m 9.76 -2.86 H 17.33 v -0.82 h 5.33 Z" /></svg>
			</div>
			<div id="svgCollabShare" class="vw-hidden">
				<div class="vw-nothingSharedText"><fmt:message key="share.label.nothingSharedCollab" /></div>
				<svg class="vw-nothingSharedSvg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" role="img" alt="" focusable="false"><path aria-hidden="true" role="presentation" d="M 7.94 13.28 a 0.5 0.5 0 0 1 0.14 0.19 l 0.09 0.24 l 0.16 -0.26 l 0.16 0 h 0.16 l 1.28 2.42 a 0.72 0.72 0 0 0 -0.17 0.27 L 7 16.06 a 0.72 0.72 0 0 0 -0.16 -0.3 L 7 15.6 H 6.89 a 0.49 0.49 0 0 1 -0.33 -0.14 l 0 0.07 l -0.15 0 a 0.73 0.73 0 1 0 0.66 1 l 2.73 0.1 a 0.73 0.73 0 1 0 0.73 -0.91 h -0.17 L 9 13.26 a 0.73 0.73 0 1 0 -1.06 0 Z" /><path aria-hidden="true" role="presentation" d="M 21 14.15 V 7.61 L 12.56 2.74 L 4.12 7.61 v 9.74 l 8.44 4.87 l 4.28 -2.47 A 3.77 3.77 0 1 0 21 14.15 Z M 12.56 3.66 l 7.21 4.16 L 17.35 9.12 L 10.26 5 Z m -0.4 17.4 L 4.92 16.89 V 14.83 A 2.57 2.57 0 0 1 7.4 14.7 l -0.57 0.18 a 0.23 0.23 0 0 0 -0.14 0.11 a 0.24 0.24 0 0 0 0 0.19 a 0.25 0.25 0 0 0 0.12 0.14 l 0.1 0 H 7 l 1.34 -0.45 l -0.48 -1.33 a 0.25 0.25 0 0 0 -0.22 -0.16 H 7.54 a 0.23 0.23 0 0 0 -0.14 0.11 a 0.24 0.24 0 0 0 0 0.19 l 0.21 0.55 a 3.07 3.07 0 0 0 -2.68 0 V 8.51 l 7.24 3.88 Z M 5.34 7.82 l 3.42 -2 l 7 4.1 l -3.24 1.74 Z m 10.93 10 A 3.74 3.74 0 0 0 16.5 19 l -3.54 2 V 12.38 l 3.28 -1.76 v 2.69 l 1.5 -0.8 V 9.82 l 2.46 -1.32 V 14 h -0.14 A 3.78 3.78 0 0 0 16.28 17.8 Z m 6.44 0.41 H 17.39 v -0.82 h 5.33 Z" /></svg>
			</div>
			<div id="svgPublicShare" class="vw-hidden">
				<div class="vw-nothingSharedText"><fmt:message key="share.label.nothingSharedPublic"/></div>
				<svg class="vw-nothingSharedSvg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" role="img" alt="" focusable="false"><path aria-hidden="true" role="presentation" d="M20.9,14.15V7.61L12.46,2.74,4,7.61v9.74l8.44,4.87,4.28-2.47a3.77,3.77,0,1,0,4.16-5.6ZM12.46,3.66l7.21,4.16L17.26,9.12,10.17,5Zm-.4,17.4L4.83,16.89V15.76a3.41,3.41,0,0,1,2-.8,2.42,2.42,0,0,1,1,.21l-.53.19a.22.22,0,0,0-.12.11.22.22,0,0,0,0,.18.23.23,0,0,0,.12.12l.09,0h.08l1.24-.47-.5-1.23A.24.24,0,0,0,8,13.93H7.92a.22.22,0,0,0-.12.11.22.22,0,0,0,0,.18l.21.51a2.88,2.88,0,0,0-1.16-.24,4.09,4.09,0,0,0-2,.66V8.51l7.24,3.88ZM5.25,7.82l3.42-2,7,4.1-3.24,1.74Zm10.93,10A3.74,3.74,0,0,0,16.4,19l-3.54,2V12.38l3.28-1.76v2.69l1.5-.8V9.82L20.1,8.51V14H20A3.78,3.78,0,0,0,16.18,17.8Zm6.44.41H17.3v-.82h5.33Z"/><ellipse aria-hidden="true" role="presentation" cx="8.83" cy="17.44" rx="0.55" ry="0.54" transform="translate(-7.68 6.97) rotate(-30.75)"/><ellipse aria-hidden="true" role="presentation" cx="10.37" cy="15.91" rx="0.49" ry="0.48" transform="translate(-6.92 8.04) rotate(-32.44)"/><ellipse aria-hidden="true" role="presentation" cx="10.44" cy="14.2" rx="0.43" ry="0.42" transform="translate(-6.22 8.44) rotate(-34.6)"/><ellipse aria-hidden="true" role="presentation" cx="9.27" cy="12.64" rx="0.37" ry="0.36" transform="translate(-5.78 8.24) rotate(-37.44)"/><ellipse aria-hidden="true" role="presentation" cx="7.19" cy="12.48" rx="0.32" ry="0.31" transform="translate(-6.45 7.85) rotate(-41.34)"/></svg>
			</div>
		</div>
	</div>
</div>
</fmt:bundle>

<div class="dataTables_wrapper">
	<table id="sharesTable"  class="vw-data-table table dataTables dt-responsive nowrap table-striped sharedClose" width="100%">
		<thead class="vw-heading-row">
			<tr id="headerShares">
			</tr>
		</thead>
		<tbody id="sharesBody" class="vw-data-row">
		</tbody>
	</table>
</div>
<script nonce="${sessionScope.cspNonce}" >
var savedFolderUpdatedText = "${savedFolderUpdatedText}";
var savedFolderDeletedText = "${savedFolderDeletedText}";
var statusExpired = "${commvault.msgs.web.App.ShareStatus.EXPIRED}";

var localMsg = localMsg || {};
localMsg.somethingWentWrong = "${somethingWentWrongText}";
localMsg.confirmLeaveText = "${confirmLeaveText}";
localMsg.confirmLeaveTitle = "${confirmLeaveTitle}";
localMsg.confirmDeleteText = "${confirmDeleteText}";
localMsg.confirmDeleteTitle = "${confirmDeleteTitle}";
localMsg.neverText = "${never}";
localMsg.daysText = " ${days}";
localMsg.expiredText = "${expired1}";
localMsg.shareTitle = "${shareTitle}";
localMsg.publicLinkTitle = "${publicLinkTitle}";
localMsg.labelfolderName = "${folderNameLabel}";
localMsg.labelOwner = "${Owner}";
localMsg.labelPathText = "${pathText}";
localMsg.labelComputerText = "${labelComputerText}";
localMsg.labelExpiry = "${labelExpiry}";
localMsg.labelCreated="${labelCreated}";
localMsg.sharedWithMe = "${sharedWithMe}";
localMsg.sharedByMe = "${sharedByMe}";
localMsg.searchShares = "${searchShares}";
localMsg.publicLinks = "${publicLinks}";
localMsg.systemShares = "${systemShares}";
localMsg.labelSource = "${labelSource}";
localMsg.addSystemShare = "${addSystemShare}";
localMsg.noShares = "${noShares}";
localMsg.untitledSystemShare = "${untitledSystemShare}";
localMsg.librariesLabel ="${librariesLabel}";
localMsg.desktopLabel ="${desktopLabel}";
localMsg.musicLabel ="${musicLabel}";
localMsg.photoLabel ="${photoLabel}";
localMsg.documentsLabel ="${documentsLabel}";
localMsg.videosLabel ="${videosLabel}";
localMsg.picturesLabel ="${picturesLabel}";
localMsg.ConfigureAction = "${ConfigureAction}";
localMsg.deleteShare = "${deleteShare}";
localMsg.confirmDeleteTextLink= "${confirmDeleteTextLink}";
var configureShare = "${ConfigureShareAction}";
var unshareShare = "${unshareShare}";
var getLink = "${GetLink}";
var LeaveAction = "${LeaveAction}";
var reshareIndicatorText="${reshareIndicatorText}";
var reshareIconHoverIndicatorText ="${reshareIconHoverText}";
var labelExpiry = "${labelExpiry}";
</script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummaryShareFolder.js?${applicationScope.BUILD_TS}"></script>