<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<fmt:bundle basename="localization.messages">
	<fmt:message key="SemiProtected.title" var="SemiProtectedTitle"/>
	<fmt:message key="NotProtected.title" var="NotProtectedTitle"/>
	<fmt:message key="Protected.desc" var="ProtectedDesc"/>
	<fmt:message key="SemiProtected.desc" var="SemiProtectedDesc"/>
	<fmt:message key="NotProtected.desc" var="NotProtectedDesc"/>
	<fmt:message key="summary.link.email" var="email" />
	<fmt:message key="date.NotAvailable" var="dateNotAvailable" />
	<fmt:message key="not.scheduled" var="notScheduled" />
</fmt:bundle>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.quotaUsage" var="labelQuotaUsage"/>
	<fmt:message key="summary.label.displayName" var="labelDisplayName"/>
	<fmt:message key="summary.label.protected" var="ProtectedTitle"/>
	<fmt:message key="summary.label.lastBackup" var="labelLastBackup"/>
	<fmt:message key="summary.label.nextBackup" var="labelNextBackup"/>
	<fmt:message key="summary.label.myDelegatedMails" var="labelMyDelegatedMails"/>
</fmt:bundle>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="sharing.label.participatingUsers" var="labelSharedWith" />
	<fmt:message key="share.label.dateDelegated" var="labelDateCreated" />
	<fmt:message key="share.label.delegatedByMe" var="labelSharedByMe" />
	<fmt:message key="share.label.delegateName" var="labelShareName"/>
	<fmt:message key='sharing.label.path' var="pathText"/>
	<fmt:message key="sharing.label.labelSource" var='labelSource' />
	<fmt:message key="share.label.shareType" var="labelShareType" />
	<fmt:message key="share.label.deleteDelegateLabel" var="deleteAction"/>
	<fmt:message key="sharing.label.ConfigureAction" var="configAction"/>
	<fmt:message key="sharing.lebel.confirmDeleteDelegateText" var="confirmDeleteText" />
	<fmt:message key="sharing.label.confirmDeleteTitle" var="confirmDeleteTitle" />
	<fmt:message key="sharing.label.savedFolderDeletedText" var="savedFolderDeletedText" />
	<fmt:message key="backupBrowse.tableColumn.folder" var="labelFolder" />
	<fmt:message key="exchangeMailboxBrowse.label.mailBox" var="labelMailbox" />
	<fmt:message key="share.label.delegateTitle" var="shareTitle" />

	<fmt:message key="share.label.exchangeDelegateLabel" var="exchangeDelegateLabel" />
</fmt:bundle>

<div id="laptopList" class="mailList vw-summary-emails-list"></div>
<div id="laptopList" class="delMailList vw-summary-deleEmails-list"></div>
<div id="laptopList" class="sharedMailList vw-exchange-shared-by-me-list"></div>

<script type="text/template" id="mailTemplate">
<span class="sectiontitle vw-page-title">${email}</span>
{{#EnableQuotaManagementQuota_Limit}}
<div class="vw-disk-usage-wrapper">
	<div id="quota-info-div" class="vw-disk-usage">
		<div class="quota-info-title vw-disk-usage_title">{{labelQuotaUsage}}</div>
		<div class="quota-info-data vw-disk-usage_data">
			<span class="subsec-quota">{{quotaInfo.Quota_Usage}}</span><div class="ql vw-status-bar"><div class="qu vw-status-bar_percentage"></div></div>
		</div>
	</div>
</div>
		{{/EnableQuotaManagementQuota_Limit}}
{{#MAIL_BK_LISTNotZero}}
	<div class="sub-section">
		<div class="subsec-body clientJobs vw-data-table">
			<ul class="secrowhead secrows vw-data-row vw-heading-row clearfix">
				<li class="li1 vw-row_name" data-title="{{labelDisplayName}}">
			<enhance:out escapeXml="false">{{labelDisplayName}}</enhance:out></li>
				<li class="li2 vw-row_protected text-center" data-title="{{labelProtected}}">{{labelProtected}}</li>
				<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{labelLastBackup}}</li>
				<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{labelNextBackup}}</li>
			</ul>
			<div class="browseDataRows vw-data-table_content">
				{{#MAIL_BK_LIST}}
					<ul class="secrows vw-data-row clearfix">
						<li class="li1 vw-row_name" data-title="{{labelDisplayName}}" data-Id="{{applicationId}}">
						{{#mailCapableUser}}
							{{#mbParentGuid}}
								<a href="{{curContext}}/browse/exchangeBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}&path={{uriComponentEncodedPath}}&backupsetId={{backupsetId}}&subclientId={{subclientId}}&mailBoxName={{uriComponentEncodedDisplayName}}&mbParentGuid={{mbParentGuid}}">
									{{annotatedDisplayName}}
					    		</a>
							{{/mbParentGuid}}
							{{^mbParentGuid}}
					    		<a href="{{curContext}}/browse/exchangeBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}&path={{uriComponentEncodedPath}}&backupsetId={{backupsetId}}&subclientId={{subclientId}}&mailBoxName={{uriComponentEncodedDisplayName}}">
									{{annotatedDisplayName}}
					    		</a>
							{{/mbParentGuid}}
						{{/mailCapableUser}}
						{{^mailCapableUser}}
				             	{{annotatedDisplayName}}
						{{/mailCapableUser}}
				        </li>
							<li class="li2 vw-row_protected" data-title="{{labelProtected}}"><div class="centerpad text-center"><span class="sprite icon-dot-{{protectedImg}}" alt="{{protectedStatusTitle}}" title="{{{protectedStatusDesc}}}" role="img"></span></div></li>
							<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{lastBackup}}</li>
							<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{nextBackup}}</li>
						</ul>
				{{/MAIL_BK_LIST}}
					{{#MAIL_BK_LISTThree}}
						<ul class="secrows lastrow vw-data-row clearfix">
						</ul>
					{{/MAIL_BK_LISTThree}}
				</div>
			</div>
		</div>
{{/MAIL_BK_LISTNotZero}}
</script>

<script type="text/template" id="delegatedMailTemplate">
{{#DEL_MAIL_BK_LISTNotZero}}
	<div class="sub-section">
		<ul class="subsec-head">
			<li class="subsec-title">{{labelMyDelegatedMails}}</li>
		</ul>
		<div class="subsec-body clientJobs vw-data-table">
			<ul class="secrowhead secrows vw-data-row vw-heading-row clearfix">
				<li class="li1 vw-row_name" data-title="{{labelDisplayName}}">{{labelDisplayName}}</li>
				<li class="li2 vw-row_protected text-center" data-title="{{labelProtected}}">{{labelProtected}}</li>
				<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{labelLastBackup}}</li>
				<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{labelNextBackup}}</li>

			</ul>
			<div class="browseDataRows vw-data-table_content">
				{{#DEL_MAIL_BK_LIST}}
					<ul class="secrows vw-data-row clearfix">
						<li class="li1 vw-row_name" data-title="{{labelDisplayName}}" data-Id="{{applicationId}}">
						{{#delMailCapableUser}}
							{{#mbParentGuid}}
								<a href="{{curContext}}/browse/exchangeBrowse.do?clientId={{clientId}}&path={{uriComponentEncodedPath}}&df={{uriComponentEncodedFolder}}&backupsetId={{backupsetId}}&subclientId={{subclientId}}&mailBoxName={{uriComponentEncodedDisplayName}}&mbParentGuid={{mbParentGuid}}">
								{{annotatedDisplayName}}
					    		</a>
							{{/mbParentGuid}}
							{{^mbParentGuid}}
								<a href="{{curContext}}/browse/exchangeBrowse.do?clientId={{clientId}}&path={{uriComponentEncodedPath}}&df={{uriComponentEncodedFolder}}&backupsetId={{backupsetId}}&subclientId={{subclientId}}&mailBoxName={{uriComponentEncodedDisplayName}}">
								{{annotatedDisplayName}}
					    		</a>
							{{/mbParentGuid}}
							{{#exchangeDelegate}}
								<span class="sprite logo-share-exchange pull-right" alt="{{exchangeShareLabel}}" title="{{exchangeShareLabel}}" role="img"></span>
							{{/exchangeDelegate}}
						{{/delMailCapableUser}}
						{{^delMailCapableUser}}
				             	{{annotatedDisplayName}}
						{{/delMailCapableUser}}
				        </li>
						<li class="li2 vw-row_protected" data-title="{{labelProtected}}"><div class="centerpad text-center"><span class="sprite icon-dot-{{protectedImg}}" alt="{{protectedStatusTitle}}" title="{{{protectedStatusDesc}}}" role="img"></span></div></li>
						<li class="li3 vw-row_last-backup" data-title="{{labelLastBackup}}">{{lastBackup}}</li>
						<li class="li4 vw-row_next-backup" data-title="{{labelNextBackup}}">{{nextBackup}}</li>
					</ul>
				{{/DEL_MAIL_BK_LIST}}
					{{#DEL_MAIL_BK_LISTThree}}
						<ul class="secrows lastrow vw-data-row clearfix">
						</ul>
					{{/DEL_MAIL_BK_LISTThree}}
				</div>
			</div>
		</div>
{{/DEL_MAIL_BK_LISTNotZero}}
</script>

<script type="text/template" id="sharedMailTemplate">
{{#SHARED_BK_LISTNotZero}}
	<div class="sub-section">
		<ul class="subsec-head">
			<li class="subsec-title">{{labelSharedByMe}}</li>
		</ul>
		<div class="subsec-body clientJobs vw-data-table">
			<ul class="secrowhead secrows vw-data-row vw-heading-row clearfix">
				<li class="li1 vw-row_name" data-title="{{labelShareName}}">{{labelShareName}}</li>
				<li class="li2 vw-row_source" data-title="{{labelSource}}">{{labelSource}}</li>
				<li class="li3 vw-row_path" data-title="{{labelPath}}">{{labelPath}}</li>
				<li class="li4 vw-row_date-created" data-title="{{labelDateCreated}}">{{labelDateCreated}}</li>
			</ul>
			<div class="browseDataRows vw-data-table_content">
				{{#SHARED_BK_LIST}}
					<ul class="secrows vw-data-row clearfix">
						<li class="li1 vw-row_name" data-title="{{labelShareName}}">{{displayName}}</li>
						<li class="li2 vw-row_source" data-title="{{labelSource}}">{{source}}</li>
						<li class="li3 vw-row_path" data-title="{{labelPath}}">{{path}}</li>
						<li class="li4 vw-row_date-created" data-title="{{labelDateCreated}}">{{dateCreated}}</li>
						<li class="li5 vw-row_actions vw-visible-on-hover centerpad text-center" data-clientid="{{clientId}}" data-isedgeclient="false" data-id="{{shareFolderId}}">
							<span class="somelink configureAction shareActions vw-share-action" title="{{labelConfigAction}}">
								<span class="sprite icon-configure_share vw-sprite_action"/>
							</span>
							<span class="somelink deleteAction shareActions vw-share-action" title="{{labelDeleteAction}}">
								<span class="sprite icon-delete_share vw-sprite_action"/>
							</span>
						</li>
					</ul>

				{{/SHARED_BK_LIST}}
					{{#SHARED_BK_LISTThree}}
						<ul class="secrows lastrow vw-data-row clearfix">
						</ul>
					{{/SHARED_BK_LISTThree}}
			</div>
		</div>
{{/SHARED_BK_LISTNotZero}}
</script>

<script nonce="${sessionScope.cspNonce}" >
var EnableQuotaManagement = "${applicationScope.EnableQuotaManagement}";

var localMsg = localMsg || {};
localMsg.ProtectedTitle = "${ProtectedTitle}";
localMsg.SemiProtectedTitle = "${SemiProtectedTitle}";
localMsg.NotProtectedTitle = "${NotProtectedTitle}";
localMsg.ProtectedDesc = "${ProtectedDesc}";
localMsg.SemiProtectedDesc = "${SemiProtectedDesc}";
localMsg.NotProtectedDesc = "${NotProtectedDesc}";
<enhance:out escapeXml="false">
	localMsg.labelDisplayName = "${labelDisplayName}";
</enhance:out>
localMsg.labelClients = "${labelClients}";
localMsg.labelLastBackup = "${labelLastBackup}";
localMsg.labelNextBackup = "${labelNextBackup}";
localMsg.labelMyDelegatedMails = "${labelMyDelegatedMails}";
localMsg.labelQuotaUsage = "${labelQuotaUsage}";
localMsg.dateNotAvailable = "${dateNotAvailable}";
localMsg.notScheduled = "${notScheduled}";
localMsg.labelSharedByMe="${labelSharedByMe}"
localMsg.labelSharedWith="${labelSharedWith}"
localMsg.labelDateCreated="${labelDateCreated}"
localMsg.labelShareType="${labelShareType}"
localMsg.labelSource = "${labelSource}";
localMsg.labelPathText = "${pathText}";

localMsg.labelShareName="${labelShareName}";
localMsg.labelFolder="${labelFolder}";
localMsg.labelMailbox="${labelMailbox}";

localMsg.somethingWentWrong = "${somethingWentWrongText}";
localMsg.confirmLeaveText = "${confirmLeaveText}";
localMsg.confirmLeaveTitle = "${confirmLeaveTitle}";
localMsg.confirmDeleteText = "${confirmDeleteText}";
localMsg.confirmDeleteTitle = "${confirmDeleteTitle}";
localMsg.configAction = "${configAction}";
localMsg.deleteAction = "${deleteAction}";
localMsg.shareTitle = "${shareTitle}";
localMsg.confirmDeleteTextLink= "${confirmDeleteTextLink}";
localMsg.exchangeDelegateLabel = "${exchangeDelegateLabel}";

var configureShare = "${ConfigureShareAction}";
var savedFolderDeletedText = "${savedFolderDeletedText}";
</script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummaryMail.js?${applicationScope.BUILD_TS}"></script>
