<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<fmt:bundle basename="localization.messages">
	<fmt:message key="label.settings" var="labelShowDetails"/>
	<fmt:message key="Protected.title" var="ProtectedTitle" />
	<fmt:message key="SemiProtected.title" var="SemiProtectedTitle" />
	<fmt:message key="NotProtected.title" var="NotProtectedTitle" />
	<fmt:message key="Protected.desc" var="ProtectedDesc" />
	<fmt:message key="SemiProtected.desc" var="SemiProtectedDesc" />
	<fmt:message key="NotProtected.desc" var="NotProtectedDesc" />
	<fmt:message key="summary.link.computers" var="computers" />
	<fmt:message key="date.NotAvailable" var="dateNotAvailable" />
	<fmt:message key="not.scheduled" var="notScheduled" />
</fmt:bundle>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.clients" var="labelClients" />
	<fmt:message key="summary.label.protected" var="labelProtected" />
	<fmt:message key="summary.label.lastBackup" var="labelLastBackup" />
	<fmt:message key="summary.label.nextBackup" var="labelNextBackup" />
	<fmt:message key="summary.label.size" var="labelSize" />
	<fmt:message key="summary.label.actions" var="labelActions" />
	<fmt:message key="no.computers.backedup" var="labelBackedup" />
	<fmt:message key="summary.tour.welcome" var="myDataTourWelcome" />
	<fmt:message key="summary.tour.addComputer" var="myDataTourAdd" />
	<fmt:message key="summary.tour.browseComputer" var="myDataTourBrowse" />
	<fmt:message key="summary.tour.details" var="myDataTourDetails" />
	<fmt:message key="summary.tour.drive" var="myDataTourDrive" />
	<fmt:message key="summary.tour.goBack" var="myDataTourGoBack" />
	<fmt:message key="summary.disabled.title" var="disabledTitle" />
	<fmt:message key="summary.label.restore" var="labelRestore" />
	<fmt:message key="enableBackups.label" var="enableBackupsLabel" />
	<fmt:message key="deleteBackups.label" var="deleteBackupsLabel" />
	<fmt:message key="deleteBackups.warning" var="deleteBackupsWarning" />
	<fmt:message key="deleteBackups.sucess" var="deleteClientSuccess" />
	<fmt:message key="clientlock.dialog.subtitle" var="clientlockDialogSubTitle"/>
	<fmt:message key="summary.ariaLabel.windows" var="windows" />
	<fmt:message key="summary.ariaLabel.mac" var="mac" />
	<fmt:message key="summary.ariaLabel.linux" var="linux" />
</fmt:bundle>
<div id="fsSummaryMainSection"></div>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.isIDPDisabled = "${(applicationScope.isIDPSSOEnabled == null || applicationScope.isIDPSSOEnabled == false)}"
	localMsg.ProtectedTitle = "${ProtectedTitle}";
	localMsg.SemiProtectedTitle = "${SemiProtectedTitle}";
	localMsg.NotProtectedTitle = "${NotProtectedTitle}";
	localMsg.ProtectedDesc = "${ProtectedDesc}";
	localMsg.SemiProtectedDesc = "${SemiProtectedDesc}";
	localMsg.NotProtectedDesc = "${NotProtectedDesc}";
	localMsg.labelClients = "${labelClients}";
	localMsg.labelProtected = "${labelProtected}";
	localMsg.labelLastBackup = "${labelLastBackup}";
	localMsg.labelNextBackup = "${labelNextBackup}";
	localMsg.labelSize = "${labelSize}";
	localMsg.labelActions = "${labelActions}";
	localMsg.labelShowDetails = "${labelShowDetails}";
	localMsg.labelBackedup = "${labelBackedup}";
	localMsg.labelRestore = "${labelRestore}";
	localMsg.disabledTitle = "${disabledTitle}";
	localMsg.windows = "${windows}";
	localMsg.mac = "${mac}";
	localMsg.linux = "${linux};"

	//tour Messages
	localMsg.tourWelcome = "${myDataTourWelcome}";
	localMsg.tourAddComputer = "${myDataTourAdd}";
	localMsg.tourBrowseComputer = "${myDataTourBrowse}";
	localMsg.tourComputerDetails = "${myDataTourDetails}";
	localMsg.tourDrive = "${myDataTourDrive}";
	localMsg.tourGoBack = "${myDataTourGoBack}";
	localMsg.dateNotAvailable = "${dateNotAvailable}";
	localMsg.notScheduled = "${notScheduled}";
	localMsg.enableBackupsLabel = "${enableBackupsLabel}";
	localMsg.deleteBackupsLabel = "${deleteBackupsLabel}";
	var enableMultiCommCell = "${requestScope.enableMultiCommCell}" === "true" || "${fn:escapeXml(param.enableMultiCommCell)}" === "true";
	localMsg.deleteWarning = "${deleteBackupsWarning}";
	localMsg.deleteClientSuccess="${deleteClientSuccess}";
	localMsg.clientlockDialogSubTitle = "${clientlockDialogSubTitle}";
</script>
<script id="fsSummaryMainSectionTemplate" type="x-tmpl-mustache">
<span class="sectiontitle vw-page-title">${computers}</span>
{{#hasComputers}}
<div class="subsec-body clientJobs">
	<div id="computerList" class="browseDataRows">
	{{#computers}}
		{{^isEdgeDrive}}
			<div class="row vw-comp-tile">
				<div class="col-md-2 col-centered">

					<div class='vw-{{osIconClass}}' {{#deconfigured}}title="{{disabledTitle}}"{{/deconfigured}}>
						<svg xmlns="http://www.w3.org/2000/svg" width="65" height="70" viewBox="0 0 25.1 29.2" class="vw-svg-os" role="img" alt="{{osIconLabel}}" focusable="false"><defs><style>.vw-sprite {fill: none;}</style></defs><path aria-hidden="true" role="presentation" class="vw-sprite vw-sprite-apple" d="M24.5,21a20.4,20.4,0,0,1-1.8,3.4c-1.2,1.8-2.9,4.1-5.1,4.1s-2.3-1.2-4.9-1.2-3,1.2-5,1.2-3.7-2.1-5-3.9C-0.4,19.4-.8,13.3,1.3,10.2a7.5,7.5,0,0,1,6-3.6c2.2,0,3.6,1.2,5.5,1.2s2.9-1.2,5.5-1.2a7.3,7.3,0,0,1,5.6,3A6.3,6.3,0,0,0,24.5,21ZM16.4,4.6H16.3A6.3,6.3,0,0,0,17.7,0a6.8,6.8,0,0,0-4.3,2.3,5.9,5.9,0,0,0-1.4,4.5A5.8,5.8,0,0,0,16.4,4.6Z"/><path aria-hidden="true" role="presentation" class="vw-sprite vw-sprite-windows" d="M0.3,6.8L10.4,5.4v9.7H0.3V6.8Zm10.1,9.5v9.8L0.3,24.7V16.2H10.4Zm1.2-11L25.1,3.3V15H11.7V5.2H11.6ZM25.1,16.4V28.1L11.7,26.2V16.4H25.1Z"/><path aria-hidden="true" role="presentation" class="vw-sprite vw-sprite-linux" d="M2.1,25.7a4.9,4.9,0,0,0,0-1.2,1.2,1.2,0,0,1,1.1-1.7A2,2,0,0,0,5,20.5h0A1.2,1.2,0,0,1,5,19.7c1.3-2.1,1.7-4.9,3.5-6.7a3,3,0,0,0,.8-2.7,28,28,0,0,1-.2-3.6c0-1.9.7-3,2.4-3.4a4.1,4.1,0,0,1,4.6,1.6,4.3,4.3,0,0,1,.8,2.5,10.5,10.5,0,0,0,2.6,7,9.9,9.9,0,0,1,2.1,6.9,3.4,3.4,0,0,0,1.6,3.2c1,0.6.9,1.2-.1,1.7a18.7,18.7,0,0,0-3.6,2.4c-1,.9-2.1.7-3.1-0.3l-0.5-.5c-2.1-.1-4.3-0.8-6.3.7a2,2,0,0,1-2.2.3,18.7,18.7,0,0,0-3.9-1.2C2.4,27.3,1.4,27,2.1,25.7ZM10.2,11c-0.2.8,0,1.3-.4,1.8a45.1,45.1,0,0,0-2.3,5.4C6.8,20,7,20.8,8.7,22.1l1.4,1.2a0.8,0.8,0,0,1,.3,1.1H10.3c-0.6.9-.5,1.4,0.6,1.6A5.7,5.7,0,0,0,16,24.9a2.1,2.1,0,0,0,.9-1.8c0-.8-0.4-1.8.9-2a1,1,0,0,0,.2-0.7,7.7,7.7,0,0,0-.5-3.9c-0.8-1.5-1.3-3.2-2-4.9s-0.7-.7-1.2-0.3-2.7,1.6-4.1-.2h0.1Zm2.9-2.4c0.2-.5.4-1.2,1.1-1s0.6,0.7.2,1.2-0.2.4,0.1,0.5a0.4,0.4,0,0,0,.5-0.2,1.8,1.8,0,0,0-.2-2.2,0.9,0.9,0,0,0-1.2-.3H13.4a1.3,1.3,0,0,0-.6,1.8L13,8.7h0.1Zm-2.9.2c0.3-.4-0.1-1.1.5-1.2s0.3,0.8.9,1a1.6,1.6,0,0,0-.4-1.8,0.6,0.6,0,0,0-.9-0.1H10.3a1.6,1.6,0,0,0-.2,2.1h0.1Z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" width="135" height="135" viewBox="0 0 135 135" class="vw-svg-circle" role="presentation" aria-hidden="true" focusable="false"><path role="presentation" aria-hidden="true" d="M67.5,135A67.5,67.5,0,1,1,135,67.5,67.5,67.5,0,0,1,67.5,135Zm0-133.1A65.5,65.5,0,1,0,133,67.4h0A65.6,65.6,0,0,0,67.5,1.9Z"/></svg>
					</div>
				</div>
				<div class="col-md-10">
					<div class="row">
						<div class="col-md-12">

							<h4 class="vw-comp-name">
								<span class="sprite icon-dot-{{protectedImg}}" alt="{{protectedStatusTitle}}" title="{{{protectedStatusDesc}}}" role="img"></span>
								{{#clientActiveBackedCapable}}
									<a href="{{curContext}}/browse/fsBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}">
								{{/clientActiveBackedCapable}}
								{{clientName}}
								{{#clientActiveBackedCapable}}
									</a>
								{{/clientActiveBackedCapable}}
							</h4>
						</div>
						
						<div class="col-md-4">
							<span class="vw-comp-label">${labelLastBackup}</span><br>
							{{lastBackup}}
						</div>
						
						<div class="col-md-4">
							<span class="vw-comp-label">${labelNextBackup}</span><br>
							{{nextBackup}}
						</div>
						<div class="col-md-4">
							<span class="vw-comp-label">${labelSize}</span><br>
							{{totalSize}}
						</div>
						<div class="col-md-12">
							<br>
							{{#clientActiveBackedCapable}}
							<a href="{{curContext}}/browse/fsBrowse.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}" class="vw-btn vw-btn-primary" role="button">${labelRestore}</a>
							{{/clientActiveBackedCapable}}
							{{#clientActiveNotNASNotEdge}}
									{{^isClientDeconfigured}}
										<a href="{{curContext}}/clientDetails/fsDetails.do?clientName={{uriComponentEncodedClientName}}&clientId={{clientId}}" class="vw-spacing vw-btn vw-btn-default" role="button">{{labelShowDetails}}</a>
									{{/isClientDeconfigured}}
							{{/clientActiveNotNASNotEdge}}
							{{#isIDPDisabled}}
								{{#isManageApplication}}
									{{#isClientDeconfigured}}
										<a class="vw-spacing enableBackups mainBtn vw-btn vw-btn-primary" data-clientid="{{clientId}}" role="button" tabindex="0">
											<svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin" role="progressbar" focusable="false"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg>
											<span class="vw-btn-text">${enableBackupsLabel}</span>
										</a>

									{{#isMessageEnabled}}
											<span class="vw-comp-settings">
												<a class="deleteBackups mainBtn vw-btn vw-btn-primary" data-clientid="{{clientId}}" data-clientname="{{clientName}}" role="button" tabindex="0">
													${deleteBackupsLabel}
												</a>
											</span>
										{{/isMessageEnabled}}
									{{/isClientDeconfigured}}
								{{/isManageApplication}}
							{{/isIDPDisabled}}
						</div>

					</div>
				</div>
			</div>
		{{/isEdgeDrive}}
	{{/computers}}
	</div>
</div>
{{/hasComputers}}
{{^hasComputers}}
<div class="noComputerSpan">
	<p class="noComputers">{{labelBackedup}}</p>
</div>
{{/hasComputers}}
</script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/encoder.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/clientConfig.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummaryFsTable.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" >
$(function() {
	$("#runBackupLink").click(function(evt){
		if(lastKilled!=null)
			window.clearTimeout(lastKilled);

		if($(".currBackup").html().replace(/^\s+/, '').replace(/\s+$/, '') == ""){
			var currData = {
				clientId : clientId,
				clientName : clientName,
				apptype : apptype
			};
			cvUtil.loadPage('currentBackup.jsp', currData, function(data) {
				$(".currBackup").html(data);
				$(".actionsBackup label").hide();
				setManageOperationsControls();
			    runBackup();
			});
		}
		else
			runBackup();

		evt.preventDefault();

	});


	function runBackup(){

		$(".currBackup, #progBackup, #wait, #failedToStart, #backupJobClose, .actionsBackup label").hide().addClass("hidden");
		$(".currBackup, #wait").show().removeClass("hidden");
		toggleDisabled("#runBackupLink","disable");
		toggleDisabled(".backupActions","enable");
		loadCurrBkJobId(true);
	}
});
</script>
