<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<%-- Angular directives within Mustache templates are ignored, hence they need to be place directly into the page. --%>
<%-- It is also not possible to place text containing string '</script>' into Moustache templates. --%>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.add.new.computer" var="labelAddNewComputer" />
	<fmt:message key="summary.label.diskUsage" var="labelDiskUsage" />
</fmt:bundle>

<c:if test="${applicationScope.EnableFSQuotaManagement}">
		<div id="fsSummaryTopSection" class="vw-disk-usage-wrapper vw-start-hidden">
			<div id="quota-info-div" class="vw-disk-usage">
				<div class="quota-info-title vw-disk-usage_title">${labelDiskUsage}</div>
				<div class="quota-info-data vw-disk-usage_data">
					<span class="subsec-quota"></span>
					<div id="totalFsQuota" class="vw-status-bar"><div id="usedFsQuota" class="vw-status-bar_percentage"></div></div>
				</div>
			</div>
		</div>
	</c:if>
<div id="laptopList" class="vw-summary-computers-list">
	<c:choose>
		<c:when test="${requestScope.enableMultiCommCell || param.enableMultiCommCell}">
			<jsp:include page="/reportsplus/reportInclude.jsp">
				<jsp:param name="reportName" value="My Data" />
				<jsp:param name="includeBootstrapCss" value="false" />
			</jsp:include>
		</c:when>
		<c:otherwise>
			<jsp:include page="displaySummaryFsTable.jsp" />
		</c:otherwise>
	</c:choose>
</div>

<c:if test="${applicationScope.WebconsoleShowAddNewComputerLink == 'true'}" >
	<div class="AddNewItem hidden">
		<a class="addComputers addNewItemA vw-btn vw-btn-secondary" href="addComputer.do">
			<span class="addWF"><span class="sprite icon-plus" role="presentation" aria-hidden="true"></span>&nbsp;${labelAddNewComputer}</span>
		</a>
	</div>
</c:if>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/displaySummaryFs.js?${applicationScope.BUILD_TS}"></script>
<%-- End of page. Template definitions begin. --%>
