<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<jsp:include page="../common/headerV2.jsp">
	<jsp:param value="true" name="includeHistory" />
	<jsp:param value="My_Backups" name="title" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="fullscreen" />
	<jsp:param value="true" name="myDataTitle" />
	<jsp:param value="true" name="includeJqueryUI" />
	<jsp:param value="../common/css/custom-cb.css" name="css" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="myDataNav.jsp" name="navPage" />
	<jsp:param value="../common/css/custom-cb.css" name="css" />
	<jsp:param value="false" name="includeSecHeader" />
	<jsp:param value="My_Backups" name="headerTitle" />
 	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js" />
	<jsp:param value="true" name="intro" />
	<jsp:param value="../common/js/moment.js" name="js" />
</jsp:include>
<fmt:message key="summary.link.drive" var="driveTitle" />
<fmt:message key="summary.link.goToDrive" var="goToDrive" />
<script nonce="${sessionScope.cspNonce}" >
	var loadedEvents = false;
</script>
<div class="row">
	<c:if test="${showDrive}">
		<div class="col-sm-12">
			<a class="mainBtn driveBtn vw-btn vw-btn-primary vw-btn-drive" href="${pageContext.servletContext.contextPath}/mydrive">${goToDrive}</a>
		</div>
	</c:if>

	<div id="holder" class="vw-loading-area col-sm-12">
		<c:choose>
		<c:when test="${requestScope.PAGE != ''}">
			<c:forEach var="dispPage" items="${DISPLAY_PAGES}">
				<jsp:include page="${dispPage}" />
			</c:forEach>
		</c:when>
		<c:otherwise>
			<div id="noSummaryPageSelected"></div>
		</c:otherwise>
		</c:choose>
	</div>

	<div class="hidden noClients col-sm-12">
		<fmt:message key="no.computers.backedup" />
	</div>
</div>
<script nonce="${sessionScope.cspNonce}" >

function manageClientList(el){
	if($.trim(el.val()) == ""){
		$(".clientSearch").hide();
		return;
	}
	if ($(".clientsForSearch").children("li").length == 0) { // check for li children here
		$("#FSList .li1 a").each(function(){
			var a = $(this);
			if (!a.parents("ul").hasClass("webFolders")) {
				var href = a.parents("ul").find(".li6 a").attr("href");
				if(typeof href != "undefined"){
					var searchUrl =  href + "&keyword=";
					var ele = $("<li data-searchurl='"+searchUrl+"'>"+a.text() +" </li>");
					ele.appendTo($(".clientsForSearch"));
				}
			}

		});

		$(".clientsForSearch li:first-child").addClass("selectedClient");
	}
	if($(".clientSearch").is(':hidden')){
		$(".clientSearch").show();
	}

	$("#grpSearch").on("search", function(){
		if($(this).val() == ""){
			$(".clientSearch").hide();
		}
	});
	$(".clientsForSearch li").on("click",function(){
		$(".clientsForSearch li").removeClass("selectedClient");
		$(this).addClass("selectedClient");
		var url = $(".clientsForSearch .selectedClient").data("searchurl") + encodeURIComponent($("#grpSearch").val());
		window.location = url;
	});
}

$("#grpSearch").keyup(function(){
	manageClientList($(this));
});

$("#grpSearch").focus(function(){
	manageClientList($(this));
});


$("#grpSearch").keyup(function(event){
	if(event.keyCode == 13){
		if($.trim($(this).val()) == ""){
			$(".clientSearch").hide();
			return;
		}
		var url = $(".clientsForSearch .selectedClient").data("searchurl") + encodeURIComponent($("#grpSearch").val());
		window.location = url;
	}
});

$("#closeSearch").on("click", function() {
	$(".clientsForSearch").hide();
	$("#closeSearch").hide();
});

var param = "${fn:escapeXml(requestScope.PAGE)}";
if(param == ''){
	param = 'fs';
}
$.each($(".pageTabs").find("li"), function(){
	var id = $(this).attr("id");
	if (id==param){
		$(this).addClass('vw-tab-selected');
	}
});
</script>

<jsp:include page="notifications.jsp" />
<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/js/jquery.corner.js" name="js" />
	<jsp:param value="js/summarySyncFolders.js" name="js" />
	<jsp:param value="true" name="intro" />
</jsp:include>
<!--  Removing these lines, as now a client not found exception is being forwarded to 500.jsp
What happens is that after that, when a user comes to this page the first time, it throws the same error again.
<c:if test="${not empty sessionScope.LOCALIZED_ERROR_MSG}">
	<script nonce="${sessionScope.cspNonce}" >
		cvUtil.errorToast("${sessionScope.LOCALIZED_ERROR_MSG}", null, null, true);
	</script>
	<c:set var="LOCALIZED_ERROR_MSG" value="" scope="session" />
</c:if>
 -->