<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp"%>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.myComputers" var="myBackups" />
	<fmt:message key="summary.add.new.computer" var="addComputer" />
</fmt:bundle>
<jsp:include page="../common/headerV2.jsp">
	<jsp:param value="My_Backups" name="title" />
	<jsp:param value="../common/css/templatestyles.css" name="css" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="css/summarystyles.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="${myBackups}:summary/index.do?page=fs" name="breadCrumbValues" />
	<jsp:param value="${addComputer}" name="headerTitleLocalized" />
</jsp:include>

<style>
	#audioInstructionsLink img{
		height: 16px;
		width: 16px;
	}

	.vidInstructions{
		display: none;
		width: 400px;
		text-align:center;
	}

	.step {
		position: relative;
		padding: 10px 25px 25px 10px;
	}

	.csName {
		font-weight: bold;
	}

	.stepNo {
		position: absolute;
		left: 10px;
		top: 10px;
		font-size: 1.55em;
		padding: 7px 6px 8px 16px;
		background: #E6E7E8;
		-moz-border-radius: 1000px;
		-webkit-border-radius: 1000px;
		border-radius: 1000px;
		margin-left: -10px;
		line-height: 0.9em;
	}

	.stepContent{
		padding-left: 30px;
	}

	.step ol {
		list-style-type: none;
		padding: 0px;
		margin: 0px;
	}
	.step ol li {
		background-image: url(sqpurple.gif);
		background-repeat: no-repeat;
		background-position: 0px 5px;
		padding-left: 14px;
		list-style-type: decimal;
	}

	h2{
		font-size: 1.5em;
		font-weight: lighter;
		color: #555;
		padding-bottom: 5px;
	}
	p{
		padding-bottom: 5px;
	}

	.win32, .win64{
		background: url('img/windows_client.png') no-repeat;
		padding-left: 20px;
	}

	.mac{
		background: url('img/Mac_16.png') no-repeat;
		padding-left: 20px;
	}

	#content .sechead {
		padding-top: 0px;
		padding-bottom: 0px;
	}
</style>

<enhance:out escapeXml="false">

	<div class="step">
		<span class="stepNo">1</span>
		<div class="stepContent">
			<h2><fmt:message key="registration.step1.header" /></h2>
			<p>${requestScope.packageinfo1.downloadText}</p>
			<c:if test="${requestScope.packageinfo2 != null}">
				<p>${requestScope.packageinfo2.downloadText}</p>
				<p>${requestScope.packageinfo3.downloadText}</p>
			</c:if>
		</div>
	</div>

	<div class="step">
		<span class="stepNo">2</span>
		<div class="stepContent">
			<h2><fmt:message key="registration.step2.header" /></h2>
			<p>${requestScope.instructions}</p>
		</div>
	</div>

	<div class="step">
		<span class="stepNo">3</span>
		<div class="stepContent">
			<h2><fmt:message key="registration.step3.header" /></h2>
			<p>${requestScope.step3}</p>
		</div>
	</div>

</enhance:out>

<jsp:include page="../common/footer.jsp" />
