<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp"%>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="summary.label.myComputers" var="myBackups" />
	<fmt:message key="summary.add.new.computer" var="addComputer" />
</fmt:bundle>
<jsp:include page="../common/headerV2.jsp">
	<jsp:param value="My_Backups" name="title" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="${myBackups}:summary/index.do?page=fs" name="breadCrumbValues" />
	<jsp:param value="${addComputer}" name="headerTitleLocalized" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="myDataNav.jsp" name="navPage" />
	<jsp:param value="css/addComputer.css" name="css" />
</jsp:include>


<div class="col-sm-12">
	<c:choose>
		<c:when test="${requestScope.customHTML!=null}"><p><enhance:out escapeXml="false">${requestScope.customHTML}</enhance:out></p>
		</c:when>
		<c:otherwise> 
			<div class="vw-instruction-step">
		<span class="vw-step-number">1</span>
		<div class="vw-step-content">
			<h2><fmt:message key="registration.step1.header" /></h2>
			<p><enhance:out escapeXml="false">${requestScope.packageinfo.downloadText}</enhance:out></p>
		</div>
	</div>

	<div class="vw-instruction-step">
		<span class="vw-step-number">2</span>
		<div class="vw-step-content">
			<h2><fmt:message key="registration.step2.header" /></h2>
			<p>${requestScope.instructions}</p>
		</div>
	</div>

	<fmt:bundle basename="localization.ClientDetailsMessages">
	<div class="mac-label-holder hidden">
		<label class="wr title"><fmt:message key="addComputer.instructions.Please_enter_CommServe_name" /></label>
		<label class="wr step1"><fmt:message key="addComputer.instructions.CommServe_Host_Name" /></label>
		<label class="wr step2 acbtn"><fmt:message key="addComputer.instructions.Quit" /></label>
		<label class="wr step4 acbtn"><fmt:message key="addComputer.instructions.Continue" /></label>
		<label class="wr step3 acbtn"><fmt:message key="addComputer.instructions.Go_Back" /></label>
		<label class="wr number1"><fmt:message key="addComputer.instructions.Enter_Host_name" /></label>
		<label class="wr number2"><fmt:message key="addComputer.instructions.Click_Continue" /></label>
		<label class="wr title2 "><fmt:message key="addComputer.instructions.Edge_Monitor" /></label>
		<label class="wr title3"><fmt:message key="addComputer.instructions.Welcome_to_the_Edge_Monitor" /></label>
		<label class="wr step5"><fmt:message key="addComputer.instructions.Enter_your_credentials_to_register_your_laptop" /></label>
		<label class="wr step9 "></label>
		<label class="wr step6 "><fmt:message key="addComputer.instructions.Computer_Name" /></label>
		<label class="wr step7 "><fmt:message key="addComputer.instructions.User_Name_or_Email_Address" /></label>
		<label class="wr step8 "><fmt:message key="addComputer.instructions.Password" /></label>
		<label class="wr step10 acbtn"><fmt:message key="addComputer.instructions.Sign_In" /></label>
		<label class="wr step11 "><fmt:message key="addComputer.instructions.myMacMachine" /></label>
		<label class="wr step12 "><fmt:message key="addComputer.instructions.user_company.com" /></label>
		<label class="wr number3 "><fmt:message key="addComputer.instructions.Enter_Computer_Name" /></label>
		<label class="wr number4 "><fmt:message key="addComputer.instructions.Enter_User_name_or_Email_address" /></label>
		<label class="wr number5 "><fmt:message key="addComputer.instructions.Enter_Password" /></label>
		<label class="wr number6 "><fmt:message key="addComputer.instructions.Click_on_Sign_In" /></label>
	</div>
	
	<div class="win-label-holder hidden">
		<label class="wr dialog-title2"><fmt:message key="addComputer.instructions.CommServe_Information" /></label>
		<label class="wr step1"><fmt:message key="addComputer.instructions.CommServe_Host_Name" /></label>
		<label class="wr step2"><fmt:message key="addComputer.instructions.computerName" /></label>
		<label class="wr title3"><fmt:message key="addComputer.instructions.User_Laptop_Registration" /></label>
		<label class="wr step3"><fmt:message key="addComputer.instructions.credentials" /></label>
		<label class="wr number1"><fmt:message key="addComputer.instructions.Enter_Host_name" /></label>
		<label class="wr number2"><fmt:message key="addComputer.instructions.Click_the_arrow" /></label>
		<label class="wr step4 "><fmt:message key="addComputer.instructions.Computer_Name" /></label>
		<label class="wr step5 "><fmt:message key="addComputer.instructions.User_Name_or_Email_Address" /></label>
		<label class="wr step6 "><fmt:message key="addComputer.instructions.Password" /></label>
		<label class="wr step7 acbtn"><fmt:message key="addComputer.instructions.Activate" /></label>
		<label class="wr step8 acbtn"><fmt:message key="addComputer.instructions.Cancel" /></label>
		<label class="wr step9 "><fmt:message key="addComputer.instructions.myMachineName" /></label>
		<label class="wr step10 "><fmt:message key="addComputer.instructions.user_company.com" /></label>
		<label class="wr number4 "><fmt:message key="addComputer.instructions.Enter_Computer_Name" /></label>
		<label class="wr number3 "><fmt:message key="addComputer.instructions.Enter_User_name" /></label>
		<label class="wr number5 "><fmt:message key="addComputer.instructions.Enter_Password" /></label>
		<label class="wr number6 "><fmt:message key="addComputer.instructions.Click_Activate" /></label>
	</div>
	</fmt:bundle>
	
	<div id="diagram" class="diagram"></div>
	
	<div class="vw-instruction-step">
		<span class="vw-step-number">3</span>
		<div class="vw-step-content">
			<h2><fmt:message key="registration.step3.header" /></h2>
			<p><enhance:out escapeXml="false">${requestScope.step3}</enhance:out></p>
		</div>
	</div>
		</c:otherwise>
	</c:choose>
</div>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>
<script nonce="${sessionScope.cspNonce}" >
$(function () {
	var OSName="Unknown OS";
	if (navigator.appVersion.indexOf("Win")!=-1)
		OSName="Windows";
	else if (navigator.appVersion.indexOf("Mac")!=-1)
		OSName="MacOS";

	var imageCls = '';
	 /* OSName = "Windows";  */
	if (OSName === "Windows") {
		imageCls = "win-diagram";
		$(".vw-step-content span").before("<span class='sprite icon-client-windows' aria-hidden='true' role='presentation'></span>");
		$('#diagram').html($(".win-label-holder").html());
	}
	else if (OSName === "MacOS") {
		imageCls = "mac-diagram";
		$(".vw-step-content span").before("<span class='sprite logo-osx-small' aria-hidden='true' role='presentation'></span>");
		$('#diagram').html($(".mac-label-holder").html());
	}
	
	$('#diagram').addClass(imageCls);
});
</script>