<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<fmt:bundle basename="localization.SearchMessages">

<fmt:message key="all.keyword.language" var="language" />
<fmt:message key="fs.keyword.name" var="filename" />
<fmt:message key="fs.keyword.sizeInKb" var="size" />
<fmt:message key="fs.keyword.contains" var="contains" />
<fmt:message key="fs.keywords.go" var="go" />
<fmt:message key="fs.keyword.modTime" var="modTime"/>
<fmt:message key="fs.keyword.deletedTime" var="delTime"/>
<fmt:message key="fs.keyword.createdTime" var="createdTime"/>
<fmt:message key="fs.keyword.fileextension" var="extension"/>
<fmt:message key="exch.TimeRange" var="timeRange"/>
<fmt:message key="all.keyword.tag" var="tag" />
<fmt:message key="all.keyword.properties" var="properties" />

<fmt:message key="fromTime" var="fromTime"/>
<fmt:message key="toTime" var="toTime"/>

<fmt:message key="label.limitSearchToFolder" var="limitSearchToFolderLabel"/>

<script nonce="${sessionScope.cspNonce}" >
	var browseSearch = {};
	browseSearch.timeRangeDateSeparator = "${requestScope.DATE_SEPARATOR}";
	browseSearch.searchDateFormat = "${requestScope.SEARCH_DATE_FORMAT}";
	browseSearch.dateError = "${requestScope.SEARCH_DATE_FORMAT_ERROR}";
</script>

<div class="advSearchHolder fs vw-start-hidden">
	<div id="closeSearch"></div>

	<c:if test="${requestScope.browse.features.isLimitSearchToFolderOptionAvailable()}">
		<c:choose>
			<c:when test="${not empty param.path && not empty param.keyword}">
				<c:set var="searchLimitCheckStatus" value="checked" />
				<c:set var="searchLimitAriaCheckStatus" value="true" />
			</c:when>
			<c:otherwise>
				<c:set var="searchLimitCheckStatus" value="unchecked" />
				<c:set var="searchLimitAriaCheckStatus" value="false" />
			</c:otherwise>
		</c:choose>
		<div class="limit-search-wrapper limit-search-wrapper-js">
			<ul class="listStyleMargin">
				<li title="${limitSearchToFolderLabel}">
					<div class="custom-cb selectable ${searchLimitCheckStatus} vw-custom-checkbox" data-state="${searchLimitCheckStatus}" aria-checked="searchLimitAriaCheckStatus" id="folderLevelSearch" tabindex="0" role="checkbox" aria-labelledby="folderLevelSearch"></div>
					<label for="folderLevelSearch" class="custom-cb-label limit-search">${limitSearchToFolderLabel}</label>
				</li>
			</ul>
		</div>
		<hr class="limit-search-wrapper" noshade="true" >
	</c:if>

	<div class="field">
		<label for="filename">${filename}</label>
		<input type="text" value="" id="filename" data-key="${filename}"/>
	</div>

	<div class="field">
		<label for="extension">${extension}</label>
		<select id="extension" data-key="${extension}" class="fileextension">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.FILE_EXTENSIONS}" var="ext">
				<option value="${ext}">${ext}</option>
			</c:forEach>
		</select>
	</div>

	<div class="field">
		<label for="modTime">${modTime}</label>
		<select id="modTime" data-key="${modTime}" class="timeOptions">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.RECV_TIME_OPTIONS}" var="rt">
				<option value="${rt}">${rt}</option>
			</c:forEach>
			<option value="timeRange">${timeRange}</option>
		</select>
	</div>

	<div class="field vw-start-hidden timeRangeOptions">
		<label for="fromTime">${fromTime}</label>
		<input type="text" value="" id="fromTime" data-spl="true"  data-key="${fromTime}"/>

		<label for="toTime">${toTime}</label>
		<input type="text" value="" id="toTime" data-spl="true"  data-key="${toTime}"/>
	</div>


	<div class="field vw-start-hidden createdTime">
		<label for="modTime">${createdTime}</label>
		<select id="modTime" data-key="${createdTime}" class="createdtimeOptions">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.RECV_TIME_OPTIONS}" var="rt">
				<option value="${rt}">${rt}</option>
			</c:forEach>
			<option value="timeRange">${timeRange}</option>
		</select>
	</div>

	<div class="field vw-start-hidden createdTimeRangeOptions">
		<label for="fromTime">${fromTime}</label>
		<input type="text" value="" id="fromTimeCreated" data-spl="true"  data-key="${fromTime}"/>

		<label for="toTime">${toTime}</label>
		<input type="text" value="" id="toTimeCreated" data-spl="true"  data-key="${toTime}"/>
	</div>

	<div class="field vw-start-hidden deletedTime">
		<label for="modTime">${delTime}</label>
		<select id="modTime" data-key="${delTime}" class="deletedtimeOptions">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.RECV_TIME_OPTIONS}" var="rt">
				<option value="${rt}">${rt}</option>
			</c:forEach>
			<option value="timeRange">${timeRange}</option>
		</select>
	</div>

	<div class="field vw-start-hidden deletedTimeRangeOptions">
		<label for="fromTime">${fromTime}</label>
		<input type="text" value="" id="fromTimeDeleted" data-spl="true"  data-key="${fromTime}"/>

		<label for="toTime">${toTime}</label>
		<input type="text" value="" id="toTimeDeleted" data-spl="true"  data-key="${toTime}"/>
	</div>

	<c:if test="${requestScope.SEARCH_LANGUAGES != null}">
		<div class="field">
			<label for="language">${language}</label>
			<select id="language" data-key="${language}" class="searchlanguage">
				<option value="">&nbsp;</option>
				<c:forEach items="${requestScope.SEARCH_LANGUAGES}" var="lang">
					<option value="${lang}">${lang}</option>
				</c:forEach>
			</select>
		</div>
	</c:if>

	<c:if test="${requestScope.SEARCH_TAGS}">
		<label for="tag">${tag}</label>
		<input type="text" value="" id="tag" data-key="${tag}"/>
	</c:if>


	<div class="field custom-properties-js">
		<label for="properties">${properties}</label>
		<div class="sub-field-property">
			<select class="select-option vw-inline js-prop-select">
				<option value="">&nbsp;</option>
			</select>
			<input type="text" value="" data-key="" placeHolder="Value" class="vw-inline vw-nomargin properties-value" data-ignore = "true"/>
			<span class="sprite icon-content-delete deleteCustPropSearchVal" title="Delete"></span>
		</div>
	</div>

	<div class="addNewSearchPropertyJs vw-add-search-custprop">Add Property</div>

	<input id="advSearchBtn" type="button" value="${go}" class="reviewSelections"/>
</div>
</fmt:bundle>