<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<fmt:bundle basename="localization.SearchMessages">

<fmt:message key="all.keyword.language" var="language" />
<fmt:message key="fs.keyword.name" var="filename" />
<fmt:message key="fs.keyword.sizeInKb" var="size" />
<fmt:message key="fs.keyword.contains" var="contains" />
<fmt:message key="fs.keywords.go" var="go" />
<fmt:message key="fs.keyword.modTime" var="modTime"/>
<fmt:message key="fs.keyword.fileextension" var="extension"/>
<fmt:message key="exch.TimeRange" var="timeRange"/>
	
<fmt:message key="fromTime" var="fromTime"/>
<fmt:message key="toTime" var="toTime"/>

<script nonce="${sessionScope.cspNonce}" >
	var browseSearch = {};
	browseSearch.timeRangeDateSeparator = "${requestScope.DATE_SEPARATOR}";
	browseSearch.searchDateFormat = "${requestScope.SEARCH_DATE_FORMAT}";
	browseSearch.dateError = "${requestScope.SEARCH_DATE_FORMAT_ERROR}";
</script>

<div class="advSearchHolder fs vw-start-hidden">
	<div id="closeSearch"></div>

	<div class="field">
		<label for="filename">${filename}</label>
		<input type="text" value="" id="filename" data-key="${filename}"/>
	</div>

	<div class="field">
		<label for="contains">${contains}</label>
		<input type="text" value="" id="contains" data-key="${contains}"/>
	</div>

	<div class="field">
		<label for="extension">${extension}</label>
		<select id="extension" data-key="${extension}" class="fileextension">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.FILE_EXTENSIONS}" var="ext">
				<option value="${ext}">${ext}</option>
			</c:forEach>
		</select>
	</div>
	<div class="field">
		<label for="modTime">${modTime}</label>
		<select id="modTime" data-key="${modTime}" class="timeOptions">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.RECV_TIME_OPTIONS}" var="rt">
				<option value="${rt}">${rt}</option>
			</c:forEach>
			<option value="timeRange">${timeRange}</option>
		</select>
	</div>

	<div class="field vw-start-hidden timeRangeOptions">
		<label for="fromTime">${fromTime}</label>
		<input type="text" value="" id="fromTime" data-spl="true"  data-key="${fromTime}"/>

		<label for="toTime">${toTime}</label>
		<input type="text" value="" id="toTime" data-spl="true"  data-key="${toTime}"/>
	</div>

	<c:if test="${requestScope.SEARCH_LANGUAGES != null}">
		<div class="field">
			<label for="language">${language}</label>
			<select id="language" data-key="${language}" class="searchlanguage">
				<option value="">&nbsp;</option>
				<c:forEach items="${requestScope.SEARCH_LANGUAGES}" var="lang">
					<option value="${lang}">${lang}</option>
				</c:forEach>
			</select>
		</div>
	</c:if>
	<input id="advSearchBtn" type="button" value="${go}" class="reviewSelections"/>
</div>
</fmt:bundle>