<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<fmt:bundle basename="localization.SearchMessages">
<fmt:message key="all.keyword.language" var="language" />
<fmt:message key="exch.keyword.from" var="from"/>
<fmt:message key="exch.keyword.to" var="to"/>
<fmt:message key="exch.keyword.subject" var="subject"/>
<fmt:message key="exch.keyword.folder" var="folder"/>
<fmt:message key="fs.keyword.contains" var="contains"/>
<fmt:message key="fs.keywords.go" var="go" />
<fmt:message key="fs.keywords.search" var="search" />
<fmt:message key="exch.keyword.recvTime" var="recvTime"/>
<fmt:message key="exch.TimeRange" var="timeRange"/>
<fmt:message key="exch.keyword.size" var="size"/>
<fmt:message key="auto.exch.keyword.size" var="mailsize"/>
<fmt:message key="fromTime" var="fromTime"/>
<fmt:message key="toTime" var="toTime"/>
<fmt:message key="exch.keyword.hasAttachment" var="hasAttachment"/>
<fmt:message key="auto.exch.keyword.hasAttachment" var="hasAtt"/>
<fmt:message key="exch.keyword.sizeInKB" var="kb"/>
<fmt:message key="exch.keyword.sizeInMB" var="mb"/>
<fmt:message key="exch.keyword.sizeInGB" var="gb"/>
<fmt:message key="exch.keyword.sizeInBYTE" var="byte"/>
<fmt:message key="exch.keyword.lessThan" var="lessThan"/>
<fmt:message key="exch.keyword.greaterThan" var="greaterThan"/>
<fmt:message key="exch.keyword.categories" var="categories"/>

<script nonce="${sessionScope.cspNonce}" >
	var browseSearch = {};
	browseSearch.timeRangeDateSeparator = "${requestScope.DATE_SEPARATOR}";
	browseSearch.searchDateFormat = "${requestScope.SEARCH_DATE_FORMAT}";
	browseSearch.dateError = "${requestScope.SEARCH_DATE_FORMAT_ERROR}";
</script>

<div class="advSearchHolder vw-start-hidden exch">
<div id="closeSearch"></div>
	<div class="field">
		<label for="from">${from}</label>
		<input type="text" value="" id="from" data-key="${from}"/>
	</div>
	<div class="field">
		<label for="to">${to}</label>
		<input type="text" value="" id="to"  data-key="${to}"/>
	</div>
	<div class="field">
		<label for="subject">${subject}</label>
		<input type="text" value="" id="subject"  data-key="${subject}"/>
	</div>
	<!-- <div class="field">
		<label for="rcvdTime">Received Time</label>
		<input type="text" value="" id="rcvdTime" />
	</div> -->
	<!-- <div class="field">
		<label for="contains"><fmt:message key="exch.keyword.contains" /></label>
		<input type="text" value="" id="contains" />
	</div> -->
	<div class="field">
		<label for="folder">${folder}</label>
		<input type="text" value="" id="folder"  data-key="${folder}"/>
	</div>
	<div class="field">
		<div class="attachement">
			<span>
				<input type="checkbox" value="hasAttchment" id="hasAtt" data-key="${hasAtt}" data-val="true"/>
			</span>
			<span class="hasAttachement">
				<label for="hasAttachment">${hasAttachment}</label>
			</span>
		</div>
	</div>
	<div class="field">
		<div class="sizeRange">
			<label for="size">${size}</label>
			<span class="relation">
				<select name="relation">
					<option value="&gt">${greaterThan}</option>
					<option value="&lt;">${lessThan}</option>
				</select>
			</span>
			<span class="size">
				<input type="text" class="tripleInput" value="" id="size" data-key="${mailsize}" />
			</span>
			<span class = "sizeUnit">
				<select name="sizeUnit">
					<option value="KB">${kb}</option>
					<option value="MB">${mb}</option>
					<option value="GB">${gb}</option>
				</select>
			</span>
		</div>
	</div>
	<div class="field">
		<label for="contains">${contains}</label>
		<input type="text" value="" id="contains"  data-key="${contains}"/>
	</div>

	<div class="field">
		<label for="recvTime">${recvTime}</label>
		<select id="recvTime" data-key="${recvTime}" class="timeOptions">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.RECV_TIME_OPTIONS}" var="rt">
				<option value="${rt}">${rt}</option>
			</c:forEach>
			<option value="timeRange">${timeRange}</option>
		</select>
	</div>

	<div class="field vw-start-hidden timeRangeOptions">

		<label for="fromTime">${fromTime}</label>
		<input type="text" value="" id="fromTime" data-spl="true"  data-key="${fromTime}"/>

		<label for="toTime">${toTime}</label>
		<input type="text" value="" id="toTime" data-spl="true"  data-key="${toTime}"/>

	</div>

	<c:if test="${requestScope.SEARCH_LANGUAGES != null}">
	<div class="field">
		<label for="language">${language}</label>
		<select id="language" data-key="${language}" class="searchlanguage">
			<option value="">&nbsp;</option>
			<c:forEach items="${requestScope.SEARCH_LANGUAGES}" var="lang">
				<option value="${lang}">${lang}</option>
			</c:forEach>
		</select>
	</div>
	</c:if>
	
	<c:if test="${requestScope.SEARCH_CATEGORIES eq 'true'}">
	<div class="field">
		<label for="categories">${categories}</label>
		<input type="text" value="" id="categories"  data-key="${categories}"/>
	</div>
	</c:if>

	<input id="advSearchBtn" type="button" value="${search}" />
</div>
</fmt:bundle>