<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:message key="common.label.loading" var="loadingLabel" />
<fmt:bundle basename="localization.RestoreMessages">
	<c:set var="hasRestoreAgent" value="${requestScope.hasFsRestoreAgent}" />
	<fmt:message key="restore.title.page" var="pageTitle" />
	<fmt:message key="restoreOptions.title.browseForDestinationPath" var="browseForDestinationPathTitle" />
	<fmt:message key="restoreOptions.error.noDestinationClientsErrorMessage" var="noDestinationClientsErrorMessage" />
	<fmt:message key="restoreOptions.error.retrieveDestinationClientListFailed" var="retrieveDestinationClientListFailed" />
	<fmt:message key="restoreOptions.label.noOutOfPlace" var="noOutOfPlace" />
	<fmt:message key="restoreOptions.error.destinationPathInvalid" var="destPathInvalid" />
	<fmt:message key="restoreOptions.error.uncDestinationPathInvalid" var="uncDestPathInvalid" />
	<fmt:message key="restoreOptions.error.uncPathInvalid" var="uncPathInvalid" />
	<fmt:message key="restoreOptions.label.restoreAsUser" var="fmtRestoreAsUser"/>
	<fmt:message key="restoreOptions.error.passwordMismatch" var="fmtPasswordMismatch"/>
	<fmt:message key="restoreOptions.error.missingCredentials" var="fmtMissingCredentials"/>
	<fmt:message key="restoreOptions.label.originalClient" var="fmtOriginalClient"/>
	<fmt:message key="restoreOptions.label.overwrite" var="fmtOverwrite" />
	<fmt:message key="restoreOptions.label.restoreToSameFolder" var="fmtRestoreToSameFolder" />
	<fmt:message key="restoreOptions.error.noDestinationInstancesErrorMessage" var="noDestinationInstancesErrorMessage" />
	<fmt:message key="restoreOptions.error.retrieveDestinationInstanceListFailed" var="retrieveDestinationInstanceListFailed" />
	<fmt:message key="restoreOptions.label.confirmOverwriteMsg" var="confirmOverwriteMsg"/>
	<fmt:message key="restoreOptions.label.typeConfirmMsg" var="typeConfirmMsg"/>
	<fmt:message key="restoreOptions.label.restoreConfirmText" var="confirmText"/>
	<fmt:message key="restoreOptions.label.restoreConfirmTextError" var="confirmTextError"/>
	<fmt:message key="restoreOptions.label.restoreConfirmTitle" var="restoreConfirmTitle"/>

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="css/restore.css" name="css" />
	</jsp:include>
<c:set var="appType" value="FILESYSTEM" />
<c:if test="${cv:isVMImageBrowse(param.applicationId)}">
	<c:set var="appType" value="VIRTUALSERVER" />
</c:if>
<c:if test="${not empty requestScope.appType}">
	<c:set var="appType" value="${requestScope.appType}" />
</c:if>

	<div style="text-align: left">
		<div class="item-count-label">
			<fmt:message key="restoreOptions.title.selecDestinationForRestore" />
		</div>
		<form id="restoreOptionsFsForm" method="POST"><!-- Do not change from form to div -->
			<div id="restoreCompDiv"  class="destinationOptionsDiv">

				<span class="distributedRestoreOptions" id="distributedRestoreOptions">
					<div class="optionHolder">
						<div class="inputHolder">
							<input type="radio" name="restoreDestinationType" id="unixFs"
								value="unixFs" >
						</div>
						<div class="textHolder">
							<label for="unixFs"><fmt:message key="restoreOptions.label.unixFileSystem" /></label>
						</div>
					</div>
					<div class="optionHolder">
						<div class="inputHolder">
							<input type="radio" name="restoreDestinationType" id="distributedFs"
								value="distributedFs" checked="true">
						</div>
						<div class="textHolder">
							<label for="distributedFs"><fmt:message key="restoreOptions.label.distributedApps" /></label>
						</div>
					</div>
				</span>




				<div class="restoreCompCB">
				<div class="cbClass"></div>&nbsp;&nbsp;<fmt:message key="restoreOptions.label.destinationComputer"/>
				<select id="destCompList" name="destinationClient">
					<c:if test="${hasRestoreAgent or not cv:isVMImageBrowse(param.applicationId)}">
						<option value="${fn:escapeXml(param.clientName)}">${fn:escapeXml(param.clientName)} ${fmtOriginalClient}</option>
					</c:if>
				</select>
				<div>
					&nbsp;&nbsp;<span class="error destination-computer-error-js" style="display:none"><fmt:message key="restoreOptions.error.destinationClientInvalid"/></span>
				</div>

				<span class="distributedRestoreInstanceOptions" id="distributedRestoreInstanceOptions">
					<div class="cbClass"></div>&nbsp;&nbsp;<fmt:message key="restoreOptions.label.destinationInstance"/>
					<select id="destInstanceList" name="destinationInstance">
						<option value="${fn:escapeXml(param.instanceName)}">${fn:escapeXml(param.instanceName)}</option>
					</select>
					<div>
					&nbsp;&nbsp;<span class="error destination-computer-error-js" style="display:none"><fmt:message key="restoreOptions.error.destinationInstanceInvalid"/></span>
					</div>
				</span>

				</div>

				<span class="restoreCompCB">
					<span id="restoreToOriginalCb">
					<cv:cvCheckbox name="restoreToSameFolder" title="${fmtRestoreToSameFolder}" checked="true" />
					</span>

						<span class="restoreStackedItem destpath-js">
						<fmt:message key="restoreOptions.label.destinationPath"/>
						<input id="destinationPath" name="destinationPath" type="text" size="40" disabled="disabled"
						data-msg="${destPathInvalid}" data-validationfn="validateRestorePath()" class="textbox"/>
					<a id="destinationBrowse" href="#"  class="sprite icon-folder-open button-disabled" ></a>
					<br/>
					<span style="visibility:hidden;"><fmt:message key="restoreOptions.label.destinationPath"/></span>
					<label class="error" for="destinationPath">&nbsp;</label>
				</span>

				<div id="iuoptions" style="display:none;">
					<span id="iuvmlabel">&nbsp;&nbsp;<fmt:message key="restoreOptions.label.restoreToVmAsUser"/></span>
					<cv:cvCheckbox name="iu" title="${fmtRestoreAsUser}" checked="false" />
					<br/><span class="restoreStackedItem firstRestoreStackedItem">
					<span class="restoreStackedItemLabel"><fmt:message key="restoreOptions.label.userName"/></span>
					<input id="iun" name="iun" type="text" size="40"  disabled="disabled"
						data-msg="${fmtMissingCredentials}"
						data-validationfn="validateIu()"  class="textbox"/>
					</span>
					<span class="restoreStackedItem">
					<span class="restoreStackedItemLabel"><fmt:message key="restoreOptions.label.password"/></span>
					<input id="iup" name="iup" type="password" autocomplete="off" size="40"  disabled="disabled" class="textbox"/>
					</span>
					<span class="restoreStackedItem">
					<span class="restoreStackedItemLabel"><fmt:message key="restoreOptions.label.confirmPassword"/></span>
					<input id="iup2" name="iup2" type="password" size="40" autocomplete="off" disabled="disabled"
						data-msg="${fmtPasswordMismatch}"
						data-validationfn="validateIu()"  class="textbox"/>
					<br/>
					<label class="error" for="iun">&nbsp;</label>
					</span>
				</div>
				</span>

				<span class="overwriteCB">
				<cv:cvCheckbox name="overwrite" title="${fmtOverwrite}" checked="false" />
				</span>

			</div>
		</form>
		<br/><br/><br/>
		<c:if test="${false and cv:isVMImageBrowse(param.applicationId) and not hasRestoreAgent}">
					<a href="#" id="infoWhyVMIsNotAvailable"><fmt:message key="restoreOptions.label.infoWhyVMIsNotAvailable" /></a>
			</c:if>
		<div class="btns fullAlign">
			<a href="#" id="restoreButton" class="okSaveButton"><fmt:message key="restoreOptions.action.startRestore" /></a>
			<fmt:bundle basename="localization.messages">
			<a href="#" id="cancelButton"><fmt:message key="common.action.cancel" /></a>
			</fmt:bundle>
		</div>
	</div>

	<div class="errorZone">
	</div>

	<cv:ifCapability name="none RestoreInPlace RestoreOutOfPlace " appType="${appType}">
		<script nonce="${sessionScope.cspNonce}" >
		/* No options are available if you lack in place and out of place restore capability */
		cvUtil.mask("#restoreCompDiv", "", true);
		$("#restoreCompDiv").attr("title", "${noOutOfPlace}");
		</script>
	</cv:ifCapability>

	<script nonce="${sessionScope.cspNonce}" >
		<%-- Add remote CommCell details, if present. --%>
		if (typeof cvUtil == "object")
		{
			cvUtil.ccId = "${requestScope._cid}";
			cvUtil.ccName = "${requestScope._cn}";
		}

		var localMsg = localMsg || {};
		localMsg.loadingLabel = "${loadingLabel}";
		localMsg.browseForDestinationPathTitle = "${browseForDestinationPathTitle}";
		localMsg.noDestinationClientsErrorMessage = "${noDestinationClientsErrorMessage}";
		localMsg.retrieveDestinationClientListFailed = "${retrieveDestinationClientListFailed}";
		localMsg.originalClientLabel = "${fmtOriginalClient}";
		localMsg.uncDestinationPathInvalid = "${uncDestPathInvalid}";
		localMsg.uncPathInvalid = "${uncPathInvalid}";
		localMsg.noDestinationInstancesErrorMessage = "${noDestinationInstancesErrorMessage}";
		localMsg.retrieveDestinationInstanceListFailed = "${retrieveDestinationInstanceListFailed}";
		localMsg.confirmText = "${confirmText}";
		localMsg.confirmTextError = "${confirmTextError}";
		localMsg.confirmOverwriteMsg = "${confirmOverwriteMsg}";
		localMsg.typeConfirmMsg ="${typeConfirmMsg}";
		localMsg.restoreConfirmTitle="${restoreConfirmTitle}";
		var bEnableConfirmMessageForRestoreToSameFolderWithOverwrite = ${not empty applicationScope.bEnableConfirmMessageForRestoreToSameFolderWithOverwrite ? applicationScope.bEnableConfirmMessageForRestoreToSameFolderWithOverwrite : false};
		var hasRestoreAgent = "${hasRestoreAgent}";
		var hasOutOfPlaceCapability = false, hasOverWriteCapability = false;
		var restoreFs = restoreFs || {};
		restoreFs.appType = "${appType}";
		var hideNetworkRestore = ("true" === "${sessionScope.hideNetworkRestore}");
	</script>
	<cv:ifCapability name="RestoreOutOfPlace" appType="${appType}">
		<script nonce="${sessionScope.cspNonce}" >
			hasOutOfPlaceCapability = true;
	</script>
	</cv:ifCapability>

	<cv:ifCapability name="Visibility" appType="${appType}">
		<script nonce="${sessionScope.cspNonce}" >
			hasOverWriteCapability = true;
		</script>
	</cv:ifCapability>
	<jsp:include page="../common/footer.jsp">
		<jsp:param value="../common/js/encoder.js" name="js"/>
		<jsp:param value="js/restoreOptionsFs.js" name="js" />
		<jsp:param value="../common/js/custom-cb.js" name="js" />
	</jsp:include>


</fmt:bundle>
