<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ClientDetailsMessages">
<script type="text/template" id="jobProg">
	{{#jobsList}}
	<div class="progDivHolder job{{jobId}}" data-jId="{{jobId}}">
		<div class="progJobDiv">
			<img src = "../clientDetails/img/closeBackup.jpg" class="jobClose">
			<div class="vw-status-description">
				<span class='jobIdText'>{{titleLabel}}</span>
				<span class='jobId'>(Job Id: {{jobId}})</span>
			</div>
			<br />
			<div class="progress"><div class="progressPercent"></div></div>
			<div class="progressDetails">
				<table class="progressDetailsTable">
					<tr>
						<td><fmt:message key="currentStatus.label.dataRestored" /></td>
						<td class="sizeInfo">{{dataCompleted}}, {{filesCompleted}} <fmt:message key="clientDetails.param.filesText" /></td>
					</tr>
					<tr>
						<td><fmt:message key="currentStatus.label.timeStarted" /></td>
						<td class="startTime">{{startTime}}</td>
					</tr>
					<tr>
						<td><fmt:message key="currentStatus.label.timeElapsed" /></td>
						<td class="timeElapsed">{{timeElapsed}}</td>
					</tr>
					<tr>
						<td><fmt:message key="clientDetails.param.status" /></td>
						<td class="jobStatus">{{jobStatus}}</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	{{/jobsList}}
</script>
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
<cv:localMsg name="files"><fmt:message key="clientDetails.param.filesText" /></cv:localMsg>
<cv:localMsg name="titleLabel"><fmt:message key="clientDetails.param.currentJobStatus" /></cv:localMsg>
</script>
</fmt:bundle>
<link rel="stylesheet" href="${pageContext.request.contextPath}/jobs/css/jobProgress.css?${applicationScope.BUILD_TS}" />		
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/jobs/js/jobProgress.js?${applicationScope.BUILD_TS}"></script>
