<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<jsp:include page="../common/table.jsp" />
<jsp:include page="../common/mask.jsp" />

<c:set var="escapedClientName" value="${fn:escapeXml(param.clientName)}" />
<c:set var="escapedClientId" value="${fn:escapeXml(param.clientId)}" />
<c:set var="escapedParamType" value="${fn:escapeXml(param.type)}" />
<c:set var="escapedParamIsCloudLaptop" value="${fn:escapeXml(param.isCloudLaptop)}" />



<table id="jobsTable" class="reportTable tablesorter table vw-recent-jobs-table">
	<col width='10%'>
	<col width='10%'>
	<col width='15%'>
	<col width='17%'>
	<col width='13%'>
	<col width='10%'>
	<col width='13%'>
	<!-- c:if test="${param.type == 'backup'}"-->
		<!-- col width='12%'-->
	<!-- /c:if-->
	<thead>
		<tr>
		< c:if test="${!(param.isCloudLaptop == 'true')}">
			<th><f:message key="Job_Id" /></th>
			<th><f:message key="Operation" /></th>
			<th><f:message key="Start_Time" /></th>
			<th><f:message key="Elapsed_Time" /></th>
			<th><f:message key="State" /></th>
			<th><f:message key="No_Of_Files" /></th>
			<th><f:message key="Size" /></th>
			</c:if>
			<c:if test="${param.isCloudLaptop == 'true'}">
			<th><f:message key="Job_Id" /></th>
			<th><f:message key="Operation" /></th>
			<th><f:message key="Backup_Date" /></th>
			<th><f:message key="File_Count" /></th>
			<th><f:message key="State" /></th>
			<th><f:message key="Size" /></th>
			<th><f:message key="Data_Size" /></th>
			</c:if>
			<!-- c:if test="${param.type == 'backup'}"-->
					<!-- th><f:message key="Action" /></th-->
			<!-- /c:if-->
		</tr>
	</thead>
</table>
<div class="clrfloat">&nbsp;</div>
<f:bundle basename="localization.messages">
			<f:message key="no.data.in.jobstable" var="noDataText"/>
			<f:message key="View_Backup_Items" var="ViewItems"/>
</f:bundle>
<c:set var="jobListType" value="${escapedParamType}"/>
<c:set var="isCloud" value="${escapedParamIsCloudLaptop}"/>

<f:bundle basename="localization.ClientDetailsMessages">
	<f:message key="clientDetails.label.autoResumeTitle" var="autoResumeTitle"/>
</f:bundle>
<script nonce="${sessionScope.cspNonce}" >

<%-- Add remote CommCell details, if present. --%>
if (typeof cvUtil == "object")
{
	cvUtil.ccId = "${requestScope._cid}";
	cvUtil.ccName = "${requestScope._cn}";
}

var localMsg = localMsg || {};
localMsg.autoResumeTitle="${autoResumeTitle}";
	function initHoverListeners() {
		$("tbody").on("mouseenter", "tr", function(event) {
			var row = $(event.target.parentNode);
			row.addClass('row_active');
			var children = row.children();
			//appendImgs(children.eq(4),children.eq(0).html());
		});

		$("tbody").on("mouseout", "tr", function(event) {
			$(this).removeClass('row_active');
		});
	}


	$(document).ready(
			function() {
				function jobAction(jobId, action, el, resumeTime) {
					var jobTp = $(el).parents("tr").children(".vw-job-type").html();
					var cell = $(el).parents("td");
					var cellParent = cell.parent();
					cell.before().append("<img src='../common/img/row-loader.gif' class='rowLoaderClass vw-row-loading'>");
					cellParent.addClass("loadingRow");
					cvUtil.loadPage(cvUtil.getContextPath() + "/server/doJobAction", {
						jobId : jobId,
						action : action,
						resumeTime: resumeTime
					}, function(data) {
						console.log("Job Submitted for doJobAction");
						$(".dropdown").hide();
						window.setTimeout(function(){
							cvUtil.loadPage("specificJobProgress.do?clientId=${escapedClientId}&clientName=${escapedClientName}&jobId=" + jobId+"&jobType="+jobTp.toLowerCase()+"&jobListType=true",null,

								function(result){

									console.log("load job response " + jobId + " : " + result);
									if( result == "") {
										console.log("data doesn't look valid: " + result);
										cell.before().children("img").eq(0).remove();
										cellParent.removeClass("loadingRow");
									} else {
										try{
											obj = JSON.parse(result);
											var cellChildren = cellParent.children();
											cellChildren[1].innerHTML = jobTp.toLowerCase();
											cellChildren[2].innerHTML = cvUtil.convertUnixTimeStampToDate(obj.jobStartTimeString, '');
											cellChildren[3].innerHTML = obj.jobElapsedTimeString;
											cellChildren[4].innerHTML = obj.status;
											cellChildren[5].innerHTML = obj.totalNumOfFiles;
											cellChildren[6].innerHTML = obj.sizeOfApplication;
											cellChildren[7].innerHTML = obj.percentSavings;
											cell.before().children("img").eq(0).remove();
											cellParent.removeClass("loadingRow");
										}
										catch(e){
											console.log("Error while updating row");
											cell.before().children("img").eq(0).remove();
											cellParent.removeClass("loadingRow");
										}
									}

								},
								function(evt){

									console.log("Job could not be updated");
									cell.before().children("img").eq(0).remove();
									cellParent.removeClass("loadingRow");

								});
						}, 3000);
					}, function() {
						console.log("Job could not be submitted for doJobAction");
						$(".dropdown").hide();
					});
				}

				var jobIdOfJob = "";

				$(document).on("click", "#viewBackupItemsLnk", function(e){
					var position = oTable.fnGetPosition($("td:parent").has(this).get(0));
					var url = oTable.fnGetData(position[0])[10];
					url += "${adminModeParam}";
					window.location = url;
				});

				function pause(evt, timePeriod) {
					evt.preventDefault();

					jobIdOfJob=$(evt.target).parents("tr").find('.vw-job-id').text();

					var jobSelected = $(evt.target).parents(".pausedJob").find(".pauseResumeLink");

					jobActionText = "pause";

					jobAction(parseInt(jobIdOfJob), jobActionText, jobSelected, timePeriod);

				}

				$(document).on("click", ".pause1Hour", function(event){
					pause(event, 1*3600);
				});

				$(document).on("click", ".pause2Hour", function(event){
					pause(event, 2*3600);
				});

				$(document).on("click", ".pause4Hour", function(event){
					pause(event, 4*3600);
				});

				$(document).on("click", ".pause8Hour", function(event){
					pause(event, 8*3600);
				});

				$(document).on("click", ".pause12Hour", function(event){
					pause(event, 12*3600);
				});

				$(document).on("click", ".pauseIndefinitely", function(event){
					pause(event, 0);
				});

				$(document).on("click", ".customTime", function(evt){
					evt.preventDefault();

					if($(evt.target).parents(".odd")!=null && $(evt.target).parents(".odd").length > 0) {
						jobIdOfJob=$(evt.target).parents("tr.odd").find('td:first').text();
					}
					else {
						jobIdOfJob=$(evt.target).parents("tr.even").find('td:first').text();
					}

					var jobSelected = $(evt.target).parents(".pausedJob").find(".pauseResumeLink");
					jobActionText = "pause";
					var target = cvUtil.getContextPath() + "/jobs/getAutoResumeInSecs.jsp";
					var options = {
							width : 300,
							height : 200,
							title : localMsg.autoResumeTitle,
							href : target,
							iframe : true,
							resizable: true
					};
					cvUtil.showModal(options, null, function(data) {
						if (typeof data !== "undefined" && data !== null) {
							var timePeriod = data.resumeTimePeriod;
							jobAction(parseInt(jobIdOfJob), jobActionText, jobSelected, timePeriod);
						}
					});
				});

				$(document).on("click", ".pauseResumeLink, .cancelLink", function(e){
					if($(e.target).parents(".odd")!=null)
						jobIdOfJob=$(e.target).parents("tr.odd").find('td:first').text();
					else
						jobIdOfJob=$(e.target).parents("tr.even").find('td:first').text();

					var jobActionText = $(this).text();
					var timePeriod = 0;
					if (jobActionText == "Pause") {

					} else {
						jobAction(parseInt(jobIdOfJob), jobActionText, $(this));
					}
				});

			    jQuery.fn.dataTableExt.oSort['intComparer-asc'] = function (a, b) {
			        var aa = parseInt($(a).html());
			        var bb = parseInt($(b).html());
			        return aa == bb ? 0 : ( aa < bb ? -1 : 1 );
			    };

			    jQuery.fn.dataTableExt.oSort['intComparer-desc'] = function (a, b) {
			        var aa = parseInt($(a).html());
			        var bb = parseInt($(b).html());
			        return aa == bb ? 0 : ( aa > bb ? -1 : 1 );
			    };

				jQuery.fn.dataTableExt.oSort['actual_time-asc'] = function(x, y) {
					aa = parseInt($(x).text());
				    bb = parseInt($(y).text());
				    return aa == bb ? 0 : ( aa < bb ? -1 : 1 );
				};

				jQuery.fn.dataTableExt.oSort['actual_time-desc'] = function(x, y) {
					aa = parseInt($(x).text());
				    bb = parseInt($(y).text());
				    return aa == bb ? 0 : ( aa > bb ? -1 : 1 );
				};

				jQuery.fn.dataTableExt.oSort['actual_size-asc'] = function(x, y) {
					aa = parseInt($(x).text());
				    bb = parseInt($(y).text());
				    return aa == bb ? 0 : ( aa < bb ? -1 : 1 );
				};

				jQuery.fn.dataTableExt.oSort['actual_size-desc'] = function(x, y) {
					aa = parseInt($(x).text());
				    bb = parseInt($(y).text());
				    return aa == bb ? 0 : ( aa > bb ? -1 : 1 );
				};

				//jQuery.fn.dataTableExt.oSort['actual_reduction_size-asc'] = function(x, y) {
				//	aa = parseFloat($(x).text());
				//    bb = parseFloat($(y).text());
				//    if(aa<0)
				//    	aa=0;
				//    if(bb<0)
				//    	bb=0;
				//    return aa == bb ? 0 : ( aa < bb ? -1 : 1 );
				//};

				//jQuery.fn.dataTableExt.oSort['actual_reduction_size-desc'] = function(x, y) {
				//	aa = parseFloat($(x).text());
				//    bb = parseFloat($(y).text());
				//    if(aa<0)
				//    	aa=0;
				//    if(bb<0)
				//    	bb=0;
				//    return aa == bb ? 0 : ( aa > bb ? -1 : 1 );
				//};
				var lastRefresh = new Date();
				oTable = $('#jobsTable').dataTable({
					"sAjaxSource" : cvUtil.getContextPath() + "/server/listJobs",
					"bServerSide" : true,
					"iDisplayLength": 20,
					"fnServerParams" : function(aoData) {
						aoData.push({
							"name" : "clientId",
							"value" : "${escapedClientId}"
						}, {
							"name" : "clientName",
							"value" : "${escapedClientName}"
						}, {
							"name" : "type",
							"value" : "${escapedParamType}"
						},
						{
							"name" : "isCloudLaptop",
							"value" : "${escapedParamIsCloudLaptop}"
						});
						if (cvUtil.getParameter('adminMode', '')) {
							aoData.push({
								"name" : "adminMode",
								"value" : "true"
							});
						}
					},
					"fnServerData" : function(sSource, aoData, fnCallback) {
						$("#jobsTable_wrapper").mask(" ");
						$.ajax({
							"dataType" : 'json',
							"type" : "POST",
							"url" : sSource,
							"data" : aoData,
							"error" : function() {
								$("#jobsTable_wrapper").unmask();
							},
							"success" : function(json) {
								// Proceed with normal dataTable processing:
								$("#jobsTable_wrapper").unmask();
								// Te data which obtained is in the format shown below
								// <a id="xyz">timestamp</a>
								// We need to convert the timestamp to include the timezone.
								// Hence we parse the <a> tag to obtain the timestamp
								// And insert the modified timestamp which has the timezone information.

								if(json.aaData){
									for (var key in json.aaData) {
										  if (json.aaData.hasOwnProperty(key)) {
											  try {
                                                  var elementText = $(json.aaData[key][2]).text();
                                                  var convertToUnix = cvUtil.convertUnixTimeStampToDate(elementText, "");
                                                  json.aaData[key][2]= $(json.aaData[key][2]).text(convertToUnix).prop('outerHTML');
											  }
											  catch(_){
												  if ("${isCloud}" == 'true'){
														json.aaData[key][2] = cvUtil.convertUnixTimeStampToDate(json.aaData[key][2], null, 'MMM D' );
													}
												  	else{
		                                                  json.aaData[key][2] = cvUtil.convertUnixTimeStampToDate(json.aaData[key][2], "");
												  	}
											  }
										  }
									}
								}
								console.log(json);
								fnCallback(json);
								if (oTable.dataTableSettings[0]._iDisplayLength < json.iTotalRecords) {
									$("#jobsTable_paginate").show();
									$(".dataTables_info").show();

								} else {
									$("#jobsTable_paginate").hide();
									$(".dataTables_info").hide();
								}
								initHoverListeners();
							}
						});
					},
					"sDom" : "Rfrtip",
					"aaSorting": [[ 0, "desc" ]],
					"aoColumnDefs":
						("${jobListType}" == 'backup' && "${isCloud}" == 'true') ?
						[
							{ "aTargets": [ 0 ], "sType": "intComparer", "sClass": "hidden vw-job-id"},
							{ "aTargets": [ 1 ], "sClass": "hidden vw-job-type"},

							{ "aTargets": [ 2 ] , "sWidth" : "25%","bSortable" : false}, //backup date

							{ "aTargets": [ 3 ],"sType": 'actual_time', "sWidth" : "25%","bSortable" : false}, //file count

							{ "aTargets": [ 4 ] , "sWidth" : "20%", "sClass": "hidden"},
							{ "sClass": "rightCol", "aTargets": [ 5 ] , "sWidth" : "25%","bSortable" : false}, //size
							{ "sClass": "rightCol", "aTargets": [ 6 ], "sType": 'actual_size' , "sWidth" : "25%","bSortable" : false}, //data

							//{ "sClass": "rightCol", "aTargets": [ 7 ], "sType": 'actual_reduction_size' }




						]
						:
						("${jobListType}" == 'backup') ?
						// column defs for backup job list:
						[
							{ "aTargets": [ 0 ], "sType": "intComparer", "sClass": "hidden vw-job-id"},
							{ "aTargets": [ 1 ], "sClass": "hidden vw-job-type"},
							{ "aTargets": [ 2 ] , "sWidth" : "20%"},
							{ "aTargets": [ 3 ],"sType": 'actual_time', "sWidth" : "20%"},
							{ "aTargets": [ 4 ] , "sWidth" : "20%"},
							{ "sClass": "rightCol", "aTargets": [ 5 ] , "sWidth" : "20%"},
							{ "sClass": "rightCol", "aTargets": [ 6 ], "sType": 'actual_size' , "sWidth" : "20%"}
							//{ "sClass": "rightCol", "aTargets": [ 7 ], "sType": 'actual_reduction_size' }
						]
							:
						// column defs for restore job list:
						[
							{ "aTargets": [ 0 ], "sClass": "hidden vw-job-id" /*,"sType": "intComparer"*/},
							{ "aTargets": [ 1 ], "sClass": "hidden vw-job-type"},
							{ "aTargets": [ 2 ] , "sWidth" : "20%"},
							{ "aTargets": [ 3 ], "sType": 'actual_time', "sWidth" : "20%"},
							{ "aTargets": [ 4 ] , "sWidth" : "20%"},
							{ "sClass": "rightCol", "aTargets": [ 5 ] , "sWidth" : "20%"},
							{ "sClass": "rightCol", "aTargets": [ 6 ],"sType": 'actual_size' , "sWidth" : "20%"}
							],
					"bLengthChange" : false,
					"sPaginationType" : 'input',
					"bRetrieve" : true,
					"bAutoWidth" : false,
					"bFilter" : false,
					"oLanguage" : {
						"oPaginate" : {
							"sFirst" : '&nbsp;',
							"sNext" : '&nbsp;',
							"sPrevious" : '&nbsp;',
							"sLast" : '&nbsp;'
						},
						"sLoadingRecords": "",
						"sEmptyTable": "${noDataText}"
					},

					"fnDrawCallback" : CVTable.styleIt
				});

				//AUTO-REFRESH disabled
				//cvUtil.addTimerTask(function(){
				//	oTable.fnReloadAjax(null, null, true);
				//},60000);
				console.log("calling subscribe for job");
				pushService.subscribe({
					'msg' : 'subscribe',
					'type' : 'JOB',
					'additionalData' : 'CLIENT_FILTER|${escapedClientId}'
				}, function(data) {
					var refreshTable = false;
					//only refresh when the jobs are either backup or restore jobs
					if (data && data.jobs){
						for(var i=0; i<data.jobs.length;i++){
							if (data.jobs[i].jobSummary && data.jobs[i].jobSummary.opType && data.jobs[i].jobSummary.opType.toLowerCase() === '${escapedParamType}'){
								var d = new Date();
								var pushedClientName = data.jobs[i].jobSummary.subclient ? data.jobs[i].jobSummary.subclient.clientName:'';
								console.log("refresh push notification recieved on "+d+ " for "+ pushedClientName);
								var secondsElapsedSinceLastRefresh = (d.getTime() - lastRefresh.getTime()) / 1000;
								if (secondsElapsedSinceLastRefresh >= 60 || (data.jobs[i].jobSummary.percentComplete && (data.jobs[i].jobSummary.percentComplete == 100))){
									console.log('refreshing now'+ d);
									refreshTable = true;break;
								}
							}
						}
					}
					//refresh the table on receiving job notification
					if (refreshTable){
						lastRefresh = new Date();
						oTable.fnDraw();
					}
				}, function(data) {
					console.log("Something went wrong with subscribing for job");
				});
			});

	$(window).on("beforeunload", function() {
		// unsubscribe from the notifications when the user moves away from the page
		console.log("calling unsubscribe for job");
		pushService.unsubscribe({
								'msg' : 'unsubscribe',
								'type' : 'JOB',
								'additionalData' : 'CLIENT_FILTER|${escapedClientId}'
								});
	});

</script>