<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ClientDetailsMessages">
	<jsp:include page="../common/header.jsp">
		<jsp:param value="css/upload.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
	</jsp:include>
	<fmt:bundle basename="localization.messages">
		<fmt:message key="resumeIntervalTitle" var="resumeTitle"/>
		<fmt:message key="date.Minutes" var="minutes"/>
		<fmt:message key="date.Hours" var="hours"/>
	</fmt:bundle>
	
	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	
	<div class="pDiv">
			<div class="autoResumeTimeDiv">
				<div>
					<span id="resumeTitle" class="resumetitle">${resumeTitle}</span>
				</div>
				<div class="line">
				<input name="resumeTime" min=1 max=720 type="number" id="autoResumeTimeInterval" onkeydown="validateNumber(event);" value="1" style="text-align: right">
				<span>
					<select id="timeUnit">
						<option value="Minutes">${minutes}</option>
						<option value="Hours">${hours}</option>
					</select>
				</span>
				</div>
			</div>
			<div id="autoResumeNotes" style="display: none;color:#992211;"><fmt:message key="clientDetails.label.autoResumeNotes" /></div>
	</div>
	
	<fmt:bundle basename="localization.messages">
		<div class="btns">
			<a href="#" id="cancelButton"><fmt:message key="common.action.cancel" /></a>
			<a href="#" id="okButton" class="okSaveButton"><fmt:message key="common.action.ok" /></a>
		</div>
	</fmt:bundle>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
//This method called by custom-modal to retrieve return value for callback function

function validateNumber(evt) {
    var e = evt || window.event;
    var key = e.keyCode || e.which;

    if (!e.shiftKey && !e.altKey && !e.ctrlKey &&
    // numbers   
    (key >= 48 && key <= 57) ||
    // Numeric keypad
    key >= 96 && key <= 105 ||
    // Backspace and Tab and Enter
    key == 8 || key == 9 || key == 13 ||
    // Home and End
    key == 35 || key == 36 ||
    // left and right arrows
    key == 37 || key == 39 ||
    // Del and Ins
    key == 46 || key == 45) {
        // input is VALID
    }
    else {
        // input is INVALID
        e.returnValue = false;
        if (e.preventDefault) e.preventDefault();
    }
}

function getData() {
	if (typeof returnData === "undefined") {
		return null;
	} else {
		return returnData;
	}
}
$("#cancelButton").on("click", function(){
	cvUtil.closeModal();
});

$("#okButton").on("click", function(){
	var timePeriod = 0;
	if ($("#autoResumeTimeInterval").val() != '' && $("#autoResumeTimeInterval").val() > 0 ){
		if ($("#timeUnit option:selected").val() =='Minutes') {
			timePeriod = 60 * $("#autoResumeTimeInterval").val();
		} else
			timePeriod = 3600 * $("#autoResumeTimeInterval").val();
		returnData = {
				resumeTimePeriod : timePeriod
			};
			cvUtil.closeModal();
	} else {
		$("#autoResumeNotes").css("display", "inline");
	}
});


$(document).ready(
		function() {
			$("#autoResumeTimeInterval").focus().select();
			
		});



</script>
<style>
body #content{
	min-height: 0px;
	border: 0px;
	background: none;
	box-shadow: 0 0 0 0;
	padding: 5px 0px;
}
.autoResumeTimeDiv{
	padding:5px 5px 5px 5px;
}
#autoResumeInSecs{
	width: 100;
	padding: 0px 5px;
	float: left;
	/*height: 28px;*/
	line-height: 20px;
	font-family: arial, sans-serif;
	font-size: 1em;
	color: #333;
	background: #fff;
	border: 1px solid #d9d9d9;
	border-top: 1px solid #d0d0d0;
	text-align: right;
}
</style>