<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.messages">
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
localMsg.Job_Id = '<fmt:message key="Job_Id" />';
localMsg.Job_Status = '<fmt:message key="Job_Status" />';
localMsg.Job_Completed = '<fmt:message key="Job_Completed" />';
localMsg.Operation = '<fmt:message key="Operation" />';
localMsg.Failed = '<fmt:message key="Failed" />';
localMsg.Completed = '<fmt:message key="Completed" />';
localMsg.Waiting = '<fmt:message key="Waiting" />';
localMsg.Pending = '<fmt:message key="Pending" />';
localMsg.Killed = '<fmt:message key="Killed" />';
JobManager = {
		jobdescriptions: {},
		jobids: [],
		displayStatus: true,
		polljob: function (jobs, callback){ //an array of jobids or an object with jobid:jobdescription as its properties
			JobManager.jobids=[];
			JobManager.jobdescriptions={};
			if(JobManager.intervalid)
			{
				JobManager.cancelPolling();
			}
			if (jobs instanceof Array)
			{
				JobManager.jobids = jobs;
			}
			else
			{
				JobManager.jobdescriptions=jobs;
				for(var key in jobs){
					JobManager.jobids.push(key);
				}
			}
			JobManager.callback = callback;
			if(JobManager.jobids.length>0)
			{
				JobManager.intervalid = cvUtil.addTimerTask(JobManager.pollserver,30000);
			}
		},
		cancelPolling: function(){
			cvUtil.cancelTimerTask(JobManager.intervalid);
			delete JobManager.intervalid;
		},
		addJob: function(jobid, description){
			JobManager.jobdescriptions[jobid] = description;
			JobManager.jobids.push(jobid);
			if(JobManager.jobids.length==1)
				JobManager.intervalid = cvUtil.addTimerTask(JobManager.pollserver,30000);
		},
		removeJob: function(jobid){
			jobid=""+jobid;
			if (JobManager.jobids.indexOf(jobid) !== -1) {
				JobManager.jobids.splice(JobManager.jobids.indexOf(jobid), 1);
				delete JobManager.jobdescriptions[jobid];
				if(JobManager.jobids.length==0)
					JobManager.cancelPolling();
			}
		},
		pollserver: function()
		{
			cvUtil.loadPageWithGET(cvUtil.getContextPath() + '/jobProgressById.do', {"jobids":JobManager.jobids.join(',')}, function(jobsummaryarray){
//				var jobsummaryarray = data.elements;
				$.each(JobManager.jobids, function(index, jobId){
					var found = false;
					$.each(jobsummaryarray, function(index, jobSummary){
						if(jobId==jobSummary["jobId"])
							found=true;
					});
					if(!found)
						JobManager.removeJob(jobId);
				});
				$.each(jobsummaryarray, function(index, val){
					var jobid = val["jobId"];
					var jobstatus=val["jobStatus"];
					if(jobstatus==='Failed')
					{
						if(JobManager.displayStatus) {
							cvUtil.errorToast(JobManager.getDescription(jobid) + " " + localMsg.Failed, null, false, true);
						}
						JobManager.removeJob(jobid);
					}
					else if(jobstatus==='Completed')
					{	
						if(JobManager.displayStatus) {
							cvUtil.toast(JobManager.getDescription(jobid) + " " + localMsg.Job_Completed, null, null, true);
						}
						JobManager.removeJob(jobid);
					}
					else if(jobstatus==='Killed'||jobstatus==='Kill Pending')
					{
						if(JobManager.displayStatus) {
							cvUtil.toast(JobManager.getDescription(jobid) + " " + localMsg.Killed, null, null, true);						
						}
						JobManager.removeJob(jobid);
					}
				});
				JobManager.callback(jobsummaryarray);
			});
		},

		getDescription: function(jobid){
			var d = JobManager.jobdescriptions[jobid];
			if(!d)
				return localMsg.Job_Id+"=" + jobid;
			return d + " ("+localMsg.Job_Id+"= " + jobid + ")";
		},

		//Utility method to show a useful tooltip
		getTitleForProgressBar: function(job, includeDescription, localizedStatus){
			var title="";
			if(job.jobDescription && includeDescription!==false)
				title = localMsg.Operation + ": "+job.jobDescription+"\n";
			if(!localMsg[job.jobStatus])
				localMsg[job.jobStatus]=job.jobStatus;
			if(!localizedStatus)
				localizedStatus=localMsg[job.jobStatus];
			return title + localMsg.Job_Status + ": "+localizedStatus+"\n"+localMsg.Job_Id+": "+ job.jobId;
		}
};
</script>
</fmt:bundle>