<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<fmt:bundle basename="localization.ScheduleMessages">
	<fmt:message key="schedule.label.noPermissions" var="scheduleViewOnlyPermissions" />
	<fmt:message key="schedule.label.policy" var="scheduleViewOnlyPolicy" />

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="" name="titleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/js/cvTimepicker.js" name="js" />
		<jsp:param value="css/summarystyles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../common/css/cvTimepicker.css" name="css" />
		<jsp:param value="css/schedule.css" name="css" />
	</jsp:include>
	<fmt:message key="schedule.option.startOnlyOnAc" var="localStartOnlyOnAc"/>
	<fmt:message key="schedule.option.stopIfBatteryMode" var="localStopIfBatteryMode"/>
	<fmt:message key="schedule.option.cpuBelowThresholdEnabled" var="localCpuBelowThresholdEnabled"/>
	<fmt:message key="schedule.day.monday" var="localMonday"/>
	<fmt:message key="schedule.day.tuesday" var="localTuesday"/>
	<fmt:message key="schedule.day.wednesday" var="localWednesday"/>
	<fmt:message key="schedule.day.thursday" var="localThursday"/>
	<fmt:message key="schedule.day.friday" var="localFriday"/>
	<fmt:message key="schedule.day.saturday" var="localSaturday"/>
	<fmt:message key="schedule.day.sunday" var="localSunday"/>
	<fmt:message key="schedule.time.hour" var ="hoursText" />
	<fmt:message key="schedule.time.minute" var ="minutesText" />
	<fmt:message key="schedule.time.AM" var ="AMText" />
	<fmt:message key="schedule.time.PM" var ="PMText" />
	<fmt:message key="schedule.label.confirmDelete" var="confirmDelete"/>
	<fmt:message key="schedule.label.errorMessage1" var="errorMessage1"/>

	<c:set var="sched" value="${requestScope.SCHEDULE}" />
	<c:set var="schedFreqType" value="${requestScope.SCHEDULE_FREQTYPE}" />

	<div>
		<div id="schMask">
		<form id="schForm">
		<div id="freqOptions">
		<fmt:message key="schedule.label.howOften"/><br/> <cv:cvRadioGroup entries="${schedFreqType}" name="freqType"/>
		</div><br />
		<div id="automaticElements">

<!-- min and max intervals need not be configured for automatic schedules. The controls are not completely removed but only hidden
because already existing automatic schedules with non-default intervals should maintain the interval values. They should not be overwritten. Values are still sent in the request XML to backend. -->
			<div class="interval">
				<label><fmt:message key="schedule.option.minBackupInterval"/></label>
				<input type="text" name="minBackupIntervalHours" size=4  value="${sched.minBackupIntervalHours}" />
				<label><fmt:message key="schedule.option.hours"/></label>
				<input type="text" name="minBackupIntervalMinutes" size=4  value="${sched.minBackupIntervalMinutes}" />
				<label><fmt:message key="schedule.option.minutes"/></label>
				<br />
				<label><fmt:message key="schedule.option.maxBackupInterval"/></label>
				<input type="text" name="maxBackupIntervalHours" size=4 value="${sched.maxBackupIntervalHours}" />
				<label><fmt:message key="schedule.option.hours"/></label>
				<input type="text" name="maxBackupIntervalMinutes" size=4 value="${sched.maxBackupIntervalMinutes}" />
				<label><fmt:message key="schedule.option.minutes"/></label>
				<br />
			</div>
<!-- 		<br /> -->



			<div class="power">
				<cv:cvCheckbox name="startOnlyOnAc" title="${localStartOnlyOnAc}"
					checked="${sched.startOnlyOnAc}" /><br />
				<cv:cvCheckbox name="stopIfBatteryMode" title="${localStopIfBatteryMode}"
					checked="${sched.stopIfBatteryMode}" /><br />
			</div>
		<br />
			<div class="threshold">
				<cv:cvCheckbox name="cpuBelowThresholdEnabled" title="${localCpuBelowThresholdEnabled}" checked="${sched.cpuBelowThresholdEnabled}" />
				<input type="text" name="cpuBelowThreshold" size=4 value="${sched.cpuBelowThreshold}" /><br />
			</div>
		<br />
		</div>

		<div id="dailyElements">
			<label for="activeStartTime"><fmt:message key="schedule.label.whatTime"/></label>
			<span id="activeStartTimeDisplay"></span>
			<input type="hidden" id="activeStartTime" name="activeStartTime" value="${sched.activeStartTime}" />
			<br />
			<br />
		</div>
		<div id="weeklyElements">
		<label><fmt:message key="schedule.label.whichDays"/></label><br />
			<ol id="daysToRunList">
				<li><cv:cvCheckbox name="daysToRun0" styleClass="dayToRun" title="${localMonday}" checked="${sched.daysToRun[0]}" /></li>
				<li><cv:cvCheckbox name="daysToRun1" styleClass="dayToRun" title="${localTuesday}" checked="${sched.daysToRun[1]}" /></li>
				<li><cv:cvCheckbox name="daysToRun2" styleClass="dayToRun" title="${localWednesday}" checked="${sched.daysToRun[2]}" /></li>
				<li><cv:cvCheckbox name="daysToRun3" styleClass="dayToRun" title="${localThursday}" checked="${sched.daysToRun[3]}" /></li>
				<li><cv:cvCheckbox name="daysToRun4" styleClass="dayToRun" title="${localFriday}" checked="${sched.daysToRun[4]}" /></li>
				<li><cv:cvCheckbox name="daysToRun5" styleClass="dayToRun" title="${localSaturday}" checked="${sched.daysToRun[5]}" /></li>
				<li><cv:cvCheckbox name="daysToRun6" styleClass="dayToRun" title="${localSunday}" checked="${sched.daysToRun[6]}" /></li>
			</ol>
		</div>
		</form>
		<br />
		</div>
		<fmt:bundle basename="localization.messages">
			<div class="btns" >
				<a href="#" id="deleteButton"><fmt:message key="common.action.delete" /></a>
				<a href="#" id="cancelButton"><fmt:message key="common.action.cancel" /></a>
				<a href="#" id="okButton" class="okSaveButton"><fmt:message key="common.action.ok" /></a>
				<a href="#" id="closeButton"><fmt:message key="common.action.close" /></a>
			</div>
		</fmt:bundle>
	</div>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	<%-- Add remote CommCell details, if present. --%>
	if (typeof cvUtil == "object")
	{
		cvUtil.ccId = "${requestScope._cid}";
		cvUtil.ccName = "${requestScope._cn}";
	}

	var localMsg = localMsg || {};
	localMsg.scheduleViewOnlyPermissions = "${scheduleViewOnlyPermissions}";
	localMsg.scheduleViewOnlyPolicy = "${scheduleViewOnlyPolicy}";
	localMsg.hours = "${hoursText}";
    localMsg.minutes = "${minutesText}";
    localMsg.AM = "${AMText}";
    localMsg.PM = "${PMText}";
	var confirmDeleteVar = "${confirmDelete}";
	var errorMessage1Text="${errorMessage1}";
</script>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/schedule.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
</jsp:include>

