<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.ClientDetailsMessages">

<div id="wait" class="text-center">
	<img src="../common/css/images/loading.gif" role="presentation" aria-hidden="true" alt="" /> <p><fmt:message key="currentStatus.label.submittingJob" /></p>
</div>
<div class="pull-right"><span class="glyphicon glyphicon-remove vw-icon-close" id="backupJobClose" role="button" aria-label="<fmt:message key='dialogParams.action.close' />" tabindex="0"></span></div>
<div id="failedToStart">
	<p><fmt:message key="currentStatus.label.backupJobCouldNotBeStarted" /></p>
</div>
<div id="progBackup">
	<div class="vw-status-description"><span class='jobIdText vw-job-id'><fmt:message key="currentStatus.label.currentBackupStatus" /></span></div>
	<br />
	<div id="progress" class="vw-progressbar"><div class="progressPercent vw-progressbar-percentage"></div></div>
	<div class="progressDetails vw-progress-details">
		<table class="progressDetailsTable">
			<tr>
				<td><fmt:message key="currentStatus.label.dataProtected" /></td>
				<td></td>
			</tr>
			<tr>
				<td><fmt:message key="currentStatus.label.timeStarted" /></td>
				<td></td>
			</tr>
			<tr>
				<td><fmt:message key="currentStatus.label.timeElapsed" /></td>
				<td></td>
			</tr>
		</table>
	</div>
	<div class="actionsBackup vw-operation-status">
		<c:set var="capabilityClass" value="actionButtons visibilityHidden vw-invisible" />
		<cv:ifCapability name="manageOperations" appType="${param.apptype}"  clientName="${param.clientName}" clientId="${param.clientId}">
			<c:set var="capabilityClass" value="actionButtons" />
		</cv:ifCapability>
		<span class="${capabilityClass}">
			<span class="dropdownOpener vw-drop-down-toggle backupActions" id="pauseResume" data-state="0" data-url="/clientDetails/pauseTimeMenu.jsp" role="button" tabindex="0" aria-haspopup="true" aria-expanded="false" aria-controls="pauseTimeMenu">
				<span class="vw-text"><fmt:message key="currentStatus.action.pause" /></span> <span class="sprite icon-arrow-dropdown" alt="^" aria-hidden="true" role="presentation"></span>
				<span class="dropdown vw-drop-down"></span>
			</span><c:set var="hideKillOption" value="${cv:getConfigPropertyForKey('hideJobsKillOption')}"/><c:if test="${hideKillOption == 'false'}">|
			<a class="backupActions" id="kill" data-state="2" role="button" tabindex="0"><span class="vw-text"><fmt:message key="currentStatus.action.kill" /></span></a>
			</c:if>
		</span>

		<label id="backupJobCompleted" class="vw-job-status vw-job-completed vw-start-hidden"><fmt:message key="currentStatus.label.jobCompleted" /></label>
		<label id="backupJobKilled" class="vw-job-status vw-job-killed vw-start-hidden"><fmt:message key="currentStatus.label.jobKilled" /></label>
		<label id="backupJobKillPending" class="vw-job-status vw-job-kill-pending vw-start-hidden"><fmt:message key="currentStatus.label.killPending" /></label>
		<label id="backupJobSuspendPending" class="vw-job-status vw-job-suspend-pending vw-start-hidden"><fmt:message key="clientDetails.param.suspendPending" /></label>
		<label id="backupJobPaused" class="vw-job-status vw-job-paused vw-start-hidden"><fmt:message key="currentStatus.label.jobPaused" /></label>
		<label id="backupJobPending" class="vw-job-status vw-job-pending vw-start-hidden"><fmt:message key="currentStatus.label.jobPending" /></label>
		<label id="backupJobWaiting" class="vw-job-status vw-job-waiting vw-start-hidden"><fmt:message key="currentStatus.label.jobWaiting" /></label>
		<label id="backupJobFailed" class="vw-job-status vw-job-failed vw-start-hidden"><fmt:message key="currentStatus.label.jobFailed" /></label>
	</div>
</div>
</fmt:bundle>