<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="content.path.desktop" var="desktopText" />
	<fmt:message key="content.path.documents" var="documentsText" />
	<fmt:message key="content.path.music" var="musicText" />
	<fmt:message key="content.path.videos" var="videosText" />
	<fmt:message key="content.path.pictures" var="picturesText" />
	<fmt:message key="content.label.contentLibrary" var="contentLibraryText" />
	<fmt:message key="content.path.Libraries" var="librariesText" />
</fmt:bundle>
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="content.label.browseContent" var="browseContentLocalized" />
	<fmt:message key="clientDetails.param.enterPathYouWishToAdd" var="enterPathYouWishToAddLocalized" />
	<fmt:message key="clientDetails.param.path" var="pathLocalized" />
	<fmt:message key="clientDetails.param.addPath" var="addPathLocalized" />
	<fmt:message key="clientDetails.param.cancel" var="cancelLocalized" />
	<fmt:message key="clientDetails.title.addNewPaths" var="addNewPathsLocalized" />
	<fmt:message key="dialogParams.param.revertAction" var="revertActionLocalized" />
	<fmt:message key="dialogParams.action.yes" var="yesLocalized" />
	<fmt:message key="dialogParams.action.no" var="noLocalized" />
	<fmt:message key="dialogParams.action.close" var="closeLocalized" />
	<fmt:message key="dialogParams.param.error" var="errorLocalized" />
	<fmt:message key="dialogParams.param.pleaseEnterAValidPath" var="pleaseEnterAValidPathLocalized" />
	<fmt:message key="dialogParams.param.pathExists" var="pathExistsLocalized" />
	<fmt:message key="dialogParams.param.confirmation" var="confirmationLocalized" />
	<fmt:message key="dialogParams.param.deleteAdminContent" var="deleteAdminContentLocalized" />
	<fmt:message key="content.error.globalFilters" var="globalFiltersLocalized" />
	<fmt:message key="content.label.contentLibrary" var="contentLibraryLocalized" />
	<fmt:message key="content.label.browseToolTip" var="browseToolTip" />
	<fmt:message key="content.label.addToolTip" var="addToolTip" />
	<fmt:message key="content.label.deleteToolTip" var="deleteToolTip" />
	<fmt:message key="content.label.lockToolTip" var="lockToolTip" />
	<fmt:message key="content.label.isLockedToolTip" var="isLockedToolTip" />
	<fmt:message key="content.label.isNotLockedToolTip" var="isNotLockedToolTip" />
	<fmt:message key="content.error.dlpContentLibraryError" var="dlpContentLibraryError" />
	<fmt:message key="content.error.dlpWildCardError" var="dlpWildCardError" />
	<fmt:message key="content.error.pathAddEmpty" var="pathAddEmptyError" />
	<fmt:message key="content.error.pathAddMoniker" var="pathAddMonikerError" />
	<fmt:message key="content.error.pathAddInvalid" var="pathAddInvalidError" />
	<fmt:message key="content.error.pathAddALreadyExists" var="pathAddALreadyExistsError" />
	<fmt:message key="clientDetails.label.canotEditDLPAsStolenError" var="canotEditDLPAsStolenError" />
	<fmt:message key="content.error.genericError" var="genericError" />
	<fmt:message key="clientDetails.label.confirmText" var="confirmText"/>
	<fmt:message key="clientDetails.label.confirmTextError" var="confirmTextError"/>
	<fmt:message key="content.label.eraseContentWarning" var="eraseContentWarning"/>
	<fmt:message key="content.label.eraseButtonConfirmText" var="eraseButtonConfirmText"/>
	<fmt:message key="content.label.dlpLockingInfo" var="dlpLockingInfo" />
	<fmt:message key="dialogParams.param.confirmation" var="confirmationText" />
	<fmt:message key="dialogParams.param.cannotDeletePolicyContent" var="cannotDeletePolicyContent"/>
	<fmt:message key="dialogParams.param.errorDeletingContent" var="errorDeletingContent"/>


	<fmt:message key="fsBackupBrowse.title.page" var="pageTitle" />
	<fmt:message key="fsBackupBrowse.title.header" var="headerTitle" />

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../clientDetails/css/content.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="../common/js/logUtil.js" name="js" />
		<jsp:param value="../clientDetails/js/content.js" name="js" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
	</jsp:include>

	<c:set var="client" value="${requestScope.CLIENT_DETAIL}" />
    <style>
    #content{
	    background-color: white;
		border: 0px;
		box-shadow: 0px 0px;
		padding: 0px;
		font-size: 1.1em;
	}
	.AddLookupDeleteOptions{
		cursor: pointer;
		display:none;
	}
	#dlpEnableDiv, #dlpMarkStolenDiv{
		font-size: 0.85em;
		padding: 10px 0 0 0;
		margin-left: -3px;
		font-weight: bold;
		color: #444;
	}

	.btns #ajaxBusy{
		padding-right: 5px;
		vertical-align: text-bottom;
		display:none;
	}
	.selected {
	    background: lightBlue
	}
	.dlpBlock{
		cursor: pointer;
		float: right;
		height: 16px;
		width: 20px;
		display:none;
	}
	.headerTable tr{
		background-color:#ececec;
	}
	#content .editMode thead tr th:first-child {
		display:block;
	}
	body #content .editMode tr td{
		display:table-cell;
	}
	#content .editMode .editButton, #content .doneButton{
		display:none;
	}
	#content .editButton, #content .editMode .doneButton{
		display:block;
	}
	#content .editModeButton{
		cursor:pointer;
		padding:3px
	}
	.editModeButton div{
		padding: 2px 13px 2px 13px;
		border: 1px solid #ddd;
		margin-right: 3px;
		color: #1B6DAD;
		background-color: #fff;
	}
	.editModeButton div:hover{
		border: 1px solid #cecece;
		background-color: #eee;
	}
	.doneButton div{
		color: #eee;
		background-color: #498BF4;
	}
	.doneButton div:hover{
		background-color: #5793ea;
		color:#eee;
	}
	.errorZone{
		color:red;
		float:left;
		font-size: 0.8em;
	}
	#content tr td:first-child{
		padding: 3px 0px 3px 3px;
		display:none;
	}
	#content thead tr th:first-child {
		padding: 3px 0px 3px 3px;
		display:none;
	}
	.editMode .AddLookupDeleteOptions{
		display:block;
	}
	#content .tableHeading{
		padding-left:5px
	}

	body .btns a.leftButton {
		float: left;
		margin-left: 9px;
		background: #767676;
		border: 1px solid #686868;
		color: #fff;
	}
	body .btns a.leftButton:hover{
		background: #676767;
		border: 1px solid #454545;
	}
	.btns a {
		float: right;
		margin-left: 3px;
	}
	.btns {
		left: 0px;
	}
</style>

<c:if test="${requestScope.mode == 'DLP_CONTENT_MODE'}">
    <style>
    #content .dlpBlock{
		display: inline-table;
    }

    #content-table-id tr td .sprite.icon-unlocked {
        display: inline-block;
    }
    #content-table-id tr.isDLPLocked td .sprite.icon-unlocked {
        display: none;
    }
    #content-table-id tr td .sprite.icon-locked {
        display: none;
    }
    #content-table-id tr.isDLPLocked td .sprite.icon-locked {
        display: inline-block;
    }
	.imgPlaceHolder {
		display: inline-block;
		margin-right: 5px;
		height: 15px;
		width: 15px;
		vertical-align: bottom;
		cursor:pointer;
	}
	</style>
</c:if>

    <body>

    <c:set var="showExcludeOptionsForEdit" value="true"/>
	<c:if test="${sessionScope.ADDITIONAL_SETTINGS_MAP['Console']['hideEditExcludeContent'] eq true}">
		<c:set var="showExcludeOptionsForEdit" value="false"/>
	</c:if>

	<div id="boxes" align="center" >
			<div id="dialog"  class="window">
				<div class="includesExcludesContent editMode">
			 		<table class="headerTable">
						<thead>
							<tr>
								<th><div class='custom-cb unchecked allSelectorCB' data-state='unchecked' aria-checked="false" tabindex="0" aria-label="<fmt:message key='content.ariaLabel.contentToBackup' />" role="checkbox"></div></th>
								<c:choose>
									<c:when test="${requestScope.mode == 'DLP_CONTENT_MODE'}">
										<th scope="col" width="400" class="tableHeading"><fmt:message key="content.label.contentToBackupLock" /></th>
									</c:when>
									<c:when test="${requestScope.mode == 'BACKUP_CONTENT_MODE'}">
										<th scope="col" width="400" class="tableHeading"><fmt:message key="content.label.contentToBackup" /></th>
									</c:when>
									<c:when test="${requestScope.mode == 'SECURE_ERASE_MODE'}">
										<th scope="col" width="400" class="tableHeading"><fmt:message key="content.label.contentToSecureErase" /></th>
									</c:when>
								</c:choose>

								<th scope="col">
									<span class="sprite icon-content-browse AddLookupDeleteOptions" id="contentsLookup" title="${browseToolTip}" aria-label="${browseToolTip}" role="button" tabindex="0"></span>
								</th>

								<th scope="col">
								    <span class="sprite icon-content-delete AddLookupDeleteOptions disabled deleteLink" data-table-id="content-table-id" title="${deleteToolTip}" aria-label="${deleteToolTip}" role="button" tabindex="-1" aria-disabled="true"></span>
								</th>
							</tr>
						</thead>
					</table>

					<c:if test="${!requestScope.isPolicyContentOverrideEnabled}">
						<c:set var="policyClassname" value="noOverridePolicy"/>
					</c:if>
					<div class="content-table">
						<table id="content-table-id">
							<thead class="table-header hidden"><tr><td><td><span class="header-label" role="button" tabindex="0"><fmt:message key="content.label.enterCustompath" /></span><span class="header-input hidden"><input type="text" class="content-custom-path" data-table-id="content-table-id"/></span></td></tr></thead>
							<tbody>
								<c:if test="${requestScope.mode == 'BACKUP_CONTENT_MODE' || requestScope.mode == 'SECURE_ERASE_MODE'}">
								<c:forEach var="item" items="${requestScope.POLICY_CONTENT_LIST}">
									<tr id='policyContentList' class='policyContentListClass ${policyClassname}' data-Value='${item.internalName}'>
										<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
										<td scope='row' width='456'><div class="displayNameClass">${item.displayName}</div></td>
									</tr>
								</c:forEach>

								<c:forEach var="item" items="${requestScope.LOCAL_CONTENT_LIST}">
									<tr id='localContentList' class='localContentListClass' data-Value='${item.internalName}'>
										<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
										<td scope='row' width='456'><div class="displayNameClass">${item.displayName}</div></td>
									</tr>
								</c:forEach>
								</c:if>
								<c:if test="${requestScope.mode == 'DLP_CONTENT_MODE' || requestScope.mode == 'SECURE_ERASE_MODE'}">
									<c:forEach var="item" items="${requestScope.LOCAL_LOCK_CONTENT_LIST}">
										<tr id='localContentList' class='localContentListClass' data-Value='${item.internalName}'>
											<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
											<td scope='row' width='456'><div class="displayNameClass">${item.displayName}</div></td>
										</tr>
									</c:forEach>
								</c:if>
							</tbody>
						</table>
					</div>
				</div>

				<c:choose>
					<c:when test="${requestScope.mode == 'BACKUP_CONTENT_MODE' || requestScope.mode == 'SECURE_ERASE_MODE'}">
						<br/>
						<div class="includesExcludesContent editMode">

							<table class="headerTable">
								<thead>
									<tr>
										<c:if test="${showExcludeOptionsForEdit}">
											<th><div class='custom-cb unchecked allSelectorCB' data-state='unchecked' aria-checked="false" tabindex="0" aria-label="<fmt:message key='content.ariaLabel.doNotBackupFile' />" role="checkbox"></div></th>
										</c:if>
										<c:choose>
											<c:when test="${requestScope.mode == 'BACKUP_CONTENT_MODE'}">
												<th scope="col" width="400" class="tableHeading" id="excludeTableHeader"><fmt:message key="content.label.doNotBackupFile" /></th>
											</c:when>
											<c:when test="${requestScope.mode == 'SECURE_ERASE_MODE'}">
													<th scope="col" width="400" class="tableHeading" id="excludeTableHeader"><fmt:message key="content.label.doNotSecureEraseFile" /></th>
											</c:when>
										</c:choose>
										<c:if test="${showExcludeOptionsForEdit}">
											<th scope="col">
											   <span class="sprite icon-content-browse AddLookupDeleteOptions" id="excludesLookup" title="${browseToolTip}" aria-label="${browseToolTip}" role="button" tabindex="0"></span>
											</th>
											<th scope="col">
											    <span class="sprite icon-content-delete AddLookupDeleteOptions disabled deleteLink" data-table-id="exclude-table-id" title="${deleteToolTip}" aria-label="${deleteToolTip}" role="button" tabindex="-1" aria-disabled="true"></span>
											</th>
										</c:if>
										</tr>
								</thead>
							</table>

							<div class="exclude-table">
								<table id="exclude-table-id">
									<c:if test="${showExcludeOptionsForEdit}">
										<thead class="table-header hidden"><tr><td><td><span class="header-label" role="button" tabindex="0"><fmt:message key="content.label.enterCustompath" /></span><span class="header-input hidden"><input type="text" class="content-custom-path" data-table-id="exclude-table-id"/></span></td></tr></thead>
									</c:if>
									<tbody>
									<c:forEach var="item" items="${requestScope.GLOBAL_EXCLUDE_LIST}">
										<tr id='policyContentList' class='policyContentListClass globalContents' data-Value='${item.internalName}'>
											<c:if test="${showExcludeOptionsForEdit}">
												<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
											</c:if>
											<td scope='row' width='456'>${item.displayName}</td>
										</tr>
									</c:forEach>

									<c:forEach var="item" items="${requestScope.POLICY_EXCLUDE_LIST}">
										<tr id='policyContentList' class='policyContentListClass ${policyClassname}' data-Value='${item.internalName}'>
											<c:if test="${showExcludeOptionsForEdit}">
												<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
											</c:if>
											<td scope='row' width='456'>${item.displayName}</td>
										</tr>
									</c:forEach>


									<c:forEach var="item" items="${requestScope.LOCAL_EXCLUDE_LIST}">
										<tr id='localContentList' class='localContentListClass' data-Value='${item.internalName}'>
											<c:if test="${showExcludeOptionsForEdit}">
												<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
											</c:if>
											<td scope='row' width='456'>${item.displayName}</td>
										</tr>
									</c:forEach>
									</tbody>
								</table>
							</div>
										</div>
				</c:when>
				<c:when test="${requestScope.mode == 'DLP_CONTENT_MODE'}">
					<br/>
					<div class="includesExcludesContent editMode">
						<table class="headerTable">
							<thead>
								<tr>
									<th><div class='custom-cb unchecked allSelectorCB' data-state='unchecked' aria-checked="false" tabindex="0" aria-labelledby="doNotLockTableHeader" role="checkbox"></div></th>
									<th scope="col" width="400" class="tableHeading" id="doNotLockTableHeader"><fmt:message key="content.label.doNotLockFile" /></th>

									<c:choose>
										<c:when test="${!requestScope.CLIENT_MARKED_STOLEN && showExcludeOptionsForEdit}">
											<th scope="col">
												<span class="sprite icon-content-browse AddLookupDeleteOptions" id="excludesLockLookup" title="${browseToolTip}" aria-label="${browseToolTip}" role="button" tabindex="0"></span>
											</th>
											<th scope="col">
											   <span class="sprite icon-content-delete AddLookupDeleteOptions disabled deleteLink" data-table-id="exclude-lock-table-id" title="${deleteToolTip}" aria-label="${deleteToolTip}" role="button" tabindex="-1" aria-disabled="true"></span>
											</th>
										</c:when>
										<c:otherwise>
										</c:otherwise>
									</c:choose>

								</tr>
							</thead>
						</table>


						<div class="exclude-lock-table">
							<table id="exclude-lock-table-id">
								<c:if test="${showExcludeOptionsForEdit}">
									<thead class="table-header hidden"><tr><td><td><span class="header-label" role="button" tabindex="0"><fmt:message key="content.label.enterCustompath" /></span><span class="header-input hidden"><input type="text"  class="content-custom-path" data-table-id="exclude-lock-table-id"/></span></td></tr></thead>
								</c:if>
								<tbody>
									<c:forEach var="item" items="${requestScope.LOCAL_LOCK_EXCLUDES_LIST}">
										<tr id='localContentList' class='localContentListClass' data-Value='${fn:escapeXml(item.internalName)}'>
											<c:if test="${showExcludeOptionsForEdit}">
												<td><div class='custom-cb unchecked' data-state='unchecked' data-name='contentsCV' aria-checked="false" tabindex="0" aria-label="${item.displayName}" role="checkbox"></div></td>
											</c:if>
											<td scope='row' width='456'>${item.displayName}</td>
										</tr>
									</c:forEach>
								</tbody>
							</table>
						</div>
						<c:if test="${showExcludeOptionsForEdit}">
							<div class="div-footer hidden"  onclick="addRow('exclude-lock-table-id')"><fmt:message key="content.label.enterCustompath" /></div>
						</c:if>
					</div>
				</c:when>
			</c:choose>

			<c:if test="${requestScope.mode == 'SECURE_ERASE_MODE'}">
				<div id="deleteAllDiv"><div class="custom-cb unchecked" data-state="unchecked" aria-checked="false" tabindex="0" aria-labelledby="eraseAllData-label" role="checkbox"></div><div id="eraseAllData-label" class="custom-cb-label"><fmt:message key="content.label.eraseAllData" /></div></div>
			</c:if>

			<div class="errorZone">
				<fieldset>
				   <div class="pathEmptyError errorClass text-danger hidden">${pathAddEmptyError}</div>
				   <div class="pathWildMonikerError errorClass text-danger hidden">${pathAddMonikerError}</div>
				   <div class="invalidPath errorClass hidden text-danger hidden">${pathAddInvalidError}</div>
				   <div class="pathAlreadyExistsError errorClass text-danger hidden">${pathAddALreadyExistsError}</div>
			   </fieldset>
			</div>
			</div>

		</div>

    	<fmt:bundle basename="localization.messages">
			<div class="btns">
				<a id="revertButton" class="disabledButton leftButton vw-btn vw-btn-default" role="button" tabindex="-1" aria-disabled="true"><fmt:message key="common.action.revert" /></a>
				<a id="saveButton" class="okSaveButton mainBtn vw-btn vw-btn-primary" role="button" tabindex="0">
					<c:choose>
						<c:when test="${requestScope.mode == 'SECURE_ERASE_MODE'}">
							<fmt:bundle basename="localization.ClientDetailsMessages">
								<fmt:message key="content.button.eraseNow" />
							</fmt:bundle>
						</c:when>
						<c:otherwise>
							<fmt:message key="common.action.save" />
						</c:otherwise>
					</c:choose>
				</a>
				<a id="cancelButton" class="vw-btn vw-btn-default" role="button" tabindex="0"><fmt:message key="common.action.cancel" /></a>
				<img src="../login/img/spinner.gif" id="ajaxBusy" alt="" role="progressbar">
			</div>
		</fmt:bundle>
	</body>
</fmt:bundle>
<input type="hidden" id="request-mode" value="${fn:escapeXml(requestScope.mode)}" />
<input type="hidden" id="request-isSecureEraseEnabledOnClient" value="${fn:escapeXml(requestScope.IS_SECURE_ERASE_ENABLED_ON_CLIENT)}" />
<input type="hidden" id="request-isDLPStolen" value="${fn:escapeXml(requestScope.CLIENT_MARKED_STOLEN)}" />
<input type="hidden" id="request-delim" value="${fn:escapeXml(requestScope.OS_DELIM)}" />
<input type="hidden" id="request-clientName" value="${fn:escapeXml(client.clientName)}" />

<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
localMsg.contentLibraryText = "${contentLibraryText}";
localMsg.desktopText = "${desktopText}";
localMsg.documentsText = "${documentsText}";
localMsg.musicText = "${musicText}";
localMsg.videosText = "${videosText}";
localMsg.picturesText = "${picturesText}";
localMsg.librariesText= "${librariesText}";

var enterPathYouWishToAddLocalized = "${enterPathYouWishToAddLocalized}";
var pathLocalized = "${pathLocalized}";
var addPathLocalized = "${addPathLocalized}";
var cancelLocalized= "${cancelLocalized}";
var addNewPathsLocalized="${addNewPathsLocalized}";
var revertActionLocalized = "${revertActionLocalized}";
var yesLocalized = "${yesLocalized}";
var noLocalized = "${noLocalized}";
var closeLocalized = "${closeLocalized}";
var errorLocalized = "${errorLocalized}";
var pleaseEnterAValidPathLocalized = "${pleaseEnterAValidPathLocalized}";
var pathExistsLocalized = "${pathExistsLocalized}";
var confirmationLocalized="${confirmationLocalized}";
var clientName = $("#request-clientName").prop("value");
var clientId = "${client.clientId}"; // !!! NAMESPACE - unused global in content.js? delete this if so!
var globalFiltersLocalized = "${globalFiltersLocalized}";
var contentLibraryLocalized = "${contentLibraryLocalized}";
var contentTrs = null;
var contentTrs = $('#content-table-id tr');
var excludeTrs = $('#exclude-table-id tr');
var excludeLockTrs = $('#exclude-lock-table-id tr');
var originalContentsDLP = new Array();
var originalCountDLP = 0;
var mode = $("#request-mode").prop("value");
var isSecureEraseEnabledOnClient = $("#request-isSecureEraseEnabledOnClient").prop("value");
var showConfirmationForDLP = (${requestScope.mode == 'DLP_CONTENT_MODE'} && $("#content-table-id tbody tr").length == 0);

var contentMode = {
		BACKUP_CONTENT_MODE : "BACKUP_CONTENT_MODE",
		DLP_CONTENT_MODE : "DLP_CONTENT_MODE",
		SECURE_ERASE_MODE : "SECURE_ERASE_MODE"
};

var isDLPStolen = false;
if(mode == contentMode.DLP_CONTENT_MODE) {
	isDLPStolen = $("#request-isDLPStolen").prop("value");
}

<%-- Add remote CommCell details, if present. --%>
if (typeof cvUtil == "object")
{
	cvUtil.ccId = "${requestScope._cid}";
	cvUtil.ccName = "${requestScope._cn}";
}


localMsg.executable = "\\%Executable%";
localMsg.system = "\\%System%";
localMsg.isNotLockedToolTip = "${isNotLockedToolTip}";
localMsg.isLockedToolTip = "${isLockedToolTip}";
localMsg.dlpContentLibraryError = "${dlpContentLibraryError}";
localMsg.dlpWildCardError = "${dlpWildCardError}";
localMsg.pathAddEmptyError = "${pathAddEmptyError}";
localMsg.pathAddMonikerError = "${pathAddMonikerError}";
localMsg.pathAddInvalidError = "${pathAddInvalidError}";
localMsg.pathAddALreadyExistsError = "${pathAddALreadyExistsError}";
localMsg.canotEditDLPAsStolenError = "${canotEditDLPAsStolenError}";
localMsg.genericError = "${genericError}";
<enhance:out escapeXml="false">
var deleteAdminContentLocalized = "${deleteAdminContentLocalized}";
localMsg.confirmText = "${confirmText}";
localMsg.confirmTextError = "${confirmTextError}";
localMsg.eraseContentWarning = "${eraseContentWarning}";
localMsg.eraseButtonConfirmText = "${eraseButtonConfirmText}";
</enhance:out>
localMsg.dlpLockingInfo = "${dlpLockingInfo}";
localMsg.confirmationText = "${confirmationText}";
localMsg.cannotDeletePolicyContent = "${cannotDeletePolicyContent}";
localMsg.errorDeletingContent = "${errorDeletingContent}";

var delim = $("#request-delim").prop("value");
if(delim == "\\\\") {
	delim = "\\";
}

$("#contentsLookup").click(function(){
	loadLookupWindow("content-table-id");
});
$("#excludesLookup").click(function(){
	loadLookupWindow("exclude-table-id");
});
$("#excludesLockLookup").click(function(){
	loadLookupWindow("exclude-lock-table-id");
});
$(".editButton div").click(function(){
	$(this).parents(".includesExcludesContent").addClass("editMode");
});
$(".doneButton div").click(function(){
	$(this).parents(".includesExcludesContent").removeClass("editMode");
	$(".errorZone").text("");
});
function isMonikerText(str) {

	if (delim == "\\") {
		var stringF = str.trim().toUpperCase();
		if (stringF == localMsg.desktopText.toUpperCase() ||
				stringF == localMsg.documentsText.toUpperCase() ||
				stringF == localMsg.musicText.toUpperCase() ||
				stringF == localMsg.videosText.toUpperCase() ||
				stringF == localMsg.picturesText.toUpperCase() || stringF == localMsg.contentLibraryText.toUpperCase() || stringF == localMsg.librariesText.toUpperCase()) {
			return true;
		}
	} else {
		var stringF = str.trim();
		if (stringF == localMsg.desktopText || stringF == localMsg.documentsText || stringF == localMsg.musicText || stringF == localMsg.videosText ||
				stringF == localMsg.picturesText  || stringF == localMsg.contentLibraryText  || stringF == localMsg.librariesText) {
			return true;
		}
	}
	return false;
}

function isMoniker(strPath) {
	return (strPath.match(/%(.*?)%/) && strPath.match(/%(.*?)%/).length > 0)
}
function addDelim(str) {
	if (!isMoniker(str)) {
		if (isMonikerText(str)) {
			str = "%" + str + "%";
		} else if (str.substr(str.length - 1) != delim) {
			str = str + delim;
		}
	}
	return str;
}
function getData(){
	return null;
}

function addValue(e,list){
	var val = $(e).attr('data-Value')
	if($(e).attr('data-New'))
		val = unescape($(e).attr("data-Value"));

	list.push(addDelim(val));
	return val;
}
function getBackupList() {
	var backupList = [];
	var list = $("#content-table-id .localContentListClass,#content-table-id .policyContentListClass");
	$(list).each(function() {
		var val=addValue(this,backupList);

	});
	return backupList;
}
function getExcludeList() {
	var excludeList = [];
	var list = $("#exclude-table-id .localContentListClass,#exclude-table-id .policyContentListClass");
	$(list).each(function() {
		addValue(this,excludeList)
	});
	return excludeList;
}
function loadLookupWindow(tableId){
	sessionStorage.setItem('backupList', getBackupList());
	sessionStorage.setItem('excludeList', getExcludeList());
	var encodedClientName = encodeURIComponent('${client.clientName}');
	cvUtil.showModal({href: "doFsMachineBrowseMain.do?clientName="+encodedClientName+"&clientId=${client.clientId}&showMonikerMode=true&multiSelMode=true",
		iframe:true, width:740, height:475,  title:"${browseContentLocalized}"},null,function(res){
			handleBrowseResponse(res, tableId);
		}, "MULTIPLE_SELECTION_MODE,NORMAL_BROWSE_MODE");
}
repaintTable();

</script>