	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
	<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
	<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>
	<c:set var="jobTypeKey" value="alljobs.title" />

	<c:if test="${param.type == 'restore'}">
		<c:set var="jobTypeKey" value="restorejobs.title" />
	</c:if>
	<c:if test="${param.type == 'backup'}">
		<c:set var="jobTypeKey" value="backupjobs.title" />
	</c:if>
	<c:set var="clientIdEscaped" value="${fn:escapeXml(param.clientId)}" />
	<enhance:out escapeXml="false">
		<c:set var="clientNameEscaped" value="${(requestScope.clientName)}" />
	</enhance:out>

<%-- Construct URL parameter string with remote CommCell details. --%>
<c:set var="ccParams" value="" scope="request" />
<c:if test="${requestScope._cid != null}">
	<c:set var="ccParams" value="${requestScope.ccParams}&_cid=${requestScope._cid}" scope="request" />
</c:if>
<c:if test="${requestScope._cn != null}">
	<c:set var="ccParams" value="${requestScope.ccParams}&_cn=${requestScope._cn}" scope="request" />
</c:if>

<c:if test="${param.adminMode == true}">
	<c:set var="adminModeParam" value="&adminMode=true" scope="request" />
</c:if>

	<f:message key="${jobTypeKey}" var="jobTypeVal" />
	<f:message key="Client_Recent_Jobs" var="title">
		<f:param value="${jobTypeVal}" />
		<f:param value="${clientNameEscaped}" />
	</f:message>
		<c:if test="${cv:isVMImageBrowse(param.applicationId)}">
			<c:url var="initialURL" value="vmprovisioning/vmDetails.do">
				<c:param name="source" value="${fn:escapeXml(param.source)}"></c:param>
				<c:param name="clientName" value="${clientNameEscaped}"></c:param>
			</c:url>
		</c:if>
		<c:if test="${not cv:isVMImageBrowse(param.applicationId)}">
			<c:url var="initialURL" value="clientDetails/${requestScope.DETAILS_PAGE}">
				<c:param name="clientId" value="${clientIdEscaped}"></c:param>
				<c:param name="clientName" value="${clientNameEscaped}"></c:param>
			</c:url>
		</c:if>
		<c:set var="applicationUrl" value="${initialURL}${ccParams}${adminModeParam}" />

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="myDataNav.jsp" name="navPage" />
		<jsp:param value="Client_Jobs" name="title" />
		<jsp:param value="${title}" name="headerTitleLocalized" />
		<jsp:param value="${applicationUrl}" name="breadCrumbValue" />
		<jsp:param value="${clientNameEscaped}" name="breadCrumbName"/>
	</jsp:include>
	<jsp:include page="../jobs/jobList.jsp">
		<jsp:param value="${clientIdEscaped}" name="clientId"/>
		<jsp:param value="${clientNameEscaped}" name="clientName"/>
		<jsp:param value="true" name="bootstrapped" />
	</jsp:include>
<!-- 	<div
	<ul id="runningJobActions">
		<li><a href="#" class="pause">Pause</a></li>
		<li><a href="#" class="pause">Kill</a></li>
	</ul>
	<ul id="pausedJobActions">
		<li><a href="#" class="pause">Resume</a></li>
		<li><a href="#" class="pause">Kill</a></li>
	</ul> -->
	<jsp:include page="../common/footer.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="../common/js/moment.js" name="js" />
	</jsp:include>