<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<fmt:message key="common.label.earlyRelease" var="earlyRelease" />

<fmt:bundle basename="localization.ScheduleMessages">
	<fmt:message key="addSchedule.title.page" var="addScheduleTitle" />
	<fmt:message key="viewSchedule.title.page" var="viewScheduleTitle" />
	<fmt:message key="editSchedule.title.page" var="editScheduleTitle" />
</fmt:bundle>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.selectSyncProfileTitle" var="selectSyncProfileTitle"/>
	<fmt:message key="privacy.label.authorizeForRestore" var="authorizeForRestoreDialogTitle"/>
</fmt:bundle>
<fmt:bundle basename="localization.messages">
	<fmt:message key="date.NotAvailable" var="dateNotAvailable" />
	<fmt:message key="not.scheduled" var="notScheduled" />
</fmt:bundle>
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="clientDetails.label.dataProtection" var="dataProtectionTitle" />
	<fmt:message key="clientDetails.label.dataRecovery" var="dataRecoveryTitle" />
	<fmt:message key="clientDetails.param.paused" var="pausedLocalized" />
	<fmt:message key="clientDetails.param.resume" var="resumeLocalized" />
	<fmt:message key="clientDetails.param.pause" var="pauseLocalized" />
	<fmt:message key="clientDetails.param.resume1" var="resume1Localized" />
	<fmt:message key="clientDetails.param.running" var="runningLocalized" />
	<fmt:message key="clientDetails.param.killed" var="killedLocalized" />
	<fmt:message key="clientDetails.param.killPending" var="killPendingLocalized" />
	<fmt:message key="clientDetails.param.suspendPending" var="suspendPendingLocalized" />
	<fmt:message key="clientDetails.param.pending" var="pendingLocalized" />
	<fmt:message key="clientDetails.param.completed" var="completedLocalized" />
	<fmt:message key="clientDetails.param.completedWithErrors" var="completedWithErrorsLocalized" />
	<fmt:message key="clientDetails.param.failedToStart" var="failedToStartLocalized" />
	<fmt:message key="clientDetails.param.backup" var="backupLocalized" />
	<fmt:message key="clientDetails.param.restore" var="restoreLocalized" />
	<fmt:message key="clientDetails.param.alertsWarning" var="alertsWarning" />
	<fmt:message key="clientDetails.param.alertsToolTip" var="alertsToolTip" />
	<fmt:message key="clientDetails.param.jobIdText" var="jobIdText" />
	<fmt:message key="clientDetails.param.noBytesSize" var="noBytesSize" />
	<fmt:message key="clientDetails.param.nothingToBackup" var="nothingToBackup" />
	<fmt:message key="clientDetails.param.filesText" var="filesText" />
	<fmt:message key="content.label.manageContent" var="manageContent" />
	<fmt:message key="clientDetails.label.myBackups" var="myBackups" />
	<fmt:message key="clientDetails.success.userProfile" var="userProfileSuccessText" />
	<fmt:message key="clientDetails.failure.userProfile" var="userProfileFailureText" />
	<fmt:message key="clientDetails.label.alertsSaved" var="alertSaved"/>
	<fmt:message key="clientDetails.error.startBackups" var="startBackupsText"/>
	<fmt:message key="clientlock.label.setPasskey" var="setPasskey"/>
	<fmt:message key="clientlock.label.passKey" var="passKey"/>
	<fmt:message key="clientDetails.label.backupLockContentTitle" var="backupLockContentTitle"/>
	<fmt:message key="clientDetails.label.backupContentTitle" var="backupContentTitle"/>
	<fmt:message key="clientDetails.label.secureEraseTileTitle" var="secureEraseTileTitle" />
	<fmt:message key="clientDetails.label.secureEraseContentTitle" var="secureEraseContentTitle"/>
	<fmt:message key="clientDetails.label.confirmMarkStolenText" var="confirmMarkStolenText"/>
	<fmt:message key="clientDetails.label.confirmMarkFoundText" var="confirmMarkFoundText"/>
	<fmt:message key="clientDetails.label.markStolenTitleDialog" var="markStolenTitleDialog"/>
	<fmt:message key="clientDetails.label.markFoundTitleDialog" var="markFoundTitleDialog"/>
	<fmt:message key="clientDetails.label.markStolenConfirmText" var="markStolenConfirmText"/>
	<fmt:message key="clientDetails.label.confirmText" var="confirmText"/>
	<fmt:message key="clientDetails.label.confirmTextError" var="confirmTextError"/>
	<fmt:message key="clientDetails.label.clientNameChanged" var="clientNameChanged"/>
	<fmt:message key="clientDetails.label.clientNameChangeFailed" var="clientNameChangeFailed"/>
	<fmt:message key="clientDetails.label.clientNameValidationFailed" var="clientNameValidationFailed"/>
	<fmt:message key="clientDetails.label.markLostError" var="markLostError"/>
	<fmt:message key="clientDetails.label.untitledClient" var="untitledClient" />
	<fmt:message key="clientlock.dialog.adminDisabledNote" var="adminDisabledNote" />
	<fmt:message key="clientDetails.title.myComputers" var="myComputers" />
    <fmt:message key="clientDetails.label.autoResumeTitle" var="autoResumeTitle"/>

    <fmt:message key="clientDetails.archivingDialog.text" var="archivingDialogText"/>
	<fmt:message key="clientDetails.archivingDialog.title" var="archivingDialogTitle"/>
	<fmt:message key="clientDetails.error.archivingError" var="archivingError"/>
	<fmt:message key="clientDetails.error.archivingCheckCheckbox" var="archivingCheckCheckbox"/>
	<fmt:message key="clientDetails.label.archivingAccept" var="archivingOkButton"/>
	<fmt:message key="clientDetails.label.archivingReject" var="archivingCancelButton"/>
	<fmt:message key="clientDetails.label.archivingInfo" var="archivingInfo"/>
	<fmt:message key="clientDetials.label.agree" var="iAgree"/>
	<fmt:message key="clientlock.dialog.title" var="clientlockDialogTitle"/>
	<fmt:message key="clientlock.dialog.subtitle" var="clientlockDialogSubTitle"/>
	<fmt:message key="clientDetails.param.okay" var="okButton"/>
	<fmt:message key="clientDetails.param.cancel" var="cancelButton"/>
	<fmt:message key="clientlock.dialog.error" var="passwordError" />

	<fmt:message key="disableBackups.label" var="disableBackupsLabel" />
	<fmt:message key="deleteBackups.label" var="deleteBackupsLabel" />
	<fmt:message key="disableBackups.message" var="disableBackupsMessage" />
	<fmt:message key="deleteBackups.message" var="deleteBackupsMessage" />
	<fmt:message key="error.client.locked" var="clientLockedError" />

	<fmt:message key="clientDetials.backupSuccess" var="cloudLaptopBackupSuccess" />
	<fmt:message key="clientDetials.backupFailure" var="cloudLaptopBackupFailure" />

	<enhance:out escapeXml="false">
		<c:set var="clientTitleName" value='${requestScope.CLIENT_DETAIL.clientName}' ></c:set>
		<fmt:message key="deleteBackups.warning" var="deleteBackupsWarning">
			<fmt:param value="${clientTitleName}" />
		</fmt:message>
		<fmt:message key="disableBackups.warning" var="disableBackupsWarning">
			<fmt:param value="${clientTitleName}" />
		</fmt:message>
		<fmt:message key="clientDetails.label.noteMessage" var="accountNoteMessage">
			<fmt:param value="${clientTitleName}" />
		</fmt:message>
	</enhance:out>

	<c:set var="client" value="${requestScope.CLIENT_DETAIL}" />
	<cv:ifCapability name="any browse domainEndUser" appType="${requestScope.APPTYPE}" clientName="${client.clientName}" clientId="${client.clientId}">
		<c:set value="true" var="showSearch" />
	</cv:ifCapability>

	<c:if test="${param.adminMode == true}">
		<c:set var="myComputersLink" value="${myComputers}:summary/adminSummary.jsp" />
		<c:set var="adminModeParam" value="&adminMode=true" scope="request" />
	</c:if>

	<c:if test="${param.adminMode != true}">
		<c:set var="myComputersLink" value="${myComputers}:summary/index.do?page=fs" />
	</c:if>

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="Client_Details" name="title" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="myDataNav.jsp" name="navPage" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="${clientTitleName}" name="headerTitleLocalized" />
		<jsp:param value="${myComputersLink}" name="breadCrumbValues" />
		<jsp:param value="false" name="includeSecHeader" />
		<jsp:param value="true" name="includeCustomSecHeader" />
		<jsp:param value="clientDetails" name="sourcePage" />
		<jsp:param value="${showSearch}" name="showSearch" />
		<jsp:param value="../common/customFileSystemSecHeader.jsp" name="customHeaderURL" />
	</jsp:include>
		<script nonce="${sessionScope.cspNonce}" src="../common/thirdParty/mapbox/v2/mapbox-gl.js?secure"></script>
		<link href="../common/thirdParty/mapbox/v2/mapbox-gl.css" rel='stylesheet'/>  
		 <!--[if lte IE 8]>
	  	  <link href='//api.tiles.mapbox.com/mapbox.js/v1.3.1/mapbox.ie.css' rel='stylesheet' >
	  	<![endif]-->

	<%-- Construct URL parameter string with remote CommCell details. --%>
	<c:set var="ccParams" value="" scope="request" />
	<c:if test="${requestScope._cid != null}">
		<c:set var="ccParams" value="${requestScope.ccParams}&_cid=${requestScope._cid}" scope="request" />
	</c:if>
	<c:if test="${requestScope._cn != null}">
		<c:set var="ccParams" value="${requestScope.ccParams}&_cn=${requestScope._cn}" scope="request" />
	</c:if>

	<script class="localVariables" type="text/json">
		{ "jobPollInterval": "${requestScope.jobPollInterval}" }
	</script>

    	<div class="sub-section">
    	<c:choose>
    	<c:when test='${client.clientActive == "true"}'>
	  		<div class="subsec-body clientDetails row vw-page-client-details">

				<div class="col-sm-6">
					<div class="backup vw-tile">
						<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.backup" /></div>
						<dl class="blockrows vw-dl-horizontal">

							<dt class="infotype"><fmt:message key="clientDetails.label.lastBackup" /></dt>
							<dd class="infodesc" id="lastBackup"></dd>
							<dt class="infotype"><fmt:message key="clientDetails.label.lastBackupSize" /></dt>
							<dd class="infodesc">${client.size}</dd>

							<dt class="infotype"><fmt:message key="clientDetails.label.totalBackupSize" /></dt>
							<dd class="infodesc">${client.totalSize}</dd>
							<c:if test="${client.lastBackupAttempt != null}">
								<dt class="infotype"><fmt:message key="clientDetails.label.lastBackupAttempt" /></dt>
								<dd class="infodesc" id="lastBackupAttempt"></dd>
							</c:if>
							<dt class="infotype"><fmt:message key="clientDetails.label.lastOnlineTime" /></dt>
							<dd class="infodesc" id="lastOnlineTime"></dd>
							<dt class="infotype"></dt>
							<!-- clientName is not used for FS now -->

							<dd class="infodesc"><a class="recentBackupJobs" href="<c:url context='${pageContext.request.contextPath}' value='/clientDetails/${requestScope.JOBS_PAGE}'>
																						<c:param name='clientName' value='${client.clientName}'/>
																						<c:param name='clientId' value='${client.clientId}'/>
																						<c:param name='type' value='backup'/>
																						<c:param name='isCloudLaptop' value='${client.cloudLaptop}'/>
																					</c:url>${ccParams}${adminModeParam}"><fmt:message key="clientDetails.label.recentBackupJobs" /></a></dd>
						</dl>
					</div>
					<div class="restore vw-tile">
						<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.restore" /></div>
						<ul data-role="listview" class="blockrows">
							<cv:ifCapability name="any browse domainEndUser" appType="${requestScope.APPTYPE}" clientName="${client.clientName}" clientId="${client.clientId}">
								<fmt:bundle basename="localization.ClientDetailsMessages">
									<li class="infodesc"><a class="mainBtn vw-btn vw-btn-primary" role="button" href="<c:url context='${pageContext.request.contextPath}' value='/browse/${requestScope.BROWSE_PAGE}'>
																											<c:param name='clientName' value='${client.clientName}'/>
																											<c:param name='clientId' value='${client.clientId}'/>
																											</c:url>${ccParams}${adminModeParam}"><fmt:message key="clientDetails.action.selectFiles" /><span class="filesLink"></span></a></li>
								</fmt:bundle>
							</cv:ifCapability>
							<!-- clientName is not used for FS now -->
							<li class="infodesc vw-recent-restore-text"><a href="<c:url context='${pageContext.request.contextPath}' value='/clientDetails/${requestScope.JOBS_PAGE}'>
																						<c:param name='clientName' value='${client.clientName}'/>
																						<c:param name='clientId' value='${client.clientId}'/>
																						<c:param name='type' value='restore'/>
																					</c:url>${ccParams}${adminModeParam}"><fmt:message key="clientDetails.label.recentRestoreJobs" /></a></li>
						</ul>
					</div>

		<c:if test="${client.showDLP}">
			<div class="dlp vw-tile">
				<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.dlpTitle"/></div>
				<dl data-role="listview" class="blockrows vw-dl-horizontal">
					<dt class="infotype"><fmt:message key="clientDetails.label.contentBackupLock" /></dt>
					<dd id="backupContent" class="infodesc">
						<div id="clientContentsList">
							<c:set var="printSpace" value="false"/>
							<c:forEach items="${client.localDLPContents}" var="item"><c:set var="itemValue" value="${fn:replace(item, '\\\\/\\\\/', '')}" /><c:if test="${printSpace == 'true'}">, </c:if>${itemValue}<c:set var="printSpace" value="true" /></c:forEach>
						</div>
						<fmt:bundle basename="localization.ClientDetailsMessages">
							<c:choose>
								<c:when test="${fn:length(client.localDLPContents) gt 0}">
									<a id="changeDLPContentLink" class="changeContent" role="button" tabindex="0"><fmt:message key='clientDetails.action.change' /></a>
								</c:when>
								<c:otherwise>
									<a id="changeDLPContentLink" class="changeContent" role="button" tabindex="0"><fmt:message key='clientDetails.action.add' /></a>
								</c:otherwise>
							</c:choose>

						</fmt:bundle>
					</dd>
				</dl>
			</div>
		</c:if>

			<fmt:message key="clientDetails.label.lastLocation" var="lastSeenLocation" />
			<fmt:message key="clientDetails.label.lastLocationStolen" var="lastSeenLocationStolen" />

			<c:if test="${client.isDLPEnabled && (!cvConfig.isWebconsoleUseClientDLPSettings() || client.isSecureEraseEnabledOnClient) && client.isDLPStolen}">
	    		<c:set var="showSecureErase" value="true" />
	    	</c:if>

	    	<c:choose>
	    		<c:when test="${showSecureErase && client.lastLocationCanBeShown}">
	    			<c:set var="classToAdd" value="showSecureEraseAndMap" />
	    		</c:when>
	    		<c:when test="${showSecureErase && !client.lastLocationCanBeShown}">
	    			<c:set var="classToAdd" value="showSecureEraseAndNoMap" />
	    		</c:when>
	    		<c:when test="${!showSecureErase && client.lastLocationCanBeShown}">
	    			<c:set var="classToAdd" value="showNoSecureEraseAndMap" />
	    		</c:when>
	    		<c:when test="${!showSecureErase && !client.lastLocationCanBeShown}">
	    			<c:set var="classToAdd" value="showNoSecureEraseAndNoMap" />
	    		</c:when>
	    	</c:choose>
	    	<c:if test="${client.isDLPEnabled || client.lastLocationCanBeShown}">
				<div class="lastLocation ${classToAdd} vw-tile">
						<div class="blocktitle vw-title clearfix">
							<c:choose>
								<c:when test="${client.isDLPEnabled && !client.lastLocationCanBeShown}">
									<fmt:message key="clientDetails.label.secureEraseTileTitle" />
								</c:when>
								<c:otherwise>
									<fmt:message key="clientDetails.label.lastLocation" />
								</c:otherwise>
							</c:choose>
							<c:set var="markerColor" value="#228b22" />
							<c:set var="markerText" value="${lastSeenLocation}" />
							<c:if test="${client.isDLPEnabled && client.lastLocationCanBeShown}">
									<c:choose>
									<c:when test="${client.isDLPStolen}">
										<c:set var="markerColor" value="#f63a39" />
										<c:set var="markerText" value="${lastSeenLocationStolen}" />
										<a id="markStolen" class="markStolenClass absoluteMarkStolen markedStolen vw-btn vw-btn-secondary vw-if-stolen vw-marked-stolen" role="button" tabindex="0"><fmt:message key="clientDetails.label.markFoundTitleDialog" /></a>
									</c:when>
									<c:otherwise>
										<c:set var="markerColor" value="#228b22" />
										<c:set var="markerText" value="${lastSeenLocation}" />
										<a id="markStolen" class="markStolenClass absoluteMarkStolen vw-btn vw-btn-secondary vw-if-stolen vw-mark-stolen" role="button" tabindex="0"><fmt:message key="clientDetails.label.deviceMarkAsLost" /></a>
									</c:otherwise>
									</c:choose>
					    	</c:if>
						</div>

					<ul class="blockrows clearfix">
						<li class="infodesc">
							<c:if test="${client.isDLPEnabled && !client.lastLocationCanBeShown}">
								<c:choose>
									<c:when test="${client.isDLPStolen}">
										<c:set var="markerColor" value="#f63a39" />
										<c:set var="markerText" value="${lastSeenLocationStolen}" />
										<a id="markStolen" class="markStolenClass markedStolen vw-btn btn-danger pull-right" role="button" tabindex="0"><fmt:message key="clientDetails.label.markFoundTitleDialog" /></a>
									</c:when>
									<c:otherwise>
										<c:set var="markerColor" value="#228b22" />
										<c:set var="markerText" value="${lastSeenLocation}" />
										<a id="markStolen" class="markStolenClass vw-btn vw-btn-secondary pull-right" role="button" tabindex="0"><fmt:message key="clientDetails.label.deviceMarkAsLost" /></a>
									</c:otherwise>
								</c:choose>
							</c:if>
							<span class="secureEraseSpan">
								<a id="secureErase" class="secureErase mainBtn vw-btn vw-btn-primary" role="button" tabindex="0"><fmt:message key="clientDetails.button.eraseContent"/></a>
								<c:choose>
									<c:when test="${client.clientSecureEraseStatus == 'PENDING' }">
										<span id="secureEraseComplete" class="text-danger"><fmt:message key="clientDetails.label.contentErasedPending" /></span>
									</c:when>
									<c:when test="${client.clientSecureEraseStatus == 'IN_PROGRESS' }">
										<span id="secureEraseComplete" class="text-danger"><fmt:message key="clientDetails.label.contentErasedInProgress" /></span>
									</c:when>
									<c:when test="${client.clientSecureEraseStatus == 'COMPLETED' }">
										<span id="secureEraseComplete" class="text-danger"><fmt:message key="clientDetails.label.contentErasedCompleted" /></span>
									</c:when>
									<c:otherwise>
										<span id="secureEraseComplete" class="text-danger"><fmt:message key="clientDetails.label.contentErasedPending" /></span>
									</c:otherwise>
								</c:choose>
							</span>
						</li>
					</ul>

						<c:if test="${client.lastLocationCanBeShown}">
							<c:choose>
								<c:when test="${client.geoLocationShowLinkOnly}">
									<dl class="blockrows">
										<dt class="infotype"><fmt:message key="clientDetails.label.Location" />:</dt>
										<dd class="infodesc"><a target="_blank" href="https://maps.google.com/maps?q=${client.lastLattitude},${client.lastLongitude}&iwloc=A&hl=en"><fmt:message key="clientDetails.label.linkToMap"/></a></dd>
									</dl>
								</c:when>
								<c:otherwise>

									<c:choose>
										<c:when test="${showSecureErase}">
											<div id='map' class="mapAreaDiv vw-map extraSpace"></div>
										</c:when>
										<c:otherwise>
											<div id='map' class="mapAreaDiv vw-map"></div>
										</c:otherwise>
									</c:choose>

									<script nonce="${sessionScope.cspNonce}" >
										mapboxgl.accessToken = 'pk.eyJ1IjoiY29tbXZhdWx0LW1hcHMiLCJhIjoiNk81djMzYyJ9.1fAPKqwczcfXkTEBZevStA';
										var map = new mapboxgl.Map({
											container: 'map',
											style: 'mapbox://styles/commvault-maps/ckhm14e9i0tqq1aqtgcpnbc62?optimize=true', // stylesheet location
											center: ["${client.lastLongitude}","${client.lastLattitude}"], // starting position [lng, lat]
											zoom: 7 // starting zoom
										});
										var geoJson = {
												type: "FeatureCollection",
												features: [
												{
													type: "Feature",
													properties: {
														description: '${lastSeenLocation}',
													},
													geometry: {
													type: "Point",
													coordinates: ["${client.lastLongitude}","${client.lastLattitude}"],
													},
												}
												],
											};
										map.on("load", function () {
											map.loadImage(
											'../common/thirdParty/mapbox/v2/marker-pin.png',
											// Add an image to use as a custom marker
											function (error, image) {
												if (error) throw error;
												map.addImage("custom-marker", image, {sdf: true});
												map.addSource("places", {
													type: "geojson",
													data: geoJson
												});
										
												// Add a layer showing the places.
												map.addLayer({
													id: "places",
													type: "symbol",
													source: "places",
													layout: {
														"icon-image": "custom-marker",
														"icon-allow-overlap": true,
													},
													paint: {
														'icon-color': [
															'match',
															['get', 'description'],
															'${lastSeenLocation}', '#228b22',
															'${lastSeenLocationStolen}', '#f63a39',
															'#FF4A6A'
															]
													}
												});
											}
											);
										map.addControl(new mapboxgl.NavigationControl());
										// Create a popup, but don't add it to the map yet.
										var popup = new mapboxgl.Popup({
											closeButton: false,
											closeOnClick: false,
										});
									
										map.on("mouseenter", "places", function (e) {
											// Change the cursor style as a UI indicator.
											map.getCanvas().style.cursor = "pointer";
											var coordinates = e.features[0].geometry.coordinates.slice();
											var description = e.features[0].properties.description;
											// Ensure that if the map is zoomed out such that multiple copies of the feature are visible, the popup appears over the copy being pointed to.
											while (Math.abs(e.lngLat.lng - coordinates[0]) > 180) {
												coordinates[0] += e.lngLat.lng > coordinates[0] ? 360 : -360;
											}
											// Populate the popup and set its coordinates based on the feature found.
											popup.setLngLat(coordinates).setHTML(description).addTo(map);
										});
									
										map.on("mouseleave", "places", function () {
											map.getCanvas().style.cursor = "";
											popup.remove();
										});
									});
									function resetColors(markingStolen) {
										if(markingStolen){
											geoJson.features[0].properties['description'] = '${lastSeenLocation}';
										} else {
											geoJson.features[0].properties['description'] = '${lastSeenLocationStolen}';
										}
									}
								</script>
							</c:otherwise>
						</c:choose>
					</c:if>
			</div>
		</c:if>

		<c:if test="${not hideSyncTile}">
			<div class="sync vw-tile">
					<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.userAccounts" /></div>
				<div class="syncMain hidden">
					<dl data-role="listview" class="blockrows vw-dl-horizontal" id="syncFolders">
						<dt class="infotype"><fmt:message key="clientDetails.label.associatedUser" /></dt>
						<dd class="infodesc">
							<span class="selectFiles1">
								<span id="unlinkedAccount"><fmt:message key="clientDetails.label.unassigned" /><br/><a class="selectUserOption vw-cursor-pointer" role="button" tabindex="0"><fmt:message key="clientDetails.label.assignNow" /></a></span>
								<span id="linkedAccount"><span id="cAccount"></span><br/><a class="selectUserOption vw-cursor-pointer" role="button" tabindex="0"><fmt:message key="clientDetails.label.changeNow" /></a></span>
							</span></dd>
						<dt class="infotype"></dt>
						<dd class="infodesc helpText vw-help-text"><small><span class="vw-underline"><fmt:message key="clientDetails.label.note" /></span>&nbsp;${accountNoteMessage}</small></dd>
					</dl>
				</div>
				<div class="dropdownUsersList vw-drop-down-toggle vw-drop-down-users">
					<div class="triborder vw-triangle-border"><div class="triarea vw-triangle-innards" ></div></div>
						<ul class="usersList vw-users-list settingsbox">
						</ul>
				</div>
				<div id="syncLoader" class="vw-sync-loading hidden"><img src="../common/css/images/loading.gif" role="presentation" aria-hidden="true" alt="" />&nbsp;<fmt:message key="clientDetails.label.loadingSync" />
				</div>
			</div>
		</c:if>

				</div>
				<div class="col-sm-6">
					<div class="schedules vw-tile">
						<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.schedules" /></div>
						<dl class="blockrows vw-dl-horizontal">
							<dt class="infotype"><fmt:message key="clientDetails.label.nextBackup" /></dt>
							<dd class="infodesc" id="nextBackup"></dd>
							<dt class="infotype"></dt>
							<dd class="infodesc">
							<c:set var="backupCapability" value="${false}" />
								<cv:ifCapability name="backup" appType="${requestScope.APPTYPE}" clientName="${client.clientName}" clientId="${client.clientId}">
									<c:set var="backupCapability" value="${true}" />
									<fmt:bundle basename="localization.ClientDetailsMessages">
										<a href="<c:url context='${pageContext.request.contextPath}' value='/server/doStartBackup'>
													<c:param name='clientName' value='${client.clientName}'/>
													<c:param name='clientId' value='${client.clientId}'/>
												</c:url>${ccParams}" id="runBackupLink" class="mainBtn vw-btn vw-btn-primary" ><fmt:message key="clientDetails.action.backupNow" /></a>
										<div id="overQuotaWarning" class="text-warning warning"><fmt:message key="clientDetails.label.overQuotaMsg"/></div>
										<div id="deconfiguredMsg" class="vw-start-hidden"><fmt:message key="clientDetails.label.deconfiguredMsg"/></div>
									</fmt:bundle>
								</cv:ifCapability>
								<div class="currBackup vw-backup-current hidden">
								</div>
							</dd>
						<c:set var="noScheduleCapability" value="${not backupCapability}" />
						<cv:ifCapability name="not ScheduleApplication" appType="${requestScope.APPTYPE}"  clientName="${client.clientName}" clientId="${client.clientId}">
							<c:set var="noScheduleCapability" value="${true}" />
						</cv:ifCapability>
							<dt class="infotype"><fmt:message key="clientDetails.label.schedules" /></dt>
						<c:forEach var="sched" items="${client.schedules}">
							<dd class="infodesc">
								<c:set var="mode" value="" />
								<c:choose>
								 	<c:when test="${sched.fromPolicy}">
										<a href="<c:url context='${pageContext.request.contextPath}' value='/loadSchedule.do'>
													<c:param name='clientName' value='${client.clientName}'/>
													<c:param name='clientId' value='${client.clientId}'/>
													<c:param name="taskId" value="${sched.taskId}"/>
													<c:param name="subtaskId" value="${sched.subtaskId}"/>
													<c:param name="mode" value="policy"/>
												</c:url>${ccParams}" class="loadschedule vw-schedule-loaded viewonly" data-title="${viewScheduleTitle}">
										   ${sched.description}
	                                       <span class="sprite icon-leaf" aria-hidden="true" role="presentation"></span>
										</a>
								 	</c:when>
								 	<c:when test="${noScheduleCapability}">
										<a href="<c:url context='${pageContext.request.contextPath}' value='/loadSchedule.do'>
													<c:param name='clientName' value='${client.clientName}'/>
													<c:param name='clientId' value='${client.clientId}'/>
													<c:param name="taskId" value="${sched.taskId}"/>
													<c:param name="subtaskId" value="${sched.subtaskId}"/>
													<c:param name="mode" value="view"/>
												</c:url>${ccParams}" class="loadschedule vw-schedule-loaded viewonly" data-title="${viewScheduleTitle}">
										   ${sched.description}
	                                       <span class="sprite icon-leaf" aria-hidden="true" role="presentation"></span>
										</a>
								 	</c:when>
								 	<c:otherwise>
										<a href="<c:url context='${pageContext.request.contextPath}' value='/loadSchedule.do'>
													<c:param name='clientName' value='${client.clientName}'/>
													<c:param name='clientId' value='${client.clientId}'/>
													<c:param name="taskId" value="${sched.taskId}"/>
													<c:param name="subtaskId" value="${sched.subtaskId}"/>
												</c:url>${ccParams}" class="loadschedule vw-schedule-loaded"  data-title="${editScheduleTitle}">
										   ${sched.description}
	                                       <span class="sprite icon-edit" aria-hidden="true" role="presentation"></span>
										</a>
								 	</c:otherwise>
							 	</c:choose>
							</dd>
							<dt class="infotype"></dt>
						</c:forEach>
						<c:if test="${!noScheduleCapability}">
							<dd class="infodesc">
								<a id="newScheduleLink" data-title="${addScheduleTitle}" class="selectFiles vw-btn vw-btn-secondary" role="button" tabindex="0"><span class="sprite icon-plus" aria-hidden="true" role="presentation"></span>&nbsp;<fmt:message key="clientDetails.action.schedule" /></a>
							</dd>
						</c:if>
					</dl>
				</div>
				<div class="content vw-tile">
					<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.content" /></div>
					<dl data-role="listview" class="blockrows vw-dl-horizontal">
						<dt class="infotype"><fmt:message key="clientDetails.label.contentBackup" /></dt>
						<dd id="backupContent" class="infodesc">
							<div id="clientContentsList">
								<c:set var="printSpace" value="false"/>
								<c:if test="${client.deCoupleContent=='false'}">
									<c:forEach items="${client.policyContents}" var="item"><c:if test="${printSpace == 'true'}">, </c:if>${item}<c:set var="printSpace" value="true" /></c:forEach>
								</c:if>
								 <c:forEach items="${client.localContents}" var="item"><c:if test="${printSpace == 'true'}">, </c:if>${item}<c:set var="printSpace" value="true" /></c:forEach>
							</div>
						</dd>
						<dt><fmt:message key="clientDetails.label.contentExclude" /></dt>
						<dd>
							<div id="clientContentsList">
								<c:set var="printSpace" value="false"/>
								<c:if test="${client.deCoupleContent=='false'}">
									<c:forEach var="item" items="${client.policyExcludes}"><c:if test="${printSpace == 'true'}">, </c:if>${item}<c:set var="printSpace" value="true" /></c:forEach>
								</c:if>
								<c:forEach var="item" items="${client.localExcludes}"><c:if test="${printSpace == 'true'}">, </c:if>${item}<c:set var="printSpace" value="true" /></c:forEach>
							</div>
						</dd>
						<dt></dt>
						<dd>
							<cv:ifCapability name="ManageApplication" appType="${requestScope.APPTYPE}" clientName="${client.clientName}" clientId="${client.clientId}">
								<fmt:bundle basename="localization.ClientDetailsMessages">
									<a id="changeBackupContentLink" class="changeContent" role="button" tabindex="0"><fmt:message key="clientDetails.action.change" /></a>
								</fmt:bundle>
							</cv:ifCapability>
						</dd>
					</dl>
				</div>

			<c:set var="showLocking" value="false" />
			<c:set var="isPrivacyFeatureDisabled" value="true" />

			<cv:secureTag name="Laptop Privacy Control" id="26">
				<c:set var="showLocking" value="true" />
				<c:set var="isPrivacyFeatureDisabled" value="false" />
			</cv:secureTag>
			<c:if test='${client.isClientLocked == "true"}'>
					<c:set var="showLocking" value="true" />
			</c:if>
			<c:if test='${!client.isOwner}'>
				<c:set var="showLocking" value="false" />
			</c:if>

			<c:if test="${showLocking}">

				<div class="clientLock vw-tile">
						<div class="blocktitle vw-title">
							<fmt:message key="clientDetails.label.clientLock" />
						</div>
						<dl class="clientLockMain blockrows vw-dl-horizontal">
							<c:choose>
								<c:when test='${client.isClientLocked == "true"}'>
										<dt class="infotype" id="lockClientMessage"><fmt:message key="clientDetails.label.desc" /></dt>
										<dd class="infodesc">
											<a id="lockClient" class="locked vw-btn-slider vw-on" role="button" ></a>
										</dd>
								</c:when>
								<c:otherwise>
									<dt class="infotype" id="lockClientMessage"><fmt:message key="clientDetails.label.desc" /></dt>
									<dd class="infodesc"><a id="lockClient" class="unlocked vw-btn-slider vw-off" role="button" tabindex="0"></a></dd>
								</c:otherwise>
							</c:choose>
							<c:if test='${client.isClientLockPasskeySet == "false"}'>
									<dt class="infotype" id="setPassKeyLabel"><fmt:message key="clientlock.label.passKeyRequire"/></dt>
									<dd class="infodesc">
										<a id="setPassKey" class="locked vw-btn-slider vw-off" role="button" ></a>
									</dd>
							</c:if>
							<c:if test='${client.isClientLockPasskeySet == "true"}'>
								<dt class="infotype" ><fmt:message key="clientlock.label.passKeyRequire"/></dt>
								<dd class="infodesc">
									<a id="togglePasskey" class="locked vw-btn-slider vw-on" role="button" ></a>
									<a id="editPassKey">[<fmt:message key="clientlock.label.edit"/>]</a>
								</dd>
								<c:if test='${client.isAuthorizeForRestoreSet == "true"}'>
									<dt class="infotype" >${authorizeForRestoreDialogTitle}</dt>
									<dd class="infodesc">
										<a id="toggleAuthorizeForRestore" class="locked vw-btn-slider vw-on" role="button" ></a>
									</dd>

								</c:if>
								<c:if test='${client.isAuthorizeForRestoreSet == "false"}'>
									<dt class="infotype" >${authorizeForRestoreDialogTitle}</dt>
									<dd class="infodesc"><a id="toggleAuthorizeForRestore" class="unlocked vw-btn-slider vw-off" role="button" tabindex="0"></a></dd>
								</c:if>

							</c:if>
						</dl>
				</div>
			</c:if>
			<c:if test="${client.isArchivingAllowed}">
				<div class="clientLock vw-tile">
					<div class="blocktitle vw-title">
						<fmt:message key="clientDetails.label.archiveData" />&nbsp;&nbsp;<span class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="right" title="${archivingInfo}"></span>
					</div>
					<div class="clientLockMain">
						<div data-role="listview" class="blockrows clearfix" id="archiveIt">
							<c:choose>
								<c:when test='${client.isClientArchived}'>
									<div class="infotype pull-left"><fmt:message key="clientDetails.label.archDesc" /></div>
									<div class="infodesc pull-right"><a id="archClient" class="locked vw-btn-slider vw-on" role="button" tabindex="0"></a></div>
								</c:when>
								<c:otherwise>
									<div class="infotype pull-left" ><fmt:message key="clientDetails.label.archDesc" /></div>
									<div class="infodesc pull-right"><a id="archClient" class="unlocked vw-btn-slider vw-off" role="button" tabindex="0"></a></div>
								</c:otherwise>
							</c:choose>
						</div>
					</div>
				</div>
			</c:if>
				<div class="alerts vw-tile">
					<div class="blocktitle vw-title"><fmt:message key="clientDetails.label.alerts" /></div>

					<div id="alertsLoader" class="vw-alerts-loading">
					<svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="vw-loader" focusable="false"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg>
					&nbsp;<fmt:message key="clientDetails.label.loadingAlerts" />
					</div>

					<div class="alertsOverflowDiv">
						<ul class="blockrows subscribedAlerts fixedWidth" id="clientAlertsSubs" >
						</ul>
					</div>

					<fmt:bundle basename="localization.messages">
						<div class="alertsBtn" >
							<a id="saveButton" class="mainBtn vw-btn vw-btn-primary hidden" role="button" tabindex="0"><fmt:message key="common.action.save"/></a>
						</div>
					</fmt:bundle>

				</div>

		<c:if test="${requestScope.isEnableClientDelete == true}">
		<cv:ifCapability name="manageApplication" appType="${requestScope.APPTYPE}" clientName="${fn:escapeXml(param.clientName)}" clientId="${fn:escapeXml(param.clientId)}" >
			<c:set var="deactivateCapability" value='true' ></c:set>
		</cv:ifCapability>
		<c:if test="${deactivateCapability == true && (applicationScope.isIDPSSOEnabled == null || applicationScope.isIDPSSOEnabled == false)}">
				<div class="deactivate vw-tile">
					<div class="blocktitle vw-title"><fmt:message key="delete.client.heading" /></div>
					<div class="deactivateMain">
					<c:if test="${!(requestScope.CLIENT_DETAIL.isClientDeconfigured == 1) }">
						<ul class="blockrows vw-dl-horizontal">
							<c:if test="${!(requestScope.CLIENT_DETAIL.isClientDeconfigured == 1)}">
								<li class="infodesc" >
									<a class="disableBackups mainBtn vw-btn vw-btn-primary" tabindex="0" role="button">
										<fmt:message key="disableBackups.label" />
									</a>
								</li>
								<li class="infodesc helpText vw-managecomp-text" ><fmt:message key="disableBackups.message" /></li>
							</c:if>
							</ul>
						</c:if>
					</div>
				</div>
			</c:if>
		</c:if>

		<c:if test="${requestScope.hasFlaPermission == true}">
		<c:set var="showFLA" value="false"/>
		<c:set var="browse" value="false"/>
		<cv:ifCapability name="any browse" appType="${requestScope.APPTYPE}"  clientName="${client.clientName}" clientId="${client.clientId}">
			<c:set var="showFLA" value="true"/>
			<c:set var="browse" value="true"/>
		</cv:ifCapability>
		<cv:ifCapability name="any domainEndUser" appType="${requestScope.APPTYPE}"  clientName="${client.clientName}" clientId="${client.clientId}">
			<c:set var="showFLA" value="true"/>
		</cv:ifCapability>

				<c:if test="${client.isFLAEnabled && showFLA}">
					<fmt:bundle basename="localization.ClientDetailsMessages">
						<div class="reports vw-tile">

							<c:url var="reportsUrlBase" context='${pageContext.request.contextPath}' value='/cireports/flabrowse.jsp'>
													<c:param name='type' value='summary'/>
													<c:param name='component' value='fs'/>
													<c:param name='client' value='${client.clientName}'/>
													<c:param name='clientId' value='${client.clientId}'/>
													<c:param name='browse' value='${browse}'/></c:url>

								<div class="blocktitle vw-title">
									<fmt:message key="clientDetails.label.reportsTitle" />
									<select class="pull-right">
								<option value="accessTime=false&standAloneReq=spaceDistByTime"><fmt:message key="clientDetails.label.byModifiedTime" /></option>
								<option value="accessTime=true&standAloneReq=spaceDistByTime"><fmt:message key="clientDetails.label.byAccessTime" /></option>
								<option value="accessTime=false&standAloneReq=spaceDistBySize"><fmt:message key="clientDetails.label.byFileSize" /></option>
								<option value="accessTime=false&standAloneReq=spaceDistByDocTypes"><fmt:message key="clientDetails.label.byDocumentType" /></option>
							</select>
								</div>

							<iframe id="reportsIframe" name="internal" src="${reportsUrlBase}&accessTime=false&standAloneReq=spaceDistByTime" scrolling="no"></iframe>

						</div>
					</fmt:bundle>
				</c:if>
		</c:if>

			</div>
<%-- 		</c:if> --%>

			<c:choose>
				<c:when test="${client.deCoupleContent=='false'}">
					<div id="deCoupleContent">
					<input type="checkbox" id="toCheckDecouple" class="hidden" /></div>
				</c:when>
				<c:otherwise>
					<div id="deCoupleContent">
					<input type="checkbox" id="toCheckDecouple" class="hidden" checked="checked"/></div>
				</c:otherwise>
			</c:choose>
		</div>
		</c:when>
		<c:otherwise>
			<div id="notActivated">Client has not been activated. Please contact your administrator.</div>
		</c:otherwise>
		</c:choose>
	</div>
</fmt:bundle>

<cv:ifCapability name="ManageOperations" appType="${requestScope.APPTYPE}"  clientName="${client.clientName}" clientId="${client.clientId}">
	<script nonce="${sessionScope.cspNonce}" >
	var manageOperations = true;
	</script>
</cv:ifCapability>

<!-- As per Madhu, we do not require this check anymore. So setting manageAlerts to true -->
	<script nonce="${sessionScope.cspNonce}" >
	var manageAlerts = true;
	</script>


<c:if test="${!showSecureErase}">
	<script nonce="${sessionScope.cspNonce}" >
		$(".secureEraseSpan").hide();
	</script>
</c:if>

<c:choose>
	<c:when test="${client.isSecureEraseCompletedForClient}">
		<script nonce="${sessionScope.cspNonce}" >
			$("#secureErase").hide();
			$("#secureEraseComplete").show();
		</script>
	</c:when>
	<c:otherwise>
		<script nonce="${sessionScope.cspNonce}" >
			$("#secureErase").show();
			$("#secureEraseComplete").hide();
		</script>
	</c:otherwise>
</c:choose>

<script nonce="${sessionScope.cspNonce}" >
var isDLPEnabled = "${client.isDLPEnabled}";
var clientName =  "${fn:escapeXml(client.clientName)}";
var clientId = "${client.clientId}";
var lastBackupSize = "${client.size}";
var totalBackupSize = "${client.totalSize}";
var clientStatus="${client.clientStatus}";
var addScheduleTitle = "${addScheduleTitle}";
var deCoupleValueActual="${client.deCoupleContent}";
var loggedInUserName = "${sessionScope.usernameforjs}";
var loggedInUserId = "${sessionScope.USERID}";
var pausedLocalized = "suspended";
var resumeLocalized = "${resumeLocalized}";
var pauseLocalized = "${pauseLocalized}";
var resume1Localized = "${resume1Localized}";
var runningLocalized = "running";
var killedLocalized = "killed";
var killPendingLocalized = "kill pending";
var suspendPendingLocalized = "Suspend Pending";
var pendingLocalized = "pending";
var waitingLocalized = "waiting";
var failedLocalized = "failed";
var completedLocalized = "completed";
var completedWithErrorsLocalized = "completed w/ one or more errors";
var failedToStartLocalized = "failed to start";
//var backupLocalized = "${backupLocalized}";
var backupLocalized = "backup";
//var restoreLocalized = "${restoreLocalized}";
var restoreLocalized = "restore";
var manageContentTitle="${manageContent}";

var alertsWarning = "${alertsWarning}";
var alertsToolTip= "${alertsToolTip}";
var jobIdText = "${jobIdText}";
var noBytesSize = "${noBytesSize}";
var nothingToBackup = "${nothingToBackup}";
var filesText = "${filesText}";
var userProfileSuccessText = "${userProfileSuccessText}";
var userProfileFailureText = "${userProfileFailureText}";
var isPrivacyFeatureDisabled = "${isPrivacyFeatureDisabled}";
var isClientArchived = ${client.isClientArchived};
var isClientLockPasskeySet = ${client.isClientLockPasskeySet};
<enhance:out escapeXml="false">
var reportsUrlBase = "${reportsUrlBase}&";
</enhance:out>
var apptype = "${requestScope.APPTYPE}";
var clientAppTypeId = "${requestScope.CLIENT_DETAIL.appType}";

var isClientDeconfigured = "${requestScope.CLIENT_DETAIL.isClientDeconfigured}"

<%-- Add remote CommCell details, if present. --%>
if (typeof cvUtil == "object")
{
	cvUtil.ccId = "${requestScope._cid}";
	cvUtil.ccName = "${requestScope._cn}";
}

var localMsg = localMsg || {};
localMsg.alertSaved = "${alertSaved}";
localMsg.startBackupsText = "${startBackupsText}";

<enhance:out escapeXml="false">
localMsg.setPasskeyTitle = "${setPasskey}";
localMsg.passKey = "${passKey}";
localMsg.backupLockContentTitle = "${backupLockContentTitle}";
localMsg.backupContentTitle = "${backupContentTitle}";
localMsg.confirmMarkStolenText = "${confirmMarkStolenText}";
localMsg.confirmMarkFoundText = "${confirmMarkFoundText}";
localMsg.markStolenTitleDialog = "${markStolenTitleDialog}";
localMsg.markFoundTitleDialog = "${markFoundTitleDialog}";
localMsg.markStolenConfirmText = "${markStolenConfirmText}";
localMsg.confirmText = "${confirmText}";
localMsg.confirmTextError = "${confirmTextError}";
localMsg.clientNameChanged="${clientNameChanged}";
localMsg.clientNameChangeFailed="${clientNameChangeFailed}";
localMsg.clientNameValidationFailed="${clientNameValidationFailed}";
localMsg.secureEraseTileTitle="${secureEraseTileTitle}";
localMsg.secureEraseContentTitle="${secureEraseContentTitle}";
localMsg.markLostError="${markLostError}";
localMsg.selectSyncProfileTitle = "${selectSyncProfileTitle}";
//localized messages for archiving
localMsg.archivingDialogTitle="${archivingDialogTitle}";
localMsg.archivingDialogText="${archivingDialogText}";
localMsg.archivingOkButton="${archivingOkButton}";
localMsg.archivingCancelButton="${archivingCancelButton}";
localMsg.archivingError="${archivingError}";
localMsg.archivingCheckCheckbox="${archivingCheckCheckbox}";
localMsg.iAgree="${iAgree}";
</enhance:out>

//Localized messages for Lock Client
localMsg.clientlockDialogTitle="${clientlockDialogTitle}";
localMsg.clientlockDialogSubTitle="${clientlockDialogSubTitle}";
localMsg.lockClientDialogOkButton="${okButton}";
localMsg.lockClientDialogCancelButton="${cancelButton}";
localMsg.passwordError="${passwordError}";
localMsg.untitledClient="${untitledClient}";
localMsg.adminDisabledNote="${adminDisabledNote}";
localMsg.autoResumeTitle="${autoResumeTitle}";
localMsg.authorizeForRestoreDialogTitle="${authorizeForRestoreDialogTitle}";
//localized messages for disable/delete backups
localMsg.disableBackupsLabel = "${disableBackupsLabel}";
localMsg.deleteBackupsLabel = "${deleteBackupsLabel}";
localMsg.disableBackupsMessage = "${disableBackupsMessage}";
localMsg.deleteBackupsMessage = "${deleteBackupsMessage}";
localMsg.deleteBackupsWarning = '${deleteBackupsWarning}';
localMsg.disableBackupsWarning = '${disableBackupsWarning}';
localMsg.clientLockedError = "${clientLockedError}";
localMsg.dateNotAvailable = "${dateNotAvailable}";
localMsg.notScheduled = "${notScheduled}";

localMsg.cloudLaptopBackupSuccess = "${cloudLaptopBackupSuccess}";
localMsg.cloudLaptopBackupFailure = "${cloudLaptopBackupFailure}";

var lastBackupDate = "${requestScope.CLIENT_DETAIL.lastBackup}";
var nextBackupDate = "${requestScope.CLIENT_DETAIL.nextBackup}";
var lastOnlineTime = "${requestScope.CLIENT_DETAIL.lastOnlineTime}";
var lastBackupAttempt = "${requestScope.CLIENT_DETAIL.lastBackupAttempt}";
var isCloudLaptop = ("${requestScope.CLIENT_DETAIL.cloudLaptop}" === "true");
var fsQuotaExceeded = ("true" === "${sessionScope.fsQuotaExceeded}"); // User quota usage.
var hideSyncTile = ("true" === "${hideSyncTile}");
var showPasskeyFeature = true; //sp19 onwards show passkey feature if key is absent
if (cv && cv.additionalSettings && cv.additionalSettings.AdminConsole && (false == cv.additionalSettings.AdminConsole.showPasskeyFeature)){
	showPasskeyFeature = false;
};
if (!showPasskeyFeature){
	$('#setPassKey').hide(); //hide the setpasskey link if the feature is disabled
	$('#setPassKeyLabel').hide();
}
</script>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../summary/js/clientConfig.js" name="js" />
	<jsp:param value="../browse/js/browseCommon.js" name="js" />
	<jsp:param value="js/clientDetails.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="../common/js/encoder.js" name="js"/>
    <jsp:param value="../common/js/changeName.js" name="js" />
    <jsp:param value="../common/js/moment.js" name="js" />
</jsp:include>
