<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<jsp:include page="/common/search-engine.jsp" />
  <meta charset="utf-8" />

  <!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
       Remove this if you use the .htaccess -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

	<c:choose>
		<c:when test="${param.titleLocalized != null}">
			<c:set var="title" value="${fn:escapeXml(param.titleLocalized)}" scope="page" />
		</c:when>
		<c:otherwise>
			<fmt:message key="${param.title}" var="title" />
		</c:otherwise>
	</c:choose>

	<title>${fn:escapeXml(title)}</title>
	<meta name="description" content="" />
	<meta name="author" content="skarnati" />

	<meta name="viewport" content="width=device-width, initial-scale=1.0" />

	<!-- Replace favicon.ico & apple-touch-icon.png in the root of your domain and delete these references -->
	<link rel="shortcut icon" href="/favicon.ico" />
	<link rel="apple-touch-icon" href="../common/img/apple-touch-icon.png" />
	<link rel="stylesheet" href="../common/css/templatestyles.css" />

	<jsp:include page="../common/jquery.jsp" />

	<c:if test="${paramValues.css != null}">
		<c:forEach items="${paramValues.css}" var="cssFile">
			<c:if test="${!fn:startsWith(cssFile, pageContext.request.contextPath)}">
				<c:set var="cssFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${cssFile}" />
			</c:if>
			<c:if test="${cv:isSafeInclude(fn:escapeXml(cssFile))}" >
			<link rel="stylesheet" href="${fn:escapeXml(cssFile)}?${applicationScope.BUILD_TS}" />
			</c:if>
		</c:forEach>
	</c:if>

  <c:if test="${param.includeHistory != null && param.includeHistory == 'true'}">
		<jsp:include page="../common/history.jsp" flush="true" />
	</c:if>
  <c:if test="${param.includeJqueryUI != null && param.includeJqueryUI == 'true'}">
		<jsp:include page="../common/jqueryui.jsp" flush="true" />
	</c:if>
  <c:if test="${param.includeTableSupport != null && param.includeTableSupport == 'true'}">
		<jsp:include page="../common/table.jsp" flush="true" />
	</c:if>

	 <c:if test="${param.includeTreeSupport != null && param.includeTreeSupport == 'true'}">
		<jsp:include page="../common/tree.jsp" flush="true" />
	</c:if>

	<c:if test="${paramValues.jsp != null}">
		<c:forEach items="${paramValues.jsp}" var="jspFile">
			<c:if test="${!(fn:contains(jspFile, 'WEB-INF/') || fn:contains(jspFile, 'WEB-INF\\\\'))}">
				<jsp:include page="../${jspFile}" flush="true" />
			</c:if>
		</c:forEach>
	</c:if>
	<c:if test="${paramValues.js != null}">
		<c:forEach items="${paramValues.js}" var="jsFile">
			<c:if test="${!fn:startsWith(jsFile, pageContext.request.contextPath)}">
				<c:set var="jsFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${jsFile}" />
			</c:if>
			<c:if test="${cv:isSafeInclude(fn:escapeXml(jsFile))}" >
			<script nonce="${sessionScope.cspNonce}" src="${fn:escapeXml(jsFile)}?${applicationScope.BUILD_TS}"></script>
			</c:if>
		</c:forEach>
	</c:if>

</head>
<body>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/logUtil.js"></script>
	<div class="notification sticky hide">
		<p id="notificationText">&nbsp;</p>
		<a class="close" href="#"><img src="${pageContext.request.contextPath}/common/img/icon-close.png" /></a>
	</div>

