<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="fsBackupBrowse.title.page" var="pageTitle" />
	<fmt:message key="fsBackupBrowse.title.header" var="headerTitle" />
	<fmt:message key="machineBrowse.error.clientUnreachable" var="clientUnreachableMsg" />
	<fmt:message key="machineBrowse.error.vmClientBrowseFailure" var="clientUnreachableUsernameMsg" />
	<fmt:message key="machineBrowse.label.loading" var="loading" />
	<fmt:message key="machineBrowse.error.foldersTitle" var="foldersTitle" />
	<fmt:message key="machineBrowse.label.contentLibrary" var="contentLibraryText" />
	<fmt:message key="machineBrowse.error.invalidSelection1" var="invalidSelection1Text" />
	<fmt:message key="machineBrowse.error.invalidSelection2" var="invalidSelection2Text" />
	<fmt:message key="machineBrowse.error.invalidSelection3" var="invalidSelection3Text" />
	<fmt:message key="content.path.desktop" var="desktopText" />
	<fmt:message key="content.path.documents" var="documentsText" />
	<fmt:message key="content.path.music" var="musicText" />
	<fmt:message key="content.path.videos" var="videosText" />
	<fmt:message key="content.path.pictures" var="picturesText" />
	<fmt:message key="content.path.Libraries" var="librariesText" />


	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="css/fsMachineBrowse.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="js/fsMachineBrowse.js" name="js" />
		<jsp:param value="js/content.js" name="js" />
		<jsp:param value="../common/js/logUtil.js" name="js" />
		<jsp:param value="js/browseDialog.js" name="js" />
		<jsp:param value="true" name="includeTreeSupport" />
		<jsp:param value="true" name="includeVistaSkin" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../common/css/cvdialog.css" name="css" />
	</jsp:include>
		<div id="lookupTable">

			<div id="leftcol1" >
				<div id="browsetree"></div>
			</div>

			<div id="centercol1" class="" >
				<div id="datatable_wrapper" class="dataTables_wrapper" >
					<table id="browsetable"  class="tablesorter" >
						<thead>
							<tr>
								<th class="col-select"><span class="sprite icon-arrow-back js-back-link back-link" id="allfiles"></span></th>
								<th class="col-name"><fmt:message key="backupBrowse.tableColumn.name" /></th>
								<th class="col-modDate"><fmt:message key="backupBrowse.tableColumn.modified" /></th>
							</tr>
						</thead>
					</table>

				</div>
			</div>

	</div>
	<fmt:bundle basename="localization.messages">
		<div class="btns" >
				<a href="#" id="selectBrowseButton" class="okSaveButton disabled"><fmt:message key="common.action.select" /></a>
				<a href="#" id="cancelBrowseButton"><fmt:message key="common.action.cancel" /></a>
				<fmt:bundle basename="localization.BackupBrowseMessages">
					<a href="#" id="createFolder" class="leftButton okSaveButton hidden disabled"><fmt:message key="upload.label.createFolder" /></a>
				</fmt:bundle>
		</div>
	</fmt:bundle>

	</body>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}"  >

var contentLibraryText = "${contentLibraryText}";
var invalidSelection1Text = "${invalidSelection1Text}";
var invalidSelection2Text = "${invalidSelection2Text}";
var invalidSelection3Text = "${invalidSelection3Text}";
var desktopText = "${desktopText}";
var documentsText = "${documentsText}";
var musicText = "${musicText}";
var videosText = "${videosText}";
var picturesText = "${picturesText}";
var librariesText= "${librariesText}";
var PARAM_NO_MONIKERS = "noMonikers";
var PARAM_NO_CONTENT_LIBRARY = "noContentLibrary";

var localMsg = localMsg || {};
localMsg.clientUnreachableMsg = "${clientUnreachableMsg}";
localMsg.clientUnreachableUsernameMsg = "${clientUnreachableUsernameMsg}";
var foldersTitle = "${foldersTitle}";

var delim = "${requestScope.OS_DELIM}";
var browseDialog = browseDialog || {};
browseDialog.showMonikerMode = "true" === "${fn:escapeXml(requestScope.showMonikerMode)}";
browseDialog.multiSelMode = "true" === "${fn:escapeXml(requestScope.multiSelMode)}";
browseDialog.foldOnly = "true" === "${fn:escapeXml(requestScope.foldOnly)}";
browseDialog.iun = "${fn:escapeXml(requestScope.iun)}";
browseDialog.iup = "${fn:escapeXml(requestScope.iup)}";
browseDialog.ajaxUrl = "${fn:escapeXml(requestScope.machineBrowseUrl)}";
browseDialog.delim=delim;
browseDialog.monikerTexts={
		contentLibraryText:"${contentLibraryText}",
		documentsText:"${documentsText}",
		documentsText:"${documentsText}",
		musicText:"${musicText}",
		videosText:"${videosText}",
		picturesText:"${picturesText}",
		librariesText:"${librariesText}",
}

// This method is called by custom-modal to retrieve return value for callback function - do not add to local namespace!
function getData(){
	return browseDialog.selContent;
}

var selectionMode;
var startPath;
var noMonikers = 0;
var showContentLibrary = true;
var valuesRecieved = cvUtil.getInitModalData();
browseDialog.getInitModalData=valuesRecieved;
var clientId = cvUtil.getParameter("clientId", null);
var clientName = cvUtil.getParameter("clientName", null);

<%-- Add remote CommCell details, if present. --%>
if (typeof cvUtil == "object")
{
	cvUtil.ccId = "${requestScope._cid}";
	cvUtil.ccName = "${requestScope._cn}";
}
</script>
