<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="dialog" name="displayMode" />

		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="css/browsestyles.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="css/timeRangeOptions.css" name="css" />

		<jsp:param value="" name="titleLocalized" />
	</jsp:include>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/jquery-timepicker/jquery.timepicker.css" />
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/jquery-timepicker/jquery.timepicker.min.js">
	</script>
	<c:choose>
		<c:when test="${param.advanced == 'true' }">
			<div id="wrap1">
				<div id="from_col" >
					<div class="calheader"><fmt:message key="backupBrowse.header.timeRangeFrom"/></div>
					<div id="fromTimeDatePicker"></div>
					<div class="timestampLabel"><fmt:message key="backupBrowse.label.TimeStamp"/></div>
					<input id="fromTimePicker" class="time ui-timepicker-input" type="text" autocomplete="off">
				</div>
				<div id="to_col">
					<div class="calheader"><fmt:message key="backupBrowse.header.timeRangeTo"/></div>
					<div id="toTimeDatePicker"></div>
					<div class="timestampLabel"><fmt:message key="backupBrowse.label.TimeStamp"/></div>
					<input id="toTimePicker" class="time ui-timepicker-input" type="text" autocomplete="off">
				</div>
			</div>
		</c:when>
		<c:otherwise>
			<div id="wrap2">
				<div class="calheader"><fmt:message key="backupBrowse.header.timeRangeBasic"/></div>
				<div id="toTimeDatePicker"></div>
				<div class="timestampLabel"><fmt:message key="backupBrowse.label.TimeStamp"/></div>
				<input id="toTimePicker" class="time ui-timepicker-input" type="text" autocomplete="off">
			</div>
		</c:otherwise>
	</c:choose>

	<div class="clrfloat"></div>

	<fmt:bundle basename="localization.messages">
		<div class="btns">
			<a href="#" id="cancelButton"><fmt:message key="common.action.cancel" /></a>
			<a href="#" id="okButton" class="okSaveButton"><fmt:message key="common.action.ok" /></a>
		</div>
	</fmt:bundle>

</fmt:bundle>

<%@ include file="../common/datepicker.jsp" %>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/timeRangeOptions.js" name="js" />
</jsp:include>

