<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<ul class="settingsbox vw-dropdown-menu">
		<li title='<fmt:message key="backupBrowse.menu.timeRangeLatest" />'><a href="#" class="timeRangeLatest"><fmt:message key="backupBrowse.menu.timeRangeLatest" /></a></li>
		<li title='<fmt:message key="backupBrowse.menu.timeRangeBasic" />'><a href="#" class="timeRangeBasic"><fmt:message key="backupBrowse.menu.timeRangeBasic" /></a></li>
		<c:if test="${param.disableTimeRangeAdv != 'true'}">
		<li title='<fmt:message key="backupBrowse.menu.timeRangeAdvanced" />'><a href="#" class="timeRangeAdvanced"><fmt:message key="backupBrowse.menu.timeRangeAdvanced" /></a></li>
		</c:if>
		<c:choose>
			<c:when test="${param.isMachineBrowseAvailable == true}">
				<c:if test="${param.isAclBrowseSupported == 'true'}">
					<li title='<fmt:message key="backupBrowse.menu.browseLiveMachine" />'><a href="#" class="browseLiveMachine"><fmt:message key="backupBrowse.menu.browseLiveMachine" /></a></li>
				</c:if>
				<c:if test="${param.isAclBrowseSupported == 'false'}">
					<li title='<fmt:message key="backupBrowse.menu.timeRangeLatestData" />'><a href="#" class="timeRangeLatestData"><fmt:message key="backupBrowse.menu.timeRangeLatestData" /></a></li>
				</c:if>
			</c:when>
			<c:when test="${param.isLiveBrowseAvailable == 'true'}">
				<li title='<fmt:message key="backupBrowse.menu.timeRangeLatestData" />'><a href="#" class="timeRangeLatestData"><fmt:message key="backupBrowse.menu.timeRangeLatestData" /></a></li>
			</c:when>
		</c:choose>
	</ul>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	$(document).ready(function() {
		$(".timeRangeLatest, .timeRangeBasic, .timeRangeAdvanced, .timeRangeLatestData, .browseLiveMachine").off();
		
		if (browseMain.isSmartBrowse(browseMain.browsePath)){
			$(".browseLiveMachine").parent().hide();
			$(".timeRangeLatestData").parent().hide();
		}
			
		if (browseMain.browseMode == BrowseMode.VIEW_FAVORITES){
			$(".timeRangeBasic").parent().hide();
			$(".timeRangeAdvanced").parent().hide();
			$(".browseLiveMachine").parent().css("border-bottom","none");
			$(".timeRangeLatestData").parent().css("border-bottom","none");
		}
		$(".timeRangeLatest").on("click", function(event) {
			//reset the browse path if switching from network share browse to non-network share browse
			if (browseMain.isUNCPath){
				browseMain.browsePath = browseAppType.getInitialTreeBrowsePath();
			}
			browseMain.changeBrowseTimeRange(); // uses latest backups
			event.stopPropagation();
			event.preventDefault();
			$("body").click();
		});	
		$(".timeRangeBasic").on("click", function(event) {
			browseMain.showTimeRangeOptions();
			event.stopPropagation();
			event.preventDefault();
			$("body").click();
		});
		$(".timeRangeAdvanced").on("click", function(event) {
			browseMain.showTimeRangeOptions(true);
			event.stopPropagation();
			event.preventDefault();
			$("body").click();
		});
		$(".timeRangeLatestData").on("click", function(event) {
			//reset the browse path if switching from network share browse to non-network share browse
			if (browseMain.isUNCPath){
				browseMain.browsePath = browseAppType.getInitialTreeBrowsePath();
			}

			browseMain.changeBrowseTimeRange(-1,-1); //machine browse without acl
			event.stopPropagation();
			event.preventDefault();
			$("body").click();
		});
		
		$(".browseLiveMachine").on("click", function(event) {
			browseMain.doMachineBrowse(); //for machine browse with acl
			event.stopPropagation();
			event.preventDefault();
			$("body").click();
		});
	})
</script>
