<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="false" name="includeSecHeader" />
		<jsp:param value="false" name="includeJqueryUI" />
		<jsp:param value="false" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../browse/css/tagMultipleDialog.css" name="css" />
	</jsp:include>

	<div class="tagInputs">
		<p>
			<fmt:message key="backupBrowse.label.enterTag" />
		</p>
		<input id="tags" type="text" />
	</div>
	<c:if test="${param.selectionCount > 1}">
		<p class="selectionInfo">
			<fmt:message key="backupBrowse.label.selectionInfo">
				<fmt:param value="${param.selectionCount}" />
			</fmt:message>
		</p>
	</c:if>

	<div class="btns">
		<fmt:bundle basename="localization.messages">
			<a href="#" id="cancelButton"><fmt:message key="common.action.cancel" /></a>
		</fmt:bundle>
		<a href="#" id="removeTagButton" class="disabledActions"><fmt:message key="backupBrowse.button.removeTags" /></a>
		<a href="#" id="addTagButton" class="disabledActions"><fmt:message key="backupBrowse.button.addTags" /></a>
	</div>

	<jsp:include page="../common/footer.jsp">
		<jsp:param value="js/tagMultipleDialog.js" name="js" />
	</jsp:include>

</fmt:bundle>
