<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.title.settings" var="settingsTitle" />
	<fmt:message key="connectedClients.title.connectedDevices"
		var="connectedDevices" />
	<fmt:message key="connectedClients.title.computer" var="clientLabel" />
	<fmt:message key="backupBrowse.tableColumn.folderPath" var="folderPath" />
	<fmt:message key="connectedClients.label.sync" var="syncLabel" />
	<fmt:message key="connectedClients.error.msg" var="errorMsg" />

<jsp:include page="../common/headerV2.jsp">
	<jsp:param value="css/syncedClientList.css" name="css"/>
	<jsp:param value="${settingsTitle}" name="titleLocalized" />
	<jsp:param value="${connectedDevices}" name="headerTitleLocalized" />

	<jsp:param value="false" name="includeSecHeader" />
	<jsp:param value="true" name="includeCustomSecHeader" />
		<jsp:param value="../common/customFileSystemSecHeader.jsp"
			name="customHeaderURL" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="myDataNav.jsp" name="navPage" />
</jsp:include>

<div id="parentDiv">
	<div id="clientsListDiv" class="vw-client-list">
		<ul class="clientRow header vw-client-row vw-heading-row">
				<li class="li1" data-title="Client"><fmt:message
						key="backupBrowse.title.myComputers" /></li>
				<li class="li2" data-title="Folder Path"><fmt:message
						key="backupBrowse.tableColumn.folderPath" /></li>
				<li class="li3" data-title="Sync"><fmt:message
						key="connectedClients.label.sync" /></li>
		</ul>
		<div id="clientsList" class="vw-client-list_content"></div>
	</div>
</div>

</fmt:bundle>

<script type="text/template" id="clientsListTemplate">
{{#clientList}}
	<ul class="clientRow vw-client-row clearfix" data-webfolder-id="{{webFolderId}}">
		<li class="li1" data-title="{{clientLabel}}" data-client-id="{{client.clientId}}" >
			<span class="vw-os-sprite sprite logo-{{osType}} {{#disabled}}vw-os-disabled{{/disabled}}"></span>
			<p class="{{#disabled}}vw-disabled{{/disabled}}">{{client.clientName}}</p>
		</li>
		<li class="li2" data-title="{{folderPath}}">
			<p class="{{#disabled}}vw-disabled{{/disabled}}">{{syncPath}}</p>
		</li>
		<li class="li3" data-title="{{syncLabel}}" >
			<div class="syncModeScroll vw-toggle-sync" data-state="{{osType}}">
				<img src="../sync/img/{{#disabled}}offMode_big.png{{/disabled}}{{^disabled}}onMode_big.png{{/disabled}}">
			</div>
		</li>
		{{#blackListedFiles}}
			<li class="li4 vw-alert alert-danger">
				<span class="reviewMessage" >There are {{blackListedFiles}} files marked for review. Please click <span class="reviewFilesAction" data-client-id={{client.clientId}} data-client-name={{client.clientName}} data-adminNotified={{adminNotified}} >here</span> to view files and take action.</span>
			</li>
		{{/blackListedFiles}}
	</ul>
{{/clientList}}
</script>

<jsp:include page="../common/footer.jsp" >
	<jsp:param value="js/syncedClientList.js" name="js" />
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js" />
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>

<script nonce="${sessionScope.cspNonce}" >
var clientId =  "${fn:escapeXml(param.clientId)}";

var localMsg = localMsg || {};
localMsg.clientLabel = "${clientLabel}";
localMsg.folderPath = "${folderPath}";
localMsg.syncLabel = "${syncLabel}";
localMsg.errorMsg = "${errorMsg}";
</script>
