<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../browse/css/upload.css" name="css" />
		<jsp:param value="../browse/css/shareFiles.css" name="css" />
		<jsp:param value="../browse/css/publicUrl.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
        <jsp:param value="../common/css/custom-cb.css" name="css" />
	</jsp:include>

	<fmt:message key="sharing.label.confirmDeleteTextLink" var="confirmDeleteText" />
	<fmt:message key="sharing.label.confirmDeleteTitle" var="confirmDeleteTitle" />
	<fmt:message key="action.generic.error" var="genericError" />
	<fmt:message key="sharing.error.text6" var="errorTextShareExpiredUpdate" />
	<fmt:message key="machineBrowse.label.loading" var="loading" />
	<fmt:message key="share.label.addCommaSepEmailsText" var="addCommaSepEmailsText" />
	<fmt:message key="share.label.noEditCapability" var="noEditCapability" />
	<fmt:message key="share.notification.publicLinkUnShareConfirm" var="publicLinkUnShareConfirm"/>
	<fmt:message key="share.notification.publicLinkUnShareTitle" var="publicLinkUnShareTitle"/>
	<fmt:message key="share.label.setNewPassword" var="setNewPasswordText" />

	<c:set var="shareInfo" value="${requestScope.shareFolderInfo}" />
	<c:set var="uploadLinkshareInfo" value="${requestScope.uploadLinkShareInfo}" />

	<div class="pDiv">

			<div id="menuHDiv">
				<ul class="liSpaceFix">
				  <li id="viewOnlyM" class="setM menucs"><fmt:message key="share.label.viewOnlyLabel" /></li>
				  <c:if test="${!requestScope.isNfsObjectStore}">
					<li id="editM" class="menucs"><fmt:message key="backupBrowse.action.edit" /></li>
				  </c:if>
				</ul>

				<div class="previewDiv viewPD">
					<div class=""><div class="line"><input type="text" id="publicViewLink" value="${loading}" readonly="readonly"></div></div>
				</div>


				<div class="previewDiv uploadPD">
					<div class=""><div class="line"><input type="text" id="publicUploadLink" value="${loading}" readonly="readonly"></div></div>
				</div>

				<table>
					<tr class="advanceRow emailLi viewLink">
						<td><fmt:message key="share.label.emailLinkNowPublicView" /></td>
						<td>
							<ul class="selectMode">
				                <li><textarea id="emailList" placeHolder="${addCommaSepEmailsText}"></textarea></li>
			                </ul>
						</td>
					</tr>
					<tr class="advanceRow emailLi uploadLink">
						<td><fmt:message key="share.label.emailLinkNowPublicUpload" /></td>
						<td>
							<ul class="selectMode">
				                <li><textarea id="emailList" placeHolder="${addCommaSepEmailsText}"></textarea></li>
			                </ul>
						</td>
					</tr>
				</table>
	<jsp:include page="../browse/commonShareInfo.jsp" >
		<jsp:param value="${shareInfo.browseInfo.expirationTime.time}" name="timeValue"/>
		<jsp:param value="${shareInfo.browseInfo.password.isSet}" name="isPwdSet"/>
		<jsp:param value="${shareInfo.browseInfo.password.generatePassword}" name="isPwdGenerated"/>
		<jsp:param value="${shareInfo.canReshare}" name="isReshareEnabled"/>
		<jsp:param value="${requestScope.isCreateFolder}" name="isNewShare" />
	</jsp:include>

	<jsp:include page="../browse/commonShareInfoEdit.jsp" >
		<jsp:param value="${uploadLinkshareInfo.browseInfo.expirationTime.time}" name="timeValueUpload"/>
		<jsp:param value="${uploadLinkshareInfo.browseInfo.password.isSet}" name="isPwdSetUpload"/>
		<jsp:param value="${uploadLinkshareInfo.browseInfo.password.generatePassword}" name="isPwdGeneratedUpload"/>
		<jsp:param value="${uploadLinkshareInfo.canReshare}" name="isReshareEnabledUpload"/>
		<jsp:param value="${requestScope.isCreateFolder}" name="isNewShare" />
    </jsp:include>
	</div>

	</div>

	<!-- BUTTONS DIV FOR EMAIL -->
	<div class="btns viewbtn" >

		<a type="button" id="deleteButton" class="cancelButton leftButton vw-btn vw-btn-secondary disabled"><fmt:message key="share.label.deleteLabel" /></a>

		<a type="button" class="okSaveButton mainBtn vw-btn vw-btn-secondary disabled" id="cancelButton" ><fmt:message key="share.action.done" /></a>
	</div>
           <div class="btns editbtn">

					<a type="button" id="deleteButtonEdit" class="cancelButton leftButton vw-btn vw-btn-secondary disabled"><fmt:message key="share.label.deleteLabel" /></a>

					<a type="button" class="okSaveButton mainBtn vw-btn vw-btn-secondary disabled" id="cancelButtonEdit" ><fmt:message key="share.action.done" /></a>
				</div>

	<!-- SHARE FOLDER ERROR DIV -->
	<div class="errorDiv">
		<label id="errorMessage"></label>
	</div>
</fmt:bundle>

<%@ include file="../common/datepicker.jsp" %>



<jsp:include page="../common/footer.jsp">
       <jsp:param value="../common/js/custom-rb.js" name="js" />
      	<jsp:param value="../common/js/encoder.js" name="js"/>
      	<jsp:param value="../browse/js/publicUrl.js" name="js"/>
</jsp:include>


<script nonce="${sessionScope.cspNonce}" >
var isPwdSet = ("true" === "${shareInfo.browseInfo.password.isSet}");
var isPwdSetUpload = ("true" === "${uploadLinkshareInfo.browseInfo.password.isSet}");
var isPwdGenerated = ("true" === "${shareInfo.browseInfo.password.generatePassword}");
var isPwdGeneratedUpload = ("true" === "${uploadLinkshareInfo.browseInfo.password.generatePassword}");
var generatePwdKeySet = ("true" === "${sessionScope.isPublicShareGeneratedPass}");
var shareFolderName = "${shareInfo.shareFolder.syncWebFolderName}";
var shareFolderNameUpload = "${uploadLinkshareInfo.shareFolder.syncWebFolderName}";
var expirationDate = ("${shareInfo.browseInfo.expirationTime.time == ''}") ? 0 : parseInt("${shareInfo.browseInfo.expirationTime.time}") * 1000;
var expirationDateUpload = ("${uploadLinkshareInfo.browseInfo.expirationTime.time == ''}") ? 0 : parseInt("${uploadLinkshareInfo.browseInfo.expirationTime.time}") * 1000;
var isCreateFolder = ("true" == "${requestScope.isCreateFolder}");
var browseUrlPublic = "${shareInfo.browseInfo.emailInfo.browseUrl}";
var clientId = "${requestScope.clientId}";
var subClientId = "${requestScope.subclientId}";
var clientName = "${requestScope.clientName}";
var isEdgeClient = "${requestScope.isEdgeClient}";
var browseParentShareId = "${requestScope.browseParentShareId}";
var hasNoSelections = ("true" === "${requestScope.noSelections}");
var publicUrl = publicUrl || {};
publicUrl.viewShareFolderId = "${shareInfo.shareFolder.syncWebFolderId}";
publicUrl.uploadShareFolderId = "${uploadLinkshareInfo.shareFolder.syncWebFolderId}";
publicUrl.browseUrlPublicUpload = "${uploadLinkshareInfo.browseInfo.emailInfo.browseUrl}";
publicUrl.canUserEdit = "${(requestScope.isUploadAvailable)&&(!requestScope.isParentReadOnly)}";
var monikerRealPath = "${requestScope.monikerRealPath}";
var isParentReadOnly = "${requestScope.isParentReadOnly}";

<%-- Add remote CommCell details, if present. --%>
if (typeof cvUtil == "object")
{
	cvUtil.ccId = "${requestScope._cid}";
	cvUtil.ccName = "${requestScope._cn}";
}

var localMsg = localMsg || {};
localMsg.genericError = "${genericError}";
localMsg.confirmDeleteText = "${confirmDeleteText}";
localMsg.confirmDeleteTitle = "${confirmDeleteTitle}";
localMsg.errorTextShareExpiredUpdate = "${errorTextShareExpiredUpdate}";
localMsg.noEditCapability = "${noEditCapability}";
localMsg.publicLinkUnShareConfirm = "${publicLinkUnShareConfirm}";
localMsg.publicLinkUnShareTitle = "${publicLinkUnShareTitle}";
localMsg.setNewPassword = "${setNewPasswordText}";
localMsg.loadingText = "${loading}";
</script>