<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
       <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
       <%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.BackupBrowseMessages">

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="css/shareInvites.css" name="css" />
		<jsp:param value="Share Invitations" name="titleLocalized" />
		<jsp:param value="Shares:summary/index.do?page=sharedByMeLi" name="breadCrumbValues" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="" name="headerTitleLocalized" />
	</jsp:include>

	<fmt:message key="shareInvites.label.view" var="viewLabel" />
	<fmt:message key="shareInvites.label.edit" var="editLabel" />
	<fmt:message key="shareInvites.label.Allow" var="actionLabel" />
	<fmt:message key="shareInvites.label.Deny" var="denyLabel" />
	<fmt:message key="shareInvites.label.noAccess" var = "noAccessLabel" />

	<div id="allInvites">
		<div id="headTitle"><fmt:message key="shareInvites.label.title" /><span id='shareName'></span></div>
		<div id="iHeader">
			<div class='item'>
				<div class="itemL"><fmt:message key="shareInvites.label.name" /></div><!--
				--><div class="itemM"><fmt:message key="shareInvites.label.permission" /></div><!--
				--><div class="itemR"><fmt:message key="shareInvites.label.action" /></div>
			</div>
		</div>
		<div id="mainInvite"></div>
		<div id="otherInvites"><fmt:message key="shareInvites.label.pendingInvitations" /></div>
		<div id="iList">

		</div>

		<div id="noInvites"><fmt:message key="shareInvites.label.noPendingInvites" /></div>
	</div>


	<jsp:include page="../common/footer.jsp" >
		<jsp:param value="true" name="bootstrapped" />
        <jsp:param value="js/shareInvites.js" name="js" />
	</jsp:include>
</fmt:bundle>

<script type="text/template" id="inviteUsersTemplate">
	{{#inviteList}}
	<div class='item'>
		<div class="itemL">{{name}} ({{email}}) <span class="date">{{requestedTime}}</span></div><!--
		--><div class="itemM"><span class="vPerm pSel" title="Set view permission" data-text="view">${viewLabel}</span> &#124; <span class="ePerm" title="Set edit permission" data-text="edit">${editLabel}</span></div><!--
		--><div class="itemR" data-id="{{userId}}"><a type="button" class="denyButton mainBtn vw-btn vw-btn-secondary">${denyLabel}</a><a type="button" class="allowButton mainBtn vw-btn vw-btn-primary ">${actionLabel}</a></div>
	</div>
	{{/inviteList}}
</script>

<script nonce="${sessionScope.cspNonce}" >
	var shareInvites = shareInvites || {};
	shareInvites.shareId = "${fn:escapeXml(param.s)}";
	shareInvites.shareName = null;
	shareInvites.userId = null;
	shareInvites.action = "${fn:escapeXml(param.o)}";
	var localMsg = localMsg || {};
	localMsg.noAccessLabel = "${noAccessLabel}";
</script>


<c:if test="${not empty param.u}">
	<script nonce="${sessionScope.cspNonce}" >
		shareInvites.userId = "${fn:escapeXml(param.u)}";
	</script>
</c:if>
